/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.BDProperties;
import com.zoo.util.XMLParser;

public class MenuLanguageMap {
    private String defaultButton = null;

    public void ProcessMenuLanguageMap(XMLParser node) {
        int size = node.size();
        String reqLanguage = this.getLanguage(BDProperties.getMenuLanguage());
        for (int i = 0; i < size; ++i) {
            XMLParser element = node.getElement(i);
            String lang = null;
            try {
                lang = element.Attribute.find("language").toLowerCase();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            String button = element.Attribute.find("button");
            if (lang == null || lang.equals("")) {
                this.defaultButton = button;
                break;
            }
            if (!lang.equals(reqLanguage)) continue;
            this.defaultButton = button;
            break;
        }
    }

    public String GetDefaultButton() {
        return this.defaultButton;
    }

    private String getLanguage(int code) {
        String res = "";
        int offset = 16;
        for (int i = 0; i < 3; ++i) {
            int c = code >> offset & 0xFF;
            res = res + new Character((char)c).toString();
            offset -= 8;
        }
        return res;
    }
}

