/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.MenuXlet;
import com.zoo.media.Playitem;
import com.zoo.media.Playlist;
import com.zoo.media.VideoPlayer;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Menu;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.PersistentSettings;
import com.zoo.util.XMLParser;
import java.util.ArrayList;
import org.bluray.media.StreamNotAvailableException;

public class LanguageManager {
    private static ArrayList audioSelectComponent;
    private static ArrayList subtitleSelectComponent;
    private static String defaultAudio;
    private static String defaultSubtitle;
    private static AudioMapEntry[] audioMap;
    private static SubtitleMapEntry[] subtitleMap;
    private static String[] audioStream;
    private static String[] subtitleStream;
    private static String subtitlesOffID;
    private static String currentAudioSelectID;
    private static String currentAudioStreamID;
    private static int currentAudioStreamIndex;
    private static String currentSubtitleSelectID;
    private static String currentSubtitleStreamID;
    private static int currentSubtitleStreamIndex;
    private static boolean currentSubtitleStreamEnabled;
    public static MenuXlet menuXlet;

    public static void init(MenuXlet xlet) {
        menuXlet = xlet;
    }

    public static void setAudioAndsubtitleComponents(ArrayList aSelect, ArrayList sSelect) {
        audioSelectComponent = aSelect;
        subtitleSelectComponent = sSelect;
    }

    public static void processMaps(XMLParser node) {
        for (int i = 0; i < node.size(); ++i) {
            XMLParser subNode = node.getElement(i);
            String t = subNode.getTag();
            if (t.equalsIgnoreCase("languageDefaults")) {
                LanguageManager.loadLanguageDefaults(subNode);
            }
            if (t.equalsIgnoreCase("audiomap")) {
                LanguageManager.loadAudioMap(subNode);
            }
            if (t.equalsIgnoreCase("subtitlemap")) {
                LanguageManager.loadSubtitleMap(subNode);
            }
            if (!t.equalsIgnoreCase("streamconfig")) continue;
            LanguageManager.loadStreamConfig(subNode);
        }
    }

    public static void setDefaultMapping() {
        if (subtitleMap == null || audioMap == null) {
            return;
        }
        if (PersistentSettings.isFirstRun()) {
            LanguageManager.updateStreamMapping();
        } else {
            try {
                LanguageManager.readPersistentSettings();
            }
            catch (Exception e) {
                LanguageManager.updateStreamMapping();
            }
        }
        try {
            LanguageManager.InitialiseIndicators();
        }
        catch (Exception e) {
            LanguageManager.loadLanguageDefaults(null);
            LanguageManager.updateStreamMapping();
            LanguageManager.InitialiseIndicators();
        }
    }

    public static void setAudioSelectID(String audioSelect) {
        Debugging.dmsg("currentAudioSelectID " + currentAudioSelectID);
        currentAudioSelectID = audioSelect;
        Debugging.dmsg("currentAudioSelectID " + currentAudioSelectID);
        LanguageManager.updateStreamMapping();
    }

    public static void setSubtitleSelectID(String subtitleSelect) {
        currentSubtitleSelectID = subtitleSelect;
        LanguageManager.updateStreamMapping();
    }

    public static void setAudioAndSubtitleStreams(Playlist playlist) {
        block91: {
            VideoPlayer player = menuXlet.getVideoPlayer();
            Playitem playitem = playlist.getPlayitem(0);
            if (playlist.isLanguageManaged()) {
                if (PersistentSettings.getBoolean(14) && playitem.getAudioStreams() >= PersistentSettings.getInt(15)) {
                    int temp;
                    Debugging.dmsg("commentary active ");
                    Menu audiomenu = (Menu)audioSelectComponent.get(0);
                    Menu submenu = (Menu)subtitleSelectComponent.get(0);
                    int audioBtns = audiomenu.getButtons().size();
                    int subBtns = submenu.getButtons().size();
                    Debugging.dmsg("audioBtns : " + audioBtns + " -- subBtns : " + subBtns);
                    int numberOfEnglishProductionStreams = 1;
                    try {
                        numberOfEnglishProductionStreams = temp = player.getPlaylist("Feature").getNumberEngAudio();
                    }
                    catch (Exception e) {
                        Debugging.dmsg("No playlist with ID Feature Exists " + e);
                    }
                    try {
                        numberOfEnglishProductionStreams = temp = player.getPlaylist("Episode1").getNumberEngAudio();
                    }
                    catch (Exception e) {
                        Debugging.dmsg("No playlist with ID Episode1 Exists " + e);
                    }
                    if (PersistentSettings.getBoolean(16)) {
                        Debugging.dmsg(" Surfed Don't set commentary");
                        try {
                            if (currentSubtitleStreamEnabled) {
                                player.setSubtitles(currentSubtitleStreamIndex);
                                break block91;
                            }
                            player.setSubtitlesOff(currentSubtitleStreamIndex);
                        }
                        catch (StreamNotAvailableException e) {
                            try {
                                player.setSubtitlesOff(1);
                            }
                            catch (StreamNotAvailableException ex) {
                                Debugging.dmsg(ex.toString());
                            }
                        }
                    } else {
                        if (currentAudioStreamIndex > numberOfEnglishProductionStreams && currentAudioStreamIndex <= audioBtns) {
                            int offset = LanguageManager.findOffsetsForAudioAndSubs(playlist.getCommentarySubtitleStreamOffsetForAudio(PersistentSettings.getInt(15)), currentAudioStreamIndex);
                            try {
                                Debugging.dmsg("1C setting  Comm subtitles on to match production AUDIO of feature offset = " + offset);
                                switch (offset) {
                                    case 666: {
                                        player.setSubtitlesOff(1);
                                        break;
                                    }
                                    default: {
                                        player.setSubtitles(offset);
                                        break;
                                    }
                                }
                            }
                            catch (StreamNotAvailableException e) {
                                Debugging.dmsg("failed to set stream with audio offset on " + (Object)((Object)e));
                                try {
                                    player.setSubtitlesOff(1);
                                }
                                catch (StreamNotAvailableException ex) {
                                    Debugging.dmsg("failed to set 0 off " + (Object)((Object)ex));
                                }
                            }
                        } else if (currentSubtitleStreamEnabled) {
                            int offset = LanguageManager.findOffsetsForAudioAndSubs(playlist.getCommentarySubtitleStreamOffset(PersistentSettings.getInt(15)), currentSubtitleStreamIndex);
                            try {
                                Debugging.dmsg("1 setting subtitles on to match production subtitle of feature offset = " + offset);
                                switch (offset) {
                                    case 666: {
                                        player.setSubtitlesOff(1);
                                        break;
                                    }
                                    default: {
                                        player.setSubtitles(offset);
                                        break;
                                    }
                                }
                            }
                            catch (StreamNotAvailableException e) {
                                Debugging.dmsg("failed to set stream with subtitle offset on " + (Object)((Object)e));
                                try {
                                    player.setSubtitlesOff(1);
                                }
                                catch (StreamNotAvailableException ex) {
                                    Debugging.dmsg("failed to set 0 off " + (Object)((Object)ex));
                                }
                            }
                        } else {
                            try {
                                player.setSubtitlesOff(currentSubtitleStreamIndex);
                            }
                            catch (StreamNotAvailableException ex) {
                                Debugging.dmsg("failed to set currSubtitleStreanIndex off " + (Object)((Object)ex));
                            }
                        }
                        player.setAudio(PersistentSettings.getInt(15));
                    }
                } else {
                    Debugging.dmsg("LM currentAudioStreamIndex : " + currentAudioStreamIndex);
                    Debugging.dmsg("LM currentSubtitleStreamIndex : " + currentSubtitleStreamIndex);
                    Debugging.dmsg("LM currentSubtitleStreamEnabled : " + currentSubtitleStreamEnabled);
                    Debugging.dmsg("LM playitem.getAudioStreams() : " + playitem.getAudioStreams());
                    if (playitem.getAudioStreams() == 1 && currentAudioStreamIndex != 1) {
                        player.setAudio(1);
                        Debugging.dmsg("LM set audio 1");
                    } else {
                        player.setAudio(currentAudioStreamIndex);
                        Debugging.dmsg("LM set audio currentAudioStreamIndex");
                    }
                    if (playitem.getSubtitleStreams() == 1 && currentSubtitleStreamIndex != 1) {
                        try {
                            player.setSubtitlesOff(1);
                        }
                        catch (StreamNotAvailableException e) {}
                    } else {
                        try {
                            if (currentSubtitleStreamEnabled) {
                                player.setSubtitles(currentSubtitleStreamIndex);
                                break block91;
                            }
                            LanguageManager.updateStreamMapping();
                            player.setSubtitlesOff(currentSubtitleStreamIndex);
                        }
                        catch (StreamNotAvailableException e) {}
                    }
                }
            } else if (playlist.isAdvancedAudioAndSubs()) {
                int offset;
                Debugging.dmsg("currentAudioStreamIndex : " + currentAudioStreamIndex);
                Debugging.dmsg("currentSubtitleStreamIndex : " + currentSubtitleStreamIndex);
                Debugging.dmsg("currentSubtitleStreamEnabled : " + currentSubtitleStreamEnabled);
                Menu audiomenu = (Menu)audioSelectComponent.get(0);
                Menu submenu = (Menu)subtitleSelectComponent.get(0);
                int audioBtns = audiomenu.getButtons().size();
                int subBtns = submenu.getButtons().size();
                Debugging.dmsg("audioBtns : " + audioBtns + " -- subBtns : " + subBtns);
                if (currentSubtitleStreamEnabled && currentSubtitleStreamIndex < subBtns) {
                    offset = LanguageManager.findOffsetsForAudioAndSubs(playlist.getSubtitleStreamOffset(), currentSubtitleStreamIndex);
                    try {
                        Debugging.dmsg("1 setting subtitles on to match production subtitle of feature offset = " + offset);
                        switch (offset) {
                            case 666: {
                                player.setSubtitlesOff(1);
                                break;
                            }
                            default: {
                                player.setSubtitles(offset);
                                break;
                            }
                        }
                    }
                    catch (StreamNotAvailableException e) {
                        Debugging.dmsg("failed to set stream with subtitle offset on " + (Object)((Object)e));
                        try {
                            player.setSubtitlesOff(1);
                        }
                        catch (StreamNotAvailableException ex) {
                            Debugging.dmsg("failed to set 0 off " + (Object)((Object)ex));
                        }
                    }
                } else {
                    int temp;
                    int numberOfEnglishProductionStreams = 1;
                    try {
                        numberOfEnglishProductionStreams = temp = player.getPlaylist("Feature").getNumberEngAudio();
                    }
                    catch (Exception e) {
                        Debugging.dmsg("No playlist with ID Feature Exists " + e);
                    }
                    try {
                        numberOfEnglishProductionStreams = temp = player.getPlaylist("Episode1").getNumberEngAudio();
                    }
                    catch (Exception e) {
                        Debugging.dmsg("No playlist with ID Episode1 Exists " + e);
                    }
                    if (currentAudioStreamIndex > numberOfEnglishProductionStreams && currentAudioStreamIndex <= audioBtns) {
                        int offset2 = LanguageManager.findOffsetsForAudioAndSubs(playlist.getSubtitleStreamOffsetForAudio(), currentAudioStreamIndex);
                        try {
                            Debugging.dmsg("2 setting subtitles on to match production AUDIO of feature offset = " + offset2);
                            switch (offset2) {
                                case 666: {
                                    player.setSubtitlesOff(1);
                                    break;
                                }
                                default: {
                                    player.setSubtitles(offset2);
                                    break;
                                }
                            }
                        }
                        catch (StreamNotAvailableException e) {
                            Debugging.dmsg("failed to set stream with audio offset on " + (Object)((Object)e));
                            try {
                                player.setSubtitlesOff(1);
                            }
                            catch (StreamNotAvailableException ex) {
                                Debugging.dmsg("failed to set 0 off " + (Object)((Object)ex));
                            }
                        }
                    } else {
                        int offset3 = LanguageManager.findOffsetsForAudioAndSubs(playlist.getSubtitleStreamOffset(), currentSubtitleStreamIndex);
                        try {
                            Debugging.dmsg("3 setting subtitles off to match production subtitle of feature offset = " + offset3);
                            if (offset3 == 666) {
                                offset3 = 1;
                            }
                            player.setSubtitlesOff(offset3);
                        }
                        catch (StreamNotAvailableException e) {
                            Debugging.dmsg("failed to set stream with sub offset off " + (Object)((Object)e));
                            try {
                                player.setSubtitlesOff(1);
                            }
                            catch (StreamNotAvailableException ex) {
                                Debugging.dmsg("failed to set 0 off " + (Object)((Object)ex));
                            }
                        }
                    }
                }
                offset = LanguageManager.findOffsetsForAudioAndSubs(playlist.getAudioStreamOffset(), currentAudioStreamIndex);
                if (playitem.getAudioStreams() == 1 || playitem.getAudioStreams() < offset) {
                    offset = 1;
                }
                try {
                    Debugging.dmsg("4 setting audio to stream = " + offset);
                    switch (offset) {
                        case 666: {
                            player.setAudio(1);
                            break;
                        }
                        default: {
                            player.setAudio(offset);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Debugging.dmsg("failed to set audio stream with audio offset on " + e);
                    player.setAudio(1);
                }
            } else {
                try {
                    if (playitem.getAudioStreams() != 0) {
                        if (playlist.RNIBStreamID != -1) {
                            player.setAudio(playlist.RNIBStreamID);
                        } else if (playlist.getDefaultAudio() >= 1 && playlist.getDefaultAudio() <= playitem.getAudioStreams()) {
                            player.setAudio(playlist.getDefaultAudio());
                        } else {
                            player.setAudio(1);
                        }
                    }
                    if (playitem.getSubtitleStreams() != 0) {
                        if (playlist.getDefaultSubtitle() >= 1 && playlist.getDefaultSubtitle() <= playitem.getSubtitleStreams()) {
                            if (playlist.getDefaultSubtitleEnable()) {
                                player.setSubtitles(playlist.getDefaultSubtitle());
                            } else {
                                player.setSubtitlesOff(playlist.getDefaultSubtitle());
                            }
                        } else {
                            player.setSubtitlesOff(1);
                        }
                    }
                }
                catch (StreamNotAvailableException streamNotAvailableException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getCurrentSubtitleSelectID() {
        return currentSubtitleSelectID;
    }

    public static String getCurrentAudioSelectID() {
        return currentAudioSelectID;
    }

    public static ArrayList getAudioSelectComponent() {
        return audioSelectComponent;
    }

    public static int getCurrentSubtitleStreamIdx() {
        return currentSubtitleStreamIndex;
    }

    public static boolean getCurrentSubtitleStreamEnabled() {
        return currentSubtitleStreamEnabled;
    }

    public static int getCurrentAudioStreamIdx() {
        return currentAudioStreamIndex;
    }

    public static void setCurrentSubtitleStreamIdx(int Idx) {
        currentSubtitleStreamIndex = Idx;
    }

    public static void setCurrentSubtitleStreamEnabled(boolean Enabled) {
        currentSubtitleStreamEnabled = Enabled;
    }

    public static void setCurrentAudioStreamIdx(int Idx) {
        currentAudioStreamIndex = Idx;
    }

    public static void checkStreamSurfing(Playlist playlist) {
        int subtitleStreamCount;
        int aStream;
        if (playlist == null) {
            return;
        }
        if (!playlist.isLanguageManaged()) {
            return;
        }
        Debugging.dmsg(" checkStreamSurfing - playlist = " + playlist.getID());
        Playitem playitem = playlist.getPlayitem(0);
        if (playitem == null) {
            return;
        }
        int audioStreamCount = playitem.getAudioStreams();
        boolean audioStreamSurfed = false;
        boolean subtitleStreamSurfed = false;
        if (audioStreamCount > 1 && (aStream = BDProperties.getPrimaryAudioStream()) >= 1 && aStream != currentAudioStreamIndex) {
            String id;
            Debugging.dmsg("ESS - user audio stream surfed");
            if (audioStream != null && audioStream.length >= aStream && (id = audioStream[aStream - 1]) != null) {
                String lang = LanguageManager.mapAudioStreamIDToAudioSelectID(id);
                Debugging.dmsg("lang, id, aStream = " + lang + ", " + id + ", " + aStream);
                if (lang != null) {
                    currentAudioSelectID = lang;
                    currentAudioStreamID = id;
                    currentAudioStreamIndex = aStream;
                    LanguageManager.savePersistentSettings();
                    PersistentSettings.setBoolean(14, false);
                    audioStreamSurfed = true;
                }
            }
            if (!audioStreamSurfed) {
                Menu audiomenu = (Menu)audioSelectComponent.get(0);
                Debugging.dmsg("BDProperties.getPrimaryAudioStream() :" + BDProperties.getPrimaryAudioStream() + " audiomenu.getButtons().size() :" + audiomenu.getButtons().size());
                if (BDProperties.getPrimaryAudioStream() > audiomenu.getButtons().size() && BDProperties.getPrimaryAudioStream() < 32) {
                    PersistentSettings.setBoolean(14, true);
                    PersistentSettings.setInt(15, BDProperties.getPrimaryAudioStream());
                } else if (BDProperties.getPrimaryAudioStream() < 32) {
                    PersistentSettings.setBoolean(14, false);
                }
                Debugging.dmsg("ESS - failed to create new audio stream map");
            }
        }
        if ((subtitleStreamCount = playitem.getSubtitleStreams()) > 1) {
            int sStream = BDProperties.getSubtitleStream();
            boolean sStreamEnable = BDProperties.getSubtitleStreamEnabled();
            if (sStream >= 1 && (sStream != currentSubtitleStreamIndex || sStreamEnable != currentSubtitleStreamEnabled)) {
                Debugging.dmsg("ESS - user subtitle stream surfed");
                if (subtitleStream != null && subtitleStream.length >= sStream) {
                    String lang;
                    String id = subtitleStream[sStream - 1];
                    Debugging.dmsg("subtitleStream id " + id);
                    if (id != null && (lang = LanguageManager.mapSubtitleStreamIDToSubtitleSelectID(id, sStreamEnable)) != null) {
                        currentSubtitleSelectID = lang;
                        currentSubtitleStreamID = id;
                        currentSubtitleStreamIndex = sStream;
                        currentSubtitleStreamEnabled = sStreamEnable;
                        subtitleStreamSurfed = true;
                        PersistentSettings.setBoolean(16, true);
                        LanguageManager.savePersistentSettings();
                    }
                }
                if (!subtitleStreamSurfed) {
                    Debugging.dmsg("ESS - failed to create new subtitle stream map");
                    PersistentSettings.setBoolean(16, false);
                }
            }
        }
        if (audioStreamSurfed || subtitleStreamSurfed) {
            // empty if block
        }
        LanguageManager.UpdateIndicators();
    }

    private static void DisplayMap() {
        Debugging.dmsg("ESS - Audio:     SelectID: " + currentAudioSelectID + "   StreamID: " + currentAudioStreamID + "   StreamIndex: " + currentAudioStreamIndex);
        Debugging.dmsg("ESS - Subtitle:  SelectID: " + currentSubtitleSelectID + "   StreamID: " + currentSubtitleStreamID + "," + (currentSubtitleStreamEnabled ? "on" : "off") + "   StreamIndex: " + currentSubtitleStreamIndex + "," + (currentSubtitleStreamEnabled ? "on" : "off"));
    }

    private static void loadStreamConfig(XMLParser node) {
        boolean OK = true;
        if (node.size() == 2) {
            String name;
            XMLParser element;
            int i;
            int size;
            XMLParser subNode = node.findElement("audio");
            if (subNode != null) {
                size = subNode.size();
                audioStream = new String[size];
                for (i = 0; i < size; ++i) {
                    element = subNode.getElement(i);
                    name = element.getTag();
                    if (name == null || !name.equalsIgnoreCase("stream")) {
                        OK = false;
                        continue;
                    }
                    LanguageManager.audioStream[i] = element.Attribute.find("id");
                }
            } else {
                OK = false;
            }
            if ((subNode = node.findElement("subtitle")) != null) {
                size = subNode.size();
                subtitleStream = new String[size];
                for (i = 0; i < size; ++i) {
                    element = subNode.getElement(i);
                    name = element.getTag();
                    if (name == null || !name.equalsIgnoreCase("stream")) {
                        OK = false;
                        continue;
                    }
                    LanguageManager.subtitleStream[i] = element.Attribute.find("id");
                }
            } else {
                OK = false;
            }
        } else {
            OK = false;
        }
        if (!OK) {
            Debugging.dmsg("ESS - stream config map is invalid");
        }
    }

    private static void loadAudioMap(XMLParser node) {
        boolean OK = true;
        int size = node.size();
        audioMap = new AudioMapEntry[size];
        for (int i = 0; i < size; ++i) {
            XMLParser element = node.getElement(i);
            String name = element.getTag();
            if (name == null || !name.equalsIgnoreCase("map")) {
                OK = false;
                break;
            }
            String audioSel = element.Attribute.find("audiosel");
            String audioOut = element.Attribute.find("audioout");
            LanguageManager.audioMap[i] = new AudioMapEntry();
            audioMap[i].audioSelect = audioSel;
            audioMap[i].audioStream = audioOut;
        }
        if (!OK) {
            Debugging.dmsg("ESS - audio map is invalid");
        }
    }

    private static void loadSubtitleMap(XMLParser node) {
        boolean OK = true;
        int size = node.size();
        subtitleMap = new SubtitleMapEntry[size];
        for (int i = 0; i < size; ++i) {
            XMLParser element = node.getElement(i);
            String name = element.getTag();
            if (name == null || !name.equalsIgnoreCase("map")) {
                OK = false;
                break;
            }
            String audioSel = element.Attribute.find("audiosel");
            String subtitleSel = element.Attribute.find("subtitlesel");
            String subtitleOut = element.Attribute.find("subtitleout");
            String[] subtitleOutTokens = null;
            if (subtitleOut != null) {
                subtitleOutTokens = FileUtils.tokenizeString(subtitleOut, ", ");
            }
            LanguageManager.subtitleMap[i] = new SubtitleMapEntry();
            subtitleMap[i].audioSelect = audioSel;
            subtitleMap[i].subtitleSelect = subtitleSel;
            if (subtitleOutTokens == null || subtitleOutTokens.length != 2) continue;
            subtitleMap[i].subtitleStream = subtitleOutTokens[0];
            subtitleMap[i].subtitleEnabled = subtitleOutTokens[1].equalsIgnoreCase("on");
        }
        if (!OK) {
            Debugging.dmsg("ESS - subtitle map is invalid");
        }
        subtitlesOffID = null;
        if (subtitleSelectComponent != null && subtitleSelectComponent.size() >= 1) {
            Menu subtitleComponent = (Menu)subtitleSelectComponent.get(0);
            ArrayList buttons = subtitleComponent.getButtons();
            for (int buttonID = 0; buttonID < buttons.size(); ++buttonID) {
                Button button = (Button)buttons.get(buttonID);
                boolean found = false;
                for (int i = 0; i < subtitleMap.length; ++i) {
                    if (!button.getID().equalsIgnoreCase(subtitleMap[i].subtitleSelect)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                subtitlesOffID = button.getID();
            }
        }
    }

    private static String mapAudioSelectIDToAudioStreamID(String audioLanguage) {
        Debugging.dmsg("audioLanguage = " + audioLanguage);
        if (audioMap == null || audioMap.length == 0) {
            Debugging.dmsg("can't map return");
            return null;
        }
        if (audioLanguage == null) {
            Debugging.dmsg("audioLanguage = null set stream 0");
            return audioMap[0].audioStream;
        }
        for (int i = 0; i < audioMap.length; ++i) {
            if (audioMap[i].audioSelect == null) {
                Debugging.dmsg("audioMap audio select = null return " + i);
                return audioMap[i].audioStream;
            }
            if (!audioLanguage.equalsIgnoreCase(audioMap[i].audioSelect)) continue;
            Debugging.dmsg("audioMap audio select = audioLanguage return " + i);
            return audioMap[i].audioStream;
        }
        Debugging.dmsg("no match return audioMap 0");
        return audioMap[0].audioStream;
    }

    private static SubtitleStreamInfo mapSubtitleSelectIDToSubtitleStreamID(String audioLanguage, String subtitleLanguage) {
        if (subtitleMap == null || subtitleMap.length == 0) {
            return null;
        }
        SubtitleStreamInfo result = new SubtitleStreamInfo();
        if (audioLanguage == null || subtitleLanguage == null) {
            result.streamID = subtitleMap[0].subtitleStream;
            result.enabled = false;
            return result;
        }
        for (int i = 0; i < subtitleMap.length; ++i) {
            if (subtitleMap[i].audioSelect != null) {
                if (subtitleMap[i].subtitleSelect != null) {
                    if (!audioLanguage.equalsIgnoreCase(subtitleMap[i].audioSelect) || !subtitleLanguage.equalsIgnoreCase(subtitleMap[i].subtitleSelect)) continue;
                    result.streamID = subtitleMap[i].subtitleStream;
                    result.enabled = subtitleMap[i].subtitleEnabled;
                    return result;
                }
                if (!audioLanguage.equalsIgnoreCase(subtitleMap[i].audioSelect)) continue;
                result.streamID = subtitleMap[i].subtitleStream;
                result.enabled = subtitleMap[i].subtitleEnabled;
                return result;
            }
            if (subtitleMap[i].subtitleSelect != null) {
                if (!subtitleLanguage.equalsIgnoreCase(subtitleMap[i].subtitleSelect)) continue;
                result.streamID = subtitleMap[i].subtitleStream;
                result.enabled = subtitleMap[i].subtitleEnabled;
                return result;
            }
            result.streamID = subtitleMap[i].subtitleStream;
            result.enabled = subtitleMap[i].subtitleEnabled;
            return result;
        }
        result.streamID = subtitleMap[0].subtitleStream;
        result.enabled = subtitleMap[0].subtitleEnabled;
        return result;
    }

    private static String mapAudioStreamIDToAudioSelectID(String audioStream) {
        if (audioMap == null || audioMap.length == 0) {
            return null;
        }
        if (audioStream == null) {
            return audioMap[0].audioSelect;
        }
        for (int i = 0; i < audioMap.length; ++i) {
            if (audioMap[i].audioStream == null || !audioMap[i].audioStream.equalsIgnoreCase(audioStream)) continue;
            return audioMap[i].audioSelect;
        }
        return audioMap[0].audioSelect;
    }

    private static String mapSubtitleStreamIDToSubtitleSelectID(String subtitleStream, boolean enabled) {
        if (subtitleMap == null || subtitleMap.length == 0) {
            return null;
        }
        if (!enabled || subtitleStream == null) {
            if (subtitlesOffID != null) {
                return subtitlesOffID;
            }
            return subtitleMap[0].subtitleSelect;
        }
        for (int i = 0; i < subtitleMap.length; ++i) {
            if (subtitleMap[i].subtitleStream == null || !subtitleMap[i].subtitleEnabled || !subtitleMap[i].subtitleStream.equalsIgnoreCase(subtitleStream)) continue;
            if (subtitleMap[i].subtitleSelect == null) {
                return subtitlesOffID;
            }
            return subtitleMap[i].subtitleSelect;
        }
        return subtitlesOffID;
    }

    private static void loadLanguageDefaults(XMLParser node) {
        if (node != null) {
            defaultAudio = node.Attribute.find("audio");
            defaultSubtitle = node.Attribute.find("subtitle");
        }
        currentAudioSelectID = defaultAudio;
        currentSubtitleSelectID = defaultSubtitle;
    }

    private static void updateStreamMapping() {
        Debugging.dmsg("updateStreamMapping()");
        if (audioMap != null && subtitleMap != null) {
            currentAudioStreamID = LanguageManager.mapAudioSelectIDToAudioStreamID(currentAudioSelectID);
            SubtitleStreamInfo res = LanguageManager.mapSubtitleSelectIDToSubtitleStreamID(currentAudioSelectID, currentSubtitleSelectID);
            currentSubtitleStreamID = res.streamID;
            currentSubtitleStreamEnabled = res.enabled;
            try {
                currentAudioStreamIndex = LanguageManager.convertAudioStreamIDtoAudioStreamIndex(currentAudioStreamID);
            }
            catch (NumberFormatException e) {
                Debugging.dmsg("updateStreamMapping() Catch Audio stream index");
                currentAudioStreamIndex = 1;
            }
            try {
                currentSubtitleStreamIndex = LanguageManager.convertSubtitleStreamIDtoSubtitleStreamIndex(currentSubtitleStreamID);
            }
            catch (NumberFormatException e) {
                Debugging.dmsg("updateStreamMapping() Catch Sub stream index");
                currentSubtitleStreamIndex = 1;
            }
        } else {
            Debugging.dmsg("updateStreamMapping() Maps Do Not Exist");
            currentAudioStreamIndex = 1;
            currentSubtitleStreamIndex = 1;
        }
        LanguageManager.savePersistentSettings();
    }

    private static int convertAudioStreamIDtoAudioStreamIndex(String id) {
        for (int i = 0; i < audioStream.length; ++i) {
            if (!id.equalsIgnoreCase(audioStream[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private static int convertSubtitleStreamIDtoSubtitleStreamIndex(String id) {
        for (int i = 0; i < subtitleStream.length; ++i) {
            if (!id.equalsIgnoreCase(subtitleStream[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private static int findOffsetsForAudioAndSubs(String playlistOffset, int currIndex) {
        if (playlistOffset == null) {
            return currIndex;
        }
        String[] offsets = FileUtils.tokenizeString(playlistOffset, ";");
        for (int i = offsets.length - 1; i > -1; --i) {
            String[] match = FileUtils.tokenizeString(offsets[i], ",");
            if (currIndex <= Integer.parseInt(match[0])) continue;
            if (Integer.parseInt(match[1]) == 666) {
                return Integer.parseInt(match[1]);
            }
            return currIndex + Integer.parseInt(match[1]);
        }
        return 666;
    }

    private static void savePersistentSettings() {
        PersistentSettings.setString(5, currentAudioSelectID);
        PersistentSettings.setString(6, currentAudioStreamID);
        PersistentSettings.setInt(7, currentAudioStreamIndex);
        PersistentSettings.setString(8, currentSubtitleSelectID);
        PersistentSettings.setString(9, currentSubtitleStreamID);
        PersistentSettings.setInt(10, currentSubtitleStreamIndex);
        PersistentSettings.setBoolean(11, currentSubtitleStreamEnabled);
    }

    private static void readPersistentSettings() {
        currentAudioSelectID = PersistentSettings.getString(5);
        currentAudioStreamID = PersistentSettings.getString(6);
        currentAudioStreamIndex = PersistentSettings.getInt(7);
        currentSubtitleSelectID = PersistentSettings.getString(8);
        currentSubtitleStreamID = PersistentSettings.getString(9);
        currentSubtitleStreamIndex = PersistentSettings.getInt(10);
        currentSubtitleStreamEnabled = PersistentSettings.getBoolean(11);
    }

    public static void UpdateIndicatorsCommentaryStateChange() {
        LanguageManager.UpdateIndicators();
    }

    private static void UpdateIndicators() {
        block9: {
            int compIdx;
            block7: {
                Menu subtitleComponent;
                int compIdx2;
                block8: {
                    if (!PersistentSettings.getBoolean(14)) break block7;
                    Debugging.dmsg("Commentary on");
                    Menu audioComponent = (Menu)audioSelectComponent.get(0);
                    ArrayList buttons = audioComponent.getButtons();
                    for (int i = 0; i < buttons.size(); ++i) {
                        Button b = (Button)buttons.get(i);
                        b.setIndicated(false);
                    }
                    if (!PersistentSettings.getBoolean(16)) break block8;
                    if (subtitleSelectComponent == null || subtitleSelectComponent.size() < 1) break block9;
                    for (compIdx2 = 0; compIdx2 < subtitleSelectComponent.size(); ++compIdx2) {
                        subtitleComponent = (Menu)subtitleSelectComponent.get(compIdx2);
                        subtitleComponent.setIndicator(currentSubtitleSelectID);
                    }
                    break block9;
                }
                if (subtitleSelectComponent == null || subtitleSelectComponent.size() < 1) break block9;
                for (compIdx2 = 0; compIdx2 < subtitleSelectComponent.size(); ++compIdx2) {
                    subtitleComponent = (Menu)subtitleSelectComponent.get(compIdx2);
                    subtitleComponent.setIndicator(subtitlesOffID);
                }
                break block9;
            }
            if (subtitleSelectComponent != null && subtitleSelectComponent.size() >= 1) {
                for (compIdx = 0; compIdx < subtitleSelectComponent.size(); ++compIdx) {
                    Menu subtitleComponent = (Menu)subtitleSelectComponent.get(compIdx);
                    subtitleComponent.setIndicator(currentSubtitleSelectID);
                }
            }
            if (audioSelectComponent != null && audioSelectComponent.size() >= 1) {
                for (compIdx = 0; compIdx < audioSelectComponent.size(); ++compIdx) {
                    Menu audioComponent = (Menu)audioSelectComponent.get(compIdx);
                    audioComponent.setIndicator(currentAudioSelectID);
                }
            }
        }
    }

    public static void InitialiseIndicators() {
        Button b;
        int i;
        ArrayList buttons;
        int compIdx;
        if (subtitleSelectComponent != null && subtitleSelectComponent.size() >= 1) {
            for (compIdx = 0; compIdx < subtitleSelectComponent.size(); ++compIdx) {
                Menu subtitleComponent = (Menu)subtitleSelectComponent.get(compIdx);
                buttons = subtitleComponent.getButtons();
                for (i = 0; i < buttons.size(); ++i) {
                    b = (Button)buttons.get(i);
                    b.setIndicated(false);
                }
                b = subtitleComponent.getButton(currentSubtitleSelectID);
                b.setIndicated(true);
            }
        }
        if (audioSelectComponent != null && audioSelectComponent.size() >= 1) {
            for (compIdx = 0; compIdx < audioSelectComponent.size(); ++compIdx) {
                Menu audioComponent = (Menu)audioSelectComponent.get(compIdx);
                buttons = audioComponent.getButtons();
                for (i = 0; i < buttons.size(); ++i) {
                    b = (Button)buttons.get(i);
                    b.setIndicated(false);
                }
                b = audioComponent.getButton(currentAudioSelectID);
                b.setIndicated(true);
            }
        }
    }

    static {
        defaultAudio = null;
        defaultSubtitle = null;
        subtitlesOffID = null;
        currentAudioSelectID = null;
        currentAudioStreamID = null;
        currentAudioStreamIndex = -1;
        currentSubtitleSelectID = null;
        currentSubtitleStreamID = null;
        currentSubtitleStreamIndex = -1;
        currentSubtitleStreamEnabled = false;
    }

    public static class SubtitleStreamInfo {
        public String streamID;
        public boolean enabled;
    }

    private static class SubtitleMapEntry {
        private String audioSelect;
        private String subtitleSelect;
        private String subtitleStream;
        private boolean subtitleEnabled;

        private SubtitleMapEntry() {
        }
    }

    private static class AudioMapEntry {
        private String audioSelect;
        private String audioStream;

        private AudioMapEntry() {
        }
    }
}

