/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.FileUtils;
import com.zoo.util.ImageMap;
import com.zoo.util.SceneUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImageUtils {
    public static ImageMap cropImage(Image src, String[] coords, String name) {
        int x = 0;
        int y = 0;
        int w = -1;
        int h = -1;
        String key = null;
        for (int i = 0; i < coords.length; ++i) {
            String[] pos_data = FileUtils.tokenizeString(coords[i], ",");
            if (!pos_data[0].equalsIgnoreCase(name)) continue;
            x = Integer.valueOf(pos_data[1]);
            y = Integer.valueOf(pos_data[2]);
            w = Integer.valueOf(pos_data[3]);
            h = Integer.valueOf(pos_data[4]);
            key = pos_data[0];
            break;
        }
        return new ImageMap(src, x, y, w, h, key);
    }

    public static ImageMap cropImageTab(BufferedImage src, String[] coords, String name) {
        int x = 0;
        int y = 0;
        int w = -1;
        int h = -1;
        String key = null;
        for (int i = 0; i < coords.length; ++i) {
            String[] pos_data = FileUtils.tokenizeString(coords[i], "\t");
            if (!pos_data[0].equals(name)) continue;
            x = Integer.valueOf(pos_data[1]);
            y = Integer.valueOf(pos_data[2]);
            w = Integer.valueOf(pos_data[3]);
            h = Integer.valueOf(pos_data[4]);
            key = pos_data[0];
            break;
        }
        return new ImageMap(src, x, y, w, h, key);
    }

    public static synchronized Image loadImage(Component c, String src) {
        Image img = Toolkit.getDefaultToolkit().getImage(src);
        ImageUtils.waitForImage(c, img);
        return img;
    }

    public static synchronized Image[] loadImages(Component c, String[] src) {
        Image[] images = new Image[]{};
        for (int i = 0; i < src.length; ++i) {
            Image img = Toolkit.getDefaultToolkit().getImage(src[i]);
            images = ImageUtils.add(images, img);
        }
        ImageUtils.waitForImages(c, images);
        return images;
    }

    public static Image cropImage(Component c, Image src, int x, int y, int w, int h) {
        CropImageFilter cropFilter = new CropImageFilter(x, y, w, h);
        FilteredImageSource cropFI = new FilteredImageSource(src.getSource(), cropFilter);
        Image img = Toolkit.getDefaultToolkit().createImage(cropFI);
        ImageUtils.waitForImage(c, img);
        return img;
    }

    public static Image scaleImage(Image img, int w, int h) {
        BufferedImage scaled_img = ImageUtils.createResizedCopy(img, w, h);
        Image i = Toolkit.getDefaultToolkit().createImage(scaled_img.getSource());
        return i;
    }

    public static BufferedImage createResizedCopy(Image originalImage, int w, int h) {
        BufferedImage scaledBI = SceneUtils.createBufferedImage(w, h);
        Graphics2D g = scaledBI.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(originalImage, 0, 0, w, h, null);
        g.dispose();
        return scaledBI;
    }

    public static int[] imageToPixelArray(BufferedImage bi, int w, int h) {
        if (w < 0 || h < 0) {
            System.out.println("**Image was not fully loaded.**");
            return new int[1];
        }
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(bi, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return pixels;
    }

    public static BufferedImage blurH(BufferedImage bi, int w, int h, int d) {
        int[] pixels = ImageUtils.imageToPixelArray(bi, w, h);
        return ImageUtils.blurH(pixels, w, h, d);
    }

    public static BufferedImage blurH(int[] pixels, int width, int height, int d) {
        int dimension = (d - 1) / 2;
        int[] newPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x < dimension || x >= width - dimension) {
                    newPixels[x + y * width] = 0;
                    continue;
                }
                int red = 0;
                int green = 0;
                int blue = 0;
                int alpha = 0;
                int numPixels = 0;
                for (int dx = x - dimension; dx <= x + dimension; ++dx) {
                    int c = pixels[dx + y * width];
                    red += c & 0xFF0000;
                    green += c & 0xFF00;
                    blue += c & 0xFF;
                    ++numPixels;
                }
                alpha = pixels[x + y * width] & 0xFF000000;
                red = red / numPixels & 0xFF0000;
                green = green / numPixels & 0xFF00;
                blue = blue / numPixels & 0xFF;
                newPixels[x + y * width] = 0 | alpha | red | green | blue;
            }
        }
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, newPixels, 0, width));
        BufferedImage dimg = SceneUtils.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = dimg.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return dimg;
    }

    public static boolean unloadImage(Component c, Image img) {
        MediaTracker mt = new MediaTracker(c);
        if (img != null) {
            mt.removeImage(img);
            img.flush();
            img = null;
            try {
                mt.waitForAll();
            }
            catch (Exception ex) {
                return false;
            }
            System.gc();
        }
        return true;
    }

    public static boolean waitForImage(Component c, Image image) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    public static boolean waitForImages(Component c, Image[] images) {
        MediaTracker tracker = new MediaTracker(c);
        for (int i = 0; i < images.length; ++i) {
            tracker.addImage(images[i], i);
        }
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    public static Image[] add(Image[] items, Image s) {
        Image[] a = new Image[items.length + 1];
        System.arraycopy(items, 0, a, 0, items.length);
        items = a;
        items[items.length - 1] = s;
        return items;
    }
}

