/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(String file) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {}
        }
        return contents.toString();
    }

    public static File newFile(String filename) {
        File newfile = null;
        try {
            newfile = new File(filename);
            newfile.createNewFile();
        }
        catch (IOException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return newfile;
    }

    public static boolean writeToFile(String filename, String s, boolean append) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, append));
            out.write(s);
            out.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] tokenizeString(String text, String separator) {
        StringTokenizer st = new StringTokenizer(text, separator);
        int numberOfElements = st.countTokens();
        String[] tokens = new String[numberOfElements];
        int h = 0;
        while (st.hasMoreElements()) {
            tokens[h] = st.nextElement().toString();
            ++h;
        }
        return tokens;
    }

    public static Class[] convertToClassArray(String[] tokens) {
        Class[] a = new Class[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            try {
                a[i] = Class.forName(tokens[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
            }
        }
        return a;
    }

    public static String convertToHMS(int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.add(13, time);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        format = time >= 36000 ? new SimpleDateFormat("HH:mm:ss") : (time >= 3600 ? new SimpleDateFormat("H:mm:ss") : (time >= 600 ? new SimpleDateFormat("mm:ss") : new SimpleDateFormat("m:ss")));
        return format.format(calendar.getTime());
    }

    public static String convertToHHMMSS(int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.add(13, time);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.format(calendar.getTime());
    }

    public static String convertToHMMSS(int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.add(13, time);
        SimpleDateFormat format = new SimpleDateFormat("H:mm:ss");
        return format.format(calendar.getTime());
    }

    public static String convertToHHMMSS(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.add(13, (int)((double)time / 1.0E9));
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.format(calendar.getTime());
    }

    public static String convertToMMSS(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.add(13, (int)((double)time / 1.0E9));
        SimpleDateFormat format = new SimpleDateFormat("mm:ss");
        return format.format(calendar.getTime());
    }

    public static double convertToSeconds(String str, double rate) {
        StringTokenizer st = new StringTokenizer(str, ":");
        int numberOfElements = st.countTokens();
        String[] tokens = new String[numberOfElements];
        int i = 0;
        while (st.hasMoreElements()) {
            tokens[i] = st.nextElement().toString();
            ++i;
        }
        int hour = FileUtils.stringToInt(tokens[0]);
        int minute = FileUtils.stringToInt(tokens[1]);
        int second = FileUtils.stringToInt(tokens[2]);
        if (tokens.length == 3) {
            return second + 60 * (minute + 60 * hour);
        }
        double frames = FileUtils.stringToDouble(tokens[3]) / rate;
        return (double)(second + 60 * (minute + 60 * hour)) + frames;
    }

    private static int stringToInt(String foop) {
        try {
            return Integer.valueOf(foop.trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static double stringToDouble(String foop) {
        try {
            return Integer.valueOf(foop.trim()).doubleValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static String toAscii(String hexString) {
        if (hexString.length() % 2 != 0) {
            throw new RuntimeException("String not comprised of Hex digit pairs.");
        }
        char[] chars = new char[hexString.length()];
        char[] convChars = new char[hexString.length() / 2];
        hexString.getChars(0, hexString.length(), chars, 0);
        for (int i = 0; i < hexString.length(); i += 2) {
            String hexToken = new String(chars, i, 2);
            convChars[i / 2] = (char)Integer.parseInt(hexToken, 16);
        }
        return new String(convChars);
    }

    public static String toHexString(String asciiString) {
        char[] ascii = new char[asciiString.length()];
        asciiString.getChars(0, asciiString.length(), ascii, 0);
        StringBuffer hexBuff = new StringBuffer();
        for (int i = 0; i < asciiString.length(); ++i) {
            hexBuff.append(Integer.toHexString(ascii[i]));
        }
        return hexBuff.toString().toUpperCase();
    }

    public static boolean fileExists(String filename) {
        return new File(filename).exists();
    }

    public static boolean DeleteFile(String filename) {
        File target = new File(filename);
        if (target.exists()) {
            return target.delete();
        }
        return true;
    }
}

