/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.MenuXlet;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.PersistentSettings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.StringTokenizer;

public class DiscTrackerManager {
    private static String trackerState = "initial";
    private static String trackerPlaylistID = null;
    private static long trackerTime = 0L;
    private static int trackerPlayMark = 0;
    private static String filepath;
    private static MenuXlet menuXlet;
    public static boolean rejectFurtherInput;
    public static boolean featureAccesedOnce;

    public static void init(String org_id, String app_id, String disc_id, MenuXlet menuXlet) {
        DiscTrackerManager.menuXlet = menuXlet;
        filepath = BDProperties.getPersistentRoot() + File.separator + org_id + File.separator + app_id + File.separator + disc_id + "_dt.txt";
        DiscTrackerManager.readDiscTrackerFile();
        if (trackerState.equalsIgnoreCase("off")) {
            DiscTrackerManager.setTrackerState("initial");
            DiscTrackerManager.setFeatureAccesedOnce(false);
            Debugging.dmsg("DiscTrackerManager.init(): OFF DISCTRACKER");
        }
        if (trackerState.equalsIgnoreCase("playback")) {
            DiscTrackerManager.setTrackerState("resumeable");
            PersistentSettings.setString(3, trackerPlaylistID);
            DiscTrackerManager.setFeatureAccesedOnce(true);
            Debugging.dmsg("DiscTrackerManager.init(): ON DISCTRACKER");
        } else if (trackerState.equalsIgnoreCase("resumeable")) {
            DiscTrackerManager.setFeatureAccesedOnce(true);
        }
    }

    public static void saveDiscTrackerFile() {
        try {
            File target = new File(filepath);
            if (target.exists()) {
                target.delete();
            }
            String s = "";
            s = s + "trackerState=";
            s = s + trackerState;
            s = s + ",";
            s = s + "trackerPlaylistID=";
            s = s + trackerPlaylistID;
            s = s + ",";
            s = s + "trackerTime=";
            s = s + trackerTime;
            s = s + ",";
            s = s + "trackerPlayMark=";
            s = s + trackerPlayMark;
            Debugging.dmsg("SAVE PREF: " + s);
            BufferedWriter out = new BufferedWriter(new FileWriter(filepath, false));
            out.write(s);
            out.close();
        }
        catch (Exception e) {
            Debugging.dmsg("DiscTrackerManager.saveDisckTracker(): " + e);
        }
    }

    public static void readDiscTrackerFile() {
        try {
            File target = new File(filepath);
            if (target.exists()) {
                String s = FileUtils.readFromFile(filepath);
                String[] tokens = FileUtils.tokenizeString(s, ",");
                for (int i = 0; i < tokens.length; ++i) {
                    StringTokenizer props = new StringTokenizer(tokens[i], "=");
                    String name = props.nextElement().toString();
                    String value = props.nextElement().toString();
                    Debugging.dmsg(name + ": " + value);
                    if ("trackerState".equalsIgnoreCase(name)) {
                        trackerState = value;
                        continue;
                    }
                    if ("trackerTime".equalsIgnoreCase(name)) {
                        trackerTime = Long.parseLong(value);
                        continue;
                    }
                    if ("trackerPlayMark".equalsIgnoreCase(name)) {
                        trackerPlayMark = Integer.parseInt(value);
                        continue;
                    }
                    if (!"trackerPlaylistID".equalsIgnoreCase(name)) continue;
                    trackerPlaylistID = value;
                }
            }
        }
        catch (Exception e) {
            Debugging.dmsg("DiscTrackerManager.readTrackerFile(): " + e);
        }
    }

    public static void clear() {
        try {
            File target = new File(filepath);
            if (target.exists()) {
                target.delete();
            }
        }
        catch (Exception exception1) {
            Debugging.dmsg(exception1.toString());
        }
        trackerState = "initial";
        trackerTime = 0L;
        trackerPlaylistID = null;
        Debugging.dmsg("CLEAR Tracker");
    }

    public static String getTrackerState() {
        return trackerState;
    }

    public static void setTrackerState(String s) {
        if (rejectFurtherInput) {
            return;
        }
        trackerState = s;
    }

    public static String getTrackerPlaylistID() {
        return trackerPlaylistID;
    }

    public static void setTrackerPlaylistID(String p) {
        Debugging.dmsg("setTrackerPlaylistID(): " + p);
        trackerPlaylistID = p;
    }

    public static long getTrackerTime() {
        return trackerTime;
    }

    public static boolean isFeatureAccesedOnce() {
        return featureAccesedOnce;
    }

    public static void setFeatureAccesedOnce(boolean flag) {
        featureAccesedOnce = flag;
    }

    private static boolean playerStateValid() {
        return menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable() && menuXlet.getVideoPlayer().getCurrentPlaylist().getPlaylistID() == BDProperties.getPlaylistNumber() && menuXlet.getVideoPlayer().getPlayer().getRate() != 0.0f && menuXlet.getVideoPlayer().getPlayer().getMediaNanoseconds() != 0L;
    }

    public static void setTrackerTime(long t) {
        if (rejectFurtherInput) {
            return;
        }
        if (!DiscTrackerManager.playerStateValid()) {
            return;
        }
        trackerTime = t;
        PersistentSettings.setLong(2, trackerTime);
    }

    public static void setTrackerPlayMark(int pm) {
        if (rejectFurtherInput) {
            return;
        }
        if (!DiscTrackerManager.playerStateValid()) {
            return;
        }
        if (pm > 200) {
            return;
        }
        trackerPlayMark = pm;
        PersistentSettings.setInt(4, trackerPlayMark);
    }

    public static void setTrackerPlayMarkWithoutVailidation(int pm) {
        trackerPlayMark = pm;
        PersistentSettings.setInt(4, trackerPlayMark);
    }

    public static int getTrackerPlayMark() {
        return trackerPlayMark;
    }

    static {
        rejectFurtherInput = false;
        featureAccesedOnce = false;
    }
}

