/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.media.Playitem;
import com.zoo.media.Playlist;
import com.zoo.media.VideoPlayer;
import java.awt.Font;
import java.util.ArrayList;
import org.dvb.test.DVBTest;
import org.dvb.ui.FontFactory;

public class Debugging {
    public static final int BDPLAYER = 0;
    public static final int MENUVIEWER = 1;
    private static int playbackEnv = 0;
    private static boolean displayMessages = false;
    private static ArrayList debugMessages = new ArrayList();
    private static boolean displayOnPlayer = false;
    private static Font debugFont = null;

    public static void enableDisplayMessages() {
        displayMessages = true;
    }

    public static void disableDisplayMessages() {
        displayMessages = false;
    }

    public static boolean isOn() {
        return displayMessages;
    }

    public static boolean displayOnPlayer() {
        return displayOnPlayer;
    }

    public static void dmsg(String strMsg) {
        if (displayMessages) {
            try {
                switch (playbackEnv) {
                    case 0: {
                        DVBTest.log((String)"DEBUG: ", (String)strMsg);
                        break;
                    }
                    case 1: {
                        System.out.println(strMsg);
                    }
                }
                if (debugMessages.size() >= 20) {
                    debugMessages.remove(0);
                }
                debugMessages.add(strMsg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setPlaybackEnv(int i) {
        playbackEnv = i;
    }

    public static int getPlaybackEnv() {
        return playbackEnv;
    }

    public static ArrayList getDebugMessages() {
        return debugMessages;
    }

    public static Font getFont() {
        if (debugFont == null) {
            try {
                FontFactory ff = new FontFactory();
                debugFont = ff.createFont("Futura Lt BT", 0, 18);
            }
            catch (Exception e1) {
                debugFont = new Font("Dialog", 0, 12);
            }
        }
        return debugFont;
    }

    public static void displayTitleInformation(VideoPlayer videoPlayer) {
        int playlistCount = videoPlayer.getPlaylistCount();
        for (int playlistIdx = 0; playlistIdx < playlistCount; ++playlistIdx) {
            Playlist playlist = videoPlayer.getPlaylist(playlistIdx);
            Debugging.dmsg("ESS -   Playlist " + playlist.getPlaylistID() + ": " + playlist.getID());
            int playitemCount = playlist.getPlayitemCount();
            for (int playitemIdx = 0; playitemIdx < playitemCount; ++playitemIdx) {
                Playitem playitem = playlist.getPlayitem(playitemIdx);
                Debugging.dmsg("ESS -     PlayItem " + playitemIdx + ": Audio Streams = " + playitem.getAudioStreams() + "    Subtitle streams = " + playitem.getSubtitleStreams());
            }
        }
    }
}

