/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import java.util.Enumeration;
import org.bluray.application.AppAttributes;
import org.bluray.system.RegisterAccess;
import org.bluray.ti.DiscManager;
import org.dvb.application.AppsDatabase;
import org.dvb.application.AppsDatabaseFilter;
import org.dvb.application.CurrentServiceFilter;

public class BDProperties {
    public static int clockBase = 45000;

    public static String getVFSRoot() {
        return System.getProperty("bluray.vfs.root");
    }

    public static String getBindingUnitRoot() {
        return System.getProperty("bluray.bindingunit.root");
    }

    public static String getPersistentRoot() {
        return System.getProperty("dvb.persistent.root");
    }

    public static String getDiscID() {
        return DiscManager.getDiscManager().getCurrentDisc().getId();
    }

    public static String isProfile1Supported() {
        return System.getProperty("bluray.profile.1");
    }

    public static String isProfile2Supported() {
        return System.getProperty("bluray.profile.2");
    }

    public static boolean isPiPSupported() {
        int profile = (RegisterAccess.getInstance().getPSR(31) & 0xF0000) >>> 16;
        return profile > 0;
    }

    public static int getPrimaryAudioStream() {
        return RegisterAccess.getInstance().getPSR(1);
    }

    public static int getSubtitleStream() {
        return RegisterAccess.getInstance().getPSR(2) & 0xFFF;
    }

    public static boolean getSubtitleStreamEnabled() {
        return (RegisterAccess.getInstance().getPSR(2) & Integer.MIN_VALUE) != 0;
    }

    public static int getAngleNumber() {
        return RegisterAccess.getInstance().getPSR(3);
    }

    public static int getTitleNumber() {
        return RegisterAccess.getInstance().getPSR(4);
    }

    public static int getChapterNumber() {
        return RegisterAccess.getInstance().getPSR(5);
    }

    public static int getPlaylistNumber() {
        return RegisterAccess.getInstance().getPSR(6);
    }

    public static int getPlayItemNumber() {
        return RegisterAccess.getInstance().getPSR(7);
    }

    public static int getPresentationTime() {
        return RegisterAccess.getInstance().getPSR(8);
    }

    public static int getAudioCapability() {
        return RegisterAccess.getInstance().getPSR(15);
    }

    public static int getAudioLanguage() {
        return RegisterAccess.getInstance().getPSR(16);
    }

    public static int getSubtitleLanguage() {
        return RegisterAccess.getInstance().getPSR(17);
    }

    public static int getPlayerRegion() {
        return RegisterAccess.getInstance().getPSR(20) & 0xFF;
    }

    public static int getPlayerParentalSetting() {
        return RegisterAccess.getInstance().getPSR(13) & 0xFF;
    }

    public static int getMenuLanguage() {
        return RegisterAccess.getInstance().getPSR(18);
    }

    public static int getVideoCapability() {
        return RegisterAccess.getInstance().getPSR(29);
    }

    public static int getTextCapability() {
        return RegisterAccess.getInstance().getPSR(30);
    }

    public static String getCurrentJARName() {
        Enumeration attrs;
        try {
            AppsDatabase appDB = AppsDatabase.getAppsDatabase();
            attrs = appDB.getAppAttributes((AppsDatabaseFilter)new CurrentServiceFilter());
        }
        catch (Exception e) {
            return "00000";
        }
        String result = "00000";
        if (attrs != null) {
            while (attrs.hasMoreElements()) {
                AppAttributes info = (AppAttributes)attrs.nextElement();
                result = (String)info.getProperty("dvb.j.location.base");
            }
        }
        return result;
    }
}

