/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components.custom;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Icon;
import com.zoo.ui.components.Menu;
import com.zoo.util.FileUtils;
import com.zoo.util.XMLParser;

public class Timeline
extends Menu {
    char[] hh = new char[]{' ', ' '};
    char[] mm = new char[]{' ', ' '};
    char[] ss = new char[]{' ', ' '};
    int rate = 0;

    public Timeline(XMLParser node, MenuXlet menuXlet) {
        super(node, menuXlet);
    }

    public void render() {
        Icon icon;
        int newPage;
        long[] timelineData;
        boolean forceRate = false;
        try {
            timelineData = this.menuXlet.getVideoPlayer().getTimelineData();
        }
        catch (Exception e) {
            super.render();
            return;
        }
        int newRate = (int)timelineData[2];
        if (this.rate != newRate && newRate == -1) {
            this.hide();
            super.render();
            return;
        }
        if (this.rate != newRate && this.rate == -1) {
            this.show();
            this.hh[0] = 32;
            this.hh[1] = 32;
            this.mm[0] = 32;
            this.mm[1] = 32;
            this.ss[0] = 32;
            this.ss[1] = 32;
            this.currPage = 0;
        }
        if ((newPage = (int)timelineData[1]) != 0 && this.currPage != newPage) {
            for (int i = 0; i < this.getIcons().size(); ++i) {
                icon = (Icon)this.getIcons().get(i);
                if (icon.getPage() == 0 || icon.getPage() != this.currPage && icon.getPage() != newPage) continue;
                icon.changed = true;
            }
            this.currPage = newPage;
            forceRate = true;
        }
        String[] digits = FileUtils.tokenizeString(FileUtils.convertToHHMMSS(timelineData[0]), ":");
        char[] newHH = digits[0].toCharArray();
        char[] newMM = digits[1].toCharArray();
        char[] newSS = digits[2].toCharArray();
        if (newHH[0] != this.hh[0]) {
            this.hh[0] = newHH[0];
            icon = this.getIcon("h2");
            icon.setupImageMaps("0" + this.hh[0]);
            icon.changed = true;
        }
        if (newHH[1] != this.hh[1]) {
            this.hh[1] = newHH[1];
            icon = this.getIcon("h1");
            icon.setupImageMaps("0" + this.hh[1]);
            icon.changed = true;
        }
        if (newMM[0] != this.mm[0]) {
            this.mm[0] = newMM[0];
            icon = this.getIcon("m2");
            icon.setupImageMaps("0" + this.mm[0]);
            icon.changed = true;
        }
        if (newMM[1] != this.mm[1]) {
            this.mm[1] = newMM[1];
            icon = this.getIcon("m1");
            icon.setupImageMaps("0" + this.mm[1]);
            icon.changed = true;
        }
        if (newSS[0] != this.ss[0]) {
            this.ss[0] = newSS[0];
            icon = this.getIcon("s2");
            icon.setupImageMaps("0" + this.ss[0]);
            icon.changed = true;
        }
        if (newSS[1] != this.ss[1]) {
            this.ss[1] = newSS[1];
            icon = this.getIcon("s1");
            icon.setupImageMaps("0" + this.ss[1]);
            icon.changed = true;
        }
        if (newRate != this.rate || forceRate) {
            this.rate = newRate;
            icon = this.getIcon("rate_0" + this.currPage);
            if (this.rate == 0) {
                icon.setupImageMaps("ps");
            } else if (this.rate == 2) {
                icon.setupImageMaps("ff");
            } else if (this.rate == 3) {
                icon.setupImageMaps("rr");
            } else {
                icon.setupImageMaps("pl");
            }
            icon.changed = true;
        }
        super.render();
    }
}

