/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components.custom;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Icon;
import com.zoo.ui.components.Menu;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.XMLParser;

public class InMenuTimeline
extends Menu {
    char[] hh = new char[]{' ', ' '};
    char[] mm = new char[]{' ', ' '};
    char[] ss = new char[]{' ', ' '};
    int rate = -2;
    int chapter = 0;

    public InMenuTimeline(XMLParser node, MenuXlet menuXlet) {
        super(node, menuXlet);
    }

    public void show() {
        this.chapter = 0;
        this.rate = -2;
        super.show();
    }

    public void render() {
        Icon icon;
        int newChapter;
        long[] timelineData;
        if (!this.visible) {
            super.render();
            return;
        }
        boolean forceTime = false;
        try {
            timelineData = this.menuXlet.getVideoPlayer().getTimelineData();
        }
        catch (Exception e) {
            super.render();
            return;
        }
        int newRate = (int)timelineData[2];
        if (this.rate != newRate && newRate == -1) {
            this.rate = newRate;
            this.hide();
            this.visible = true;
            super.render();
            return;
        }
        if (newRate == -1) {
            super.render();
            return;
        }
        if (this.rate != newRate && this.rate == -1) {
            this.show();
            this.hh[0] = 32;
            this.hh[1] = 32;
            this.mm[0] = 32;
            this.mm[1] = 32;
            this.ss[0] = 32;
            this.ss[1] = 32;
            this.chapter = 0;
        }
        if ((newChapter = (int)timelineData[1]) != 0 && this.chapter != newChapter) {
            boolean bgx = false;
            for (int i = 0; i < this.getIcons().size(); ++i) {
                icon = (Icon)this.getIcons().get(i);
                if (icon.getID().startsWith("MM_TL_Marker_") || icon.getID().startsWith("MM_TL_increment_") || icon.getID().startsWith("MM_TL_Rate_") && icon.isVisible()) {
                    icon.setVisible(false);
                    icon.changed = true;
                }
                if (icon.getID().equals("MM_TL_Marker_" + newChapter) || icon.getID().equals("MM_TL_increment_" + newChapter) || icon.getID().equals("MM_TL_Rate_" + newChapter)) {
                    if (icon.getID().equals("MM_TL_Rate_" + newChapter)) {
                        if (this.rate == 0) {
                            icon.setupImageMaps("TimeLine_InMenu_MM_TL_Pause");
                        } else if (this.rate == 2) {
                            icon.setupImageMaps("TimeLine_InMenu_MM_Forward");
                        } else if (this.rate == 3) {
                            icon.setupImageMaps("TimeLine_InMenu_MM_Rewind");
                        } else {
                            try {
                                Icon playIcon = this.getIcon("MM_TL_Play");
                                Debugging.dmsg("Play icon image map " + playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                                icon.setupImageMaps(playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                            }
                            catch (Exception e) {
                                Debugging.dmsg("no icon TimeLine_InMenu_MM_Play: " + e);
                            }
                        }
                    }
                    icon.setVisible(true);
                    icon.changed = true;
                }
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable() || !icon.getID().equals("MM_TL_Rate_" + newChapter)) continue;
                icon.setVisible(false);
                icon.changed = true;
            }
            this.chapter = newChapter;
            forceTime = true;
            this.menuXlet.getLayoutManager().reflectAllMenus();
        }
        if (newRate != this.rate || newRate == 0 && this.menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable()) {
            try {
                this.rate = newRate;
                icon = this.getIcon("MM_TL_Rate");
                if (icon == null) {
                    icon = this.getIcon("MM_TL_Rate_" + this.chapter);
                }
                if (this.rate == 0) {
                    icon.setupImageMaps("TimeLine_InMenu_MM_TL_Pause");
                } else if (this.rate == 2) {
                    icon.setupImageMaps("TimeLine_InMenu_MM_TL_Forward");
                } else if (this.rate == 3) {
                    icon.setupImageMaps("TimeLine_InMenu_MM_TL_Rewind");
                } else {
                    try {
                        Icon playIcon = this.getIcon("MM_TL_Play");
                        Debugging.dmsg("Play icon image map " + playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                        icon.setupImageMaps(playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                    }
                    catch (Exception e) {
                        Debugging.dmsg("no icon TimeLine_InMenu_MM_TL_Play: " + e);
                    }
                }
                icon.changed = true;
            }
            catch (Exception ex) {
                Debugging.dmsg("no icon rate in InMenuTimeline: " + ex);
            }
        }
        String[] digits = FileUtils.tokenizeString(FileUtils.convertToHHMMSS(timelineData[0]), ":");
        char[] newHH = digits[0].toCharArray();
        char[] newMM = digits[1].toCharArray();
        char[] newSS = digits[2].toCharArray();
        if (newHH[0] != this.hh[0] || forceTime) {
            this.hh[0] = newHH[0];
            icon = this.getIcon("h2");
            try {
                icon.setupImageMaps("TimeLine_InMenu_MM_TL_" + this.hh[0]);
                icon.setW(this.getIcon("MM_TL_" + this.hh[0]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("no such image h0 type 2: " + Ex);
                icon.setupImageMaps("Timeline_inMenu_MM_" + this.hh[0]);
                icon.setW(this.getIcon("MM_" + this.hh[0]).getW());
            }
            icon.changed = true;
        }
        if (newHH[1] != this.hh[1] || forceTime) {
            this.hh[1] = newHH[1];
            icon = this.getIcon("h1");
            try {
                icon.setupImageMaps("TimeLine_InMenu_MM_TL_" + this.hh[1]);
                icon.setW(this.getIcon("MM_TL_" + this.hh[1]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("no such image h1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_inMenu_MM_" + this.hh[1]);
                icon.setW(this.getIcon("MM_" + this.hh[1]).getW());
            }
            icon.changed = true;
        }
        if (newMM[0] != this.mm[0] || forceTime) {
            this.mm[0] = newMM[0];
            icon = this.getIcon("m2");
            try {
                icon.setupImageMaps("TimeLine_InMenu_MM_TL_" + this.mm[0]);
                icon.setW(this.getIcon("MM_TL_" + this.mm[0]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("no such image m1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_inMenu_MM_" + this.mm[0]);
                icon.setW(this.getIcon("MM_" + this.mm[0]).getW());
            }
            icon.changed = true;
        }
        if (newMM[1] != this.mm[1] || forceTime) {
            this.mm[1] = newMM[1];
            icon = this.getIcon("m1");
            try {
                icon.setupImageMaps("TimeLine_InMenu_MM_TL_" + this.mm[1]);
                icon.setW(this.getIcon("MM_TL_" + this.mm[1]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("no such image m1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_inMenu_MM_" + this.mm[1]);
                icon.setW(this.getIcon("MM_" + this.mm[1]).getW());
            }
            icon.changed = true;
        }
        if (newSS[0] != this.ss[0] || forceTime) {
            this.ss[0] = newSS[0];
            icon = this.getIcon("s2");
            try {
                icon.setupImageMaps("TimeLine_InMenu_MM_TL_" + this.ss[0]);
                icon.setW(this.getIcon("MM_TL_" + this.ss[0]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("no such image s0 type 2: " + Ex);
                icon.setupImageMaps("Timeline_inMenu_MM_" + this.ss[0]);
                icon.setW(this.getIcon("MM_" + this.ss[0]).getW());
            }
            icon.changed = true;
        }
        if (newSS[1] != this.ss[1] || forceTime) {
            this.ss[1] = newSS[1];
            icon = this.getIcon("s1");
            try {
                icon.setupImageMaps("TimeLine_InMenu_MM_TL_" + this.ss[1]);
                icon.setW(this.getIcon("MM_TL_" + this.ss[1]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("no such image s1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_inMenu_MM_" + this.ss[1]);
                icon.setW(this.getIcon("MM_" + this.ss[1]).getW());
            }
            icon.changed = true;
        }
        super.render();
    }
}

