/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components.custom;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Menu;
import com.zoo.ui.components.custom.FlashingIcon;
import com.zoo.util.FileUtils;
import com.zoo.util.XMLParser;
import java.util.Timer;
import java.util.TimerTask;

public class FlashingMenu
extends Menu {
    protected String flashUp;
    protected String flashDown;
    protected String flashLeft;
    protected String flashRight;
    protected String flashEnter;
    protected String flashIcon;
    protected Timer ffTimer;
    protected int key;

    public FlashingMenu(XMLParser node, MenuXlet menuXlet) {
        super(node, menuXlet);
        this.flashUp = node.Attribute.find("flashUp");
        this.flashDown = node.Attribute.find("flashDown");
        this.flashLeft = node.Attribute.find("flashLeft");
        this.flashRight = node.Attribute.find("flashRight");
        this.flashEnter = node.Attribute.find("flashEnter");
    }

    public void userEventReceived(int key) {
        if (this.flashIcon != null) {
            return;
        }
        this.key = key;
        String expression = null;
        switch (key) {
            case 37: {
                this.flashIcon = this.flashLeft;
                expression = this.currSelect.getLeft();
                break;
            }
            case 39: {
                this.flashIcon = this.flashRight;
                expression = this.currSelect.getRight();
                break;
            }
            case 38: {
                this.flashIcon = this.flashUp;
                expression = this.currSelect.getUp();
                break;
            }
            case 40: {
                this.flashIcon = this.flashDown;
                expression = this.currSelect.getDown();
                break;
            }
            case 10: {
                this.flashIcon = this.flashEnter;
                expression = this.currSelect.getEnter();
            }
        }
        boolean doFlash = false;
        if (expression != null) {
            String[] expressionTokens = FileUtils.tokenizeString(expression, ",");
            if (expressionTokens[0].equalsIgnoreCase("updateSelect")) {
                Button newSelect;
                if (expressionTokens.length == 2 && (newSelect = this.getButton(expressionTokens[1])).getPage() != 0 && this.currPage != newSelect.getPage()) {
                    doFlash = true;
                }
            } else {
                doFlash = true;
            }
        }
        if (this.flashIcon != null && doFlash) {
            String[] iconTokens = FileUtils.tokenizeString(this.flashIcon, ",");
            switch (iconTokens.length) {
                case 1: {
                    ((FlashingIcon)this.getIcon(this.flashIcon)).becomeFlash();
                    break;
                }
                case 2: {
                    this.getIcon(iconTokens[0]).setVisible(true);
                    this.getIcon(iconTokens[1]).setVisible(false);
                }
            }
            if (this.ffTimer != null) {
                this.ffTimer.cancel();
            }
            this.ffTimer = new Timer();
            this.ffTimer.schedule((TimerTask)new FinishFlashTask(), 200L);
        } else {
            if (this.selected && this.currSelect != null) {
                this.currSelect.userEventReceived(key);
            }
            this.flashIcon = null;
        }
    }

    class FinishFlashTask
    extends TimerTask {
        FinishFlashTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ((FlashingMenu)FlashingMenu.this).menuXlet.getLayoutManager().keyPressMonitor;
            synchronized (object) {
                String[] iconTokens = FileUtils.tokenizeString(FlashingMenu.this.flashIcon, ",");
                switch (iconTokens.length) {
                    case 1: {
                        ((FlashingIcon)FlashingMenu.this.getIcon(FlashingMenu.this.flashIcon)).becomeNormal();
                        break;
                    }
                    case 2: {
                        FlashingMenu.this.getIcon(iconTokens[0]).setVisible(false);
                        FlashingMenu.this.getIcon(iconTokens[1]).setVisible(true);
                    }
                }
                if (FlashingMenu.this.selected && FlashingMenu.this.currSelect != null) {
                    FlashingMenu.this.currSelect.userEventReceived(FlashingMenu.this.key);
                }
                FlashingMenu.this.flashIcon = null;
            }
        }
    }
}

