/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components.custom;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Icon;
import com.zoo.ui.components.Menu;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.XMLParser;

public class FeatureTimeline
extends Menu {
    char[] hh = new char[]{' ', ' '};
    char[] mm = new char[]{' ', ' '};
    char[] ss = new char[]{' ', ' '};
    int rate = -2;
    int chapter = 0;
    int h1Offset = 0;
    int h2Offset = 0;
    int m1Offset = 0;
    int m2Offset = 0;
    int s1Offset = 0;
    int s2Offset = 0;
    int c1Offset = 0;
    int c2Offset = 0;

    public FeatureTimeline(XMLParser node, MenuXlet menuXlet) {
        super(node, menuXlet);
        int bgx = 0;
        try {
            bgx = this.getIcon("F_TL_RunningTime_Bgrd_1").getX();
        }
        catch (Exception Ex) {
            try {
                bgx = this.getIcon("time_bg_1").getX();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.h1Offset = this.getIcon("h1").getX() - bgx;
        this.h2Offset = this.getIcon("h2").getX() - bgx;
        this.m1Offset = this.getIcon("m1").getX() - bgx;
        this.m2Offset = this.getIcon("m2").getX() - bgx;
        this.s1Offset = this.getIcon("s1").getX() - bgx;
        this.s2Offset = this.getIcon("s2").getX() - bgx;
        this.c1Offset = this.getIcon("c1").getX() - bgx;
        this.c2Offset = this.getIcon("c2").getX() - bgx;
    }

    public void show() {
        long[] timelineData = new long[]{0L, 0L, 0L};
        try {
            timelineData = this.menuXlet.getVideoPlayer().getTimelineData();
        }
        catch (Exception e) {
            // empty catch block
        }
        int currChapter = (int)timelineData[1];
        if (currChapter < 1 || currChapter > this.menuXlet.getLayoutManager().getMenu(this.menuXlet.getVideoPlayer().getPlaylist("Feature").getTimeline() + "_SS").getButtons().size()) {
            return;
        }
        Icon bg = null;
        try {
            bg = this.getIcon("F_TL_RunningTime_Bgrd_" + currChapter);
        }
        catch (Exception Ex) {
            try {
                bg = this.getIcon("time_bg_" + currChapter);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bg == null && this.getIcon("F_TL_RunningTime_Bgrd_1") != null && this.getIcon("time_bg_1") != null) {
            return;
        }
        this.chapter = 0;
        this.rate = -2;
        super.show();
    }

    public void render() {
        Icon icon;
        int newChapter;
        long[] timelineData;
        if (!this.visible) {
            super.render();
            return;
        }
        boolean forceTime = false;
        try {
            timelineData = this.menuXlet.getVideoPlayer().getTimelineData();
        }
        catch (Exception e) {
            super.render();
            return;
        }
        int newRate = (int)timelineData[2];
        if (this.rate != newRate && newRate == -1) {
            this.hide();
            super.render();
            return;
        }
        if (this.rate != newRate && this.rate == -1) {
            this.show();
            this.hh[0] = 32;
            this.hh[1] = 32;
            this.mm[0] = 32;
            this.mm[1] = 32;
            this.ss[0] = 32;
            this.ss[1] = 32;
            this.chapter = 0;
        }
        if ((newChapter = (int)timelineData[1]) != 0 && this.chapter != newChapter && newChapter <= this.menuXlet.getLayoutManager().getMenu(this.menuXlet.getVideoPlayer().getPlaylist("Feature").getTimeline() + "_SS").getButtons().size()) {
            int i;
            int bgx = 0;
            for (i = 0; i < this.getIcons().size(); ++i) {
                icon = (Icon)this.getIcons().get(i);
                if ((icon.getID().startsWith("Thumb_") || icon.getID().startsWith("Marker_") || icon.getID().startsWith("title_") || icon.getID().startsWith("title_bg_") || icon.getID().startsWith("time_bg_") || icon.getID().startsWith("F_TL_RunningTime_Bgrd_") || icon.getID().startsWith("F_TL_increment_") || icon.getID().startsWith("F_TL_Thumb_") || icon.getID().startsWith("F_TL_Marker_") || icon.getID().startsWith("F_TL_Rate_") || icon.getID().startsWith("F_TL_ChapterName_") || icon.getID().startsWith("F_TL_ChapterName_Bgrd_")) && icon.isVisible()) {
                    icon.setVisible(false);
                    icon.changed = true;
                    continue;
                }
                if (icon.getID().equals("Thumb_" + newChapter) || icon.getID().equals("Marker_" + newChapter) || icon.getID().equals("title_" + newChapter) || icon.getID().equals("title_bg_" + newChapter) || icon.getID().equals("F_TL_RunningTime_Bgrd_" + newChapter) || icon.getID().equals("F_TL_increment_" + newChapter) || icon.getID().equals("F_TL_Thumb_" + newChapter) || icon.getID().equals("F_TL_Marker_" + newChapter) || icon.getID().equals("F_TL_Rate_" + newChapter) || icon.getID().equals("F_TL_ChapterName_" + newChapter) || icon.getID().equals("F_TL_ChapterName_Bgrd_" + newChapter)) {
                    if (icon.getID().equals("F_TL_Rate_" + newChapter)) {
                        if (this.rate == 0) {
                            icon.setupImageMaps("TimeLine_InFeature_F_TL_Pause");
                        } else if (this.rate == 2) {
                            icon.setupImageMaps("TimeLine_InFeature_F_TL_Forward");
                        } else if (this.rate == 3) {
                            icon.setupImageMaps("TimeLine_InFeature_F_TL_Rewind");
                        } else {
                            try {
                                Icon playIcon = this.getIcon("F_TL_Play");
                                icon.setupImageMaps(playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    icon.setVisible(true);
                    icon.changed = true;
                    continue;
                }
                if (!icon.getID().equals("time_bg_" + newChapter) && !icon.getID().equals("F_TL_RunningTime_Bgrd_" + newChapter)) continue;
                icon.setVisible(true);
                icon.changed = true;
                bgx = icon.getX();
            }
            if (bgx == 0 && (this.getIcon("F_TL_RunningTime_Bgrd_1") != null || this.getIcon("time_bg_1") != null)) {
                Debugging.dmsg("bgx == 0 hide");
                this.hide();
                super.render();
                return;
            }
            for (i = 0; i < this.getIcons().size(); ++i) {
                icon = (Icon)this.getIcons().get(i);
                if (icon.getID().equals("s1")) {
                    icon.setX(bgx + this.s1Offset);
                    continue;
                }
                if (icon.getID().equals("s2")) {
                    icon.setX(bgx + this.s2Offset);
                    continue;
                }
                if (icon.getID().equals("m1")) {
                    icon.setX(bgx + this.m1Offset);
                    continue;
                }
                if (icon.getID().equals("m2")) {
                    icon.setX(bgx + this.m2Offset);
                    continue;
                }
                if (icon.getID().equals("h1")) {
                    icon.setX(bgx + this.h1Offset);
                    continue;
                }
                if (icon.getID().equals("h2")) {
                    icon.setX(bgx + this.h2Offset);
                    continue;
                }
                if (icon.getID().equals("c1")) {
                    icon.setX(bgx + this.c1Offset);
                    continue;
                }
                if (!icon.getID().equals("c2")) continue;
                icon.setX(bgx + this.c2Offset);
            }
            this.chapter = newChapter;
            forceTime = true;
        }
        if (newRate != this.rate) {
            this.rate = newRate;
            Debugging.dmsg("newRate =: " + this.rate + " chapter =: " + this.chapter);
            icon = null;
            try {
                icon = this.getIcon("F_TL_Rate");
                if (icon == null) {
                    icon = this.getIcon("F_TL_Rate_" + this.chapter);
                }
                if (icon == null) {
                    icon = this.getIcon("rate");
                }
            }
            catch (Exception ex) {
                Debugging.dmsg("No Rate icon");
                icon = null;
            }
            if (icon != null) {
                if (icon.getID().equalsIgnoreCase("rate")) {
                    if (this.rate == 0) {
                        icon.setupImageMaps("BD_Timeline_Pause");
                    } else if (this.rate == 2) {
                        icon.setupImageMaps("BD_Timeline_Forward");
                    } else if (this.rate == 3) {
                        icon.setupImageMaps("BD_Timeline_Rewind");
                    } else {
                        icon.setupImageMaps("BD_Timeline_Play");
                    }
                } else if (this.rate == 0) {
                    icon.setupImageMaps("TimeLine_InFeature_F_TL_Pause");
                } else if (this.rate == 2) {
                    icon.setupImageMaps("TimeLine_InFeature_F_TL_Forward");
                } else if (this.rate == 3) {
                    icon.setupImageMaps("TimeLine_InFeature_F_TL_Rewind");
                } else {
                    try {
                        Icon playIcon = this.getIcon("F_TL_Play");
                        Debugging.dmsg("Play icon image map " + playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                        icon.setupImageMaps(playIcon.getImageMap().key.substring(0, playIcon.getImageMap().key.length() - 4));
                    }
                    catch (Exception e) {
                        Debugging.dmsg("no icon TimeLine_InFeature_F_TL_Play: " + e);
                    }
                }
            }
            if (icon != null) {
                icon.changed = true;
            }
        }
        String[] digits = FileUtils.tokenizeString(FileUtils.convertToHHMMSS(timelineData[0]), ":");
        char[] newHH = digits[0].toCharArray();
        char[] newMM = digits[1].toCharArray();
        char[] newSS = digits[2].toCharArray();
        if (newHH[0] != this.hh[0] || forceTime) {
            this.hh[0] = newHH[0];
            icon = this.getIcon("h2");
            try {
                icon.setupImageMaps("TimeLine_InFeature_F_TL_" + this.hh[0]);
                icon.setW(this.getIcon("F_TL_" + this.hh[0]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("FT no such image h0 type 2: " + Ex);
                icon.setupImageMaps("Timeline_standalone_TL_" + this.hh[0]);
                icon.setW(this.getIcon("TL_" + this.hh[0]).getW());
            }
            icon.changed = true;
        }
        if (newHH[1] != this.hh[1] || forceTime) {
            this.hh[1] = newHH[1];
            icon = this.getIcon("h1");
            try {
                icon.setupImageMaps("TimeLine_InFeature_F_TL_" + this.hh[1]);
                icon.setW(this.getIcon("F_TL_" + this.hh[1]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("FT no such image h1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_standalone_TL_" + this.hh[1]);
                icon.setW(this.getIcon("TL_" + this.hh[1]).getW());
            }
            icon.changed = true;
        }
        if (newMM[0] != this.mm[0] || forceTime) {
            this.mm[0] = newMM[0];
            icon = this.getIcon("m2");
            try {
                icon.setupImageMaps("TimeLine_InFeature_F_TL_" + this.mm[0]);
                icon.setW(this.getIcon("F_TL_" + this.mm[0]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("FT no such image m1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_standalone_TL_" + this.mm[0]);
                icon.setW(this.getIcon("TL_" + this.mm[0]).getW());
            }
            icon.changed = true;
        }
        if (newMM[1] != this.mm[1] || forceTime) {
            this.mm[1] = newMM[1];
            icon = this.getIcon("m1");
            try {
                icon.setupImageMaps("TimeLine_InFeature_F_TL_" + this.mm[1]);
                icon.setW(this.getIcon("F_TL_" + this.mm[1]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("FT no such image m1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_standalone_TL_" + this.mm[1]);
                icon.setW(this.getIcon("TL_" + this.mm[1]).getW());
            }
            icon.changed = true;
        }
        if (newSS[0] != this.ss[0] || forceTime) {
            this.ss[0] = newSS[0];
            icon = this.getIcon("s2");
            try {
                icon.setupImageMaps("TimeLine_InFeature_F_TL_" + this.ss[0]);
                icon.setW(this.getIcon("F_TL_" + this.ss[0]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("FT no such image s0 type 2: " + Ex);
                icon.setupImageMaps("Timeline_standalone_TL_" + this.ss[0]);
                icon.setW(this.getIcon("TL_" + this.ss[0]).getW());
            }
            icon.changed = true;
        }
        if (newSS[1] != this.ss[1] || forceTime) {
            this.ss[1] = newSS[1];
            icon = this.getIcon("s1");
            try {
                icon.setupImageMaps("TimeLine_InFeature_F_TL_" + this.ss[1]);
                icon.setW(this.getIcon("F_TL_" + this.ss[1]).getW());
            }
            catch (Exception Ex) {
                Debugging.dmsg("FT no such image s1 type 2: " + Ex);
                icon.setupImageMaps("Timeline_standalone_TL_" + this.ss[1]);
                icon.setW(this.getIcon("TL_" + this.ss[1]).getW());
            }
            icon.changed = true;
        }
        super.render();
    }
}

