/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components.custom;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Menu;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.XMLParser;

public class CarouselMenu
extends Menu {
    protected int carouselStart;
    protected int carouselEnd;
    private String direction = "null";

    public CarouselMenu(XMLParser node, MenuXlet menuXlet) {
        super(node, menuXlet);
        String ceValue;
        String csValue = node.Attribute.find("carouselStart");
        if (csValue != null) {
            this.carouselStart = Integer.parseInt(csValue);
        }
        if ((ceValue = node.Attribute.find("carouselEnd")) != null) {
            this.carouselEnd = Integer.parseInt(ceValue);
        }
    }

    public void updateSelect(String id, boolean isPreview) {
        for (int i = 0; i < this.getButtons().size(); ++i) {
            Button btn = (Button)this.getButtons().get(i);
            this.hideExtras();
            btn.setSelected(false);
            btn.setActivated(false);
            this.showExtras();
        }
        Button btn = this.getButton(id);
        int bx = btn.getX();
        int space = 60;
        btn.setAllPosition(this.carouselStart, btn.getY());
        btn.setPage(1);
        String[] extras = btn.getAllExtras();
        for (int ii = 0; ii < extras.length; ++ii) {
            if (bx > this.carouselStart) {
                this.getIcon(extras[ii]).setAllPosition(this.getIcon(extras[ii]).getX() - (bx - this.carouselStart), this.getIcon(extras[ii]).getY());
            }
            if (bx < this.carouselStart) {
                this.getIcon(extras[ii]).setAllPosition(this.getIcon(extras[ii]).getX() + (this.carouselStart - bx), this.getIcon(extras[ii]).getY());
            }
            this.getIcon(extras[ii]).setPage(1);
            this.showExtras(btn);
        }
        Button nBtn = btn;
        for (int i = 1; i < this.getButtons().size(); ++i) {
            Button btn1 = this.getButton(this.getNextButton(nBtn, "right"));
            int b1x = btn1.getX();
            Debugging.dmsg("btn1 == " + btn1.getID());
            Debugging.dmsg("btn1 old X== " + btn1.getX());
            btn1.setAllPosition(nBtn.getX() + nBtn.getW() + space, btn1.getY());
            Debugging.dmsg("new X == " + (nBtn.getX() + nBtn.getW() + space));
            int nb1x = btn1.getX();
            if (btn1.getX() + btn1.getW() < this.carouselEnd) {
                btn1.setPage(1);
                btn1.setVisible(true);
            } else {
                btn1.setPage(2);
                btn1.setVisible(false);
            }
            String[] extras1 = btn1.getAllExtras();
            for (int ii = 0; ii < extras.length; ++ii) {
                if (b1x > nb1x) {
                    this.getIcon(extras1[ii]).setAllPosition(this.getIcon(extras1[ii]).getX() - (b1x - nb1x), this.getIcon(extras1[ii]).getY());
                }
                if (b1x < nb1x) {
                    this.getIcon(extras1[ii]).setAllPosition(this.getIcon(extras1[ii]).getX() + (nb1x - b1x), this.getIcon(extras1[ii]).getY());
                }
                this.getIcon(extras1[ii]).setPage(btn1.getPage());
                if (btn1.isVisible()) {
                    this.showExtras(btn1);
                    continue;
                }
                this.hideExtras(btn1);
            }
            if (btn1.isIndicated() && btn1.isVisible()) {
                btn1.setIndicated(true);
            }
            Debugging.dmsg("nBtn_a == " + nBtn.getID());
            nBtn = btn1;
            Debugging.dmsg("nBtn_b == " + nBtn.getID());
        }
        boolean runAction = false;
        if (btn != this.currSelect || btn == this.currSelect && !this.currSelect.isSelected()) {
            runAction = true;
        }
        this.currSelect = btn;
        this.currSelect.setVisible(true);
        this.hideExtras();
        this.currSelect.setActivated(false);
        this.currSelect.setSelected(true);
        this.showExtras();
        if (this.currSelect.isIndicated()) {
            this.currSelect.setIndicated(true);
        }
        this.selected = true;
        if (runAction && !isPreview) {
            this.currSelect.runSelectedAction();
        }
    }

    public void userEventReceived(int key) {
        if (this.selected && this.currSelect != null) {
            switch (key) {
                case 37: {
                    this.direction = "left";
                    break;
                }
                case 39: {
                    this.direction = "right";
                    break;
                }
                default: {
                    this.direction = "null";
                }
            }
            this.currSelect.userEventReceived(key);
            Debugging.dmsg("uER direction == " + this.direction);
        }
    }

    private String getNextButton(Button btn, String direction) {
        String btnDir = null;
        btnDir = direction.equalsIgnoreCase("right") ? btn.getRight() : btn.getLeft();
        String[] btnCmds = FileUtils.tokenizeString(btnDir, ";");
        for (int i = 0; i < btnCmds.length; ++i) {
            String[] btnCmd = FileUtils.tokenizeString(btnCmds[i], ",");
            if (!btnCmd[0].startsWith("updateSelect")) continue;
            return btnCmd[1];
        }
        return null;
    }
}

