/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components;

import com.zoo.MenuXlet;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.ImageMap;
import com.zoo.util.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Preloader
implements Runnable {
    private static final int delay = 200;
    private static int count = 0;
    private int x = 0;
    private int y = 0;
    private int w = -1;
    private int h = -1;
    private int index = 0;
    public static boolean visible = false;
    private MenuXlet menuXlet;
    private Image mosaic = null;
    private String[] coords;
    private ArrayList imagemaps;
    private Thread preloaderThread;

    public Preloader(MenuXlet menuXlet) {
        this.menuXlet = menuXlet;
        this.mosaic = menuXlet.getResourceManager().loadBitmap("preloader.png");
        this.coords = menuXlet.getResourceManager().loadCoordinates("preloader.txt");
        if (this.coords.length == 0) {
            Debugging.dmsg("No Preloader");
            return;
        }
        this.imagemaps = new ArrayList();
        for (int j = 0; j < this.coords.length; ++j) {
            Debugging.dmsg("coords" + this.coords.toString());
            String[] s = FileUtils.tokenizeString(this.coords[j], ",");
            this.imagemaps.add(ImageUtils.cropImage(this.mosaic, this.coords, s[0]));
        }
        count = this.coords.length - 1;
        if (this.imagemaps.size() > 0) {
            this.w = ((ImageMap)this.imagemaps.get((int)0)).w;
            this.h = ((ImageMap)this.imagemaps.get((int)0)).h;
            this.x = (1920 - this.w) / 2;
            this.y = (1080 - this.h) / 2;
        }
        this.preloaderThread = new Thread(this);
        visible = true;
        this.preloaderThread.start();
    }

    public void run() {
        Debugging.dmsg("preloader run()");
        long tm = System.currentTimeMillis();
        while (visible) {
            Debugging.dmsg("preloader run()");
            try {
                this.render();
            }
            catch (Exception e) {
                Debugging.dmsg("could not render preloader: " + e);
            }
            try {
                Thread.sleep(Math.max(0L, (tm += 200L) - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.index < count) {
                ++this.index;
                continue;
            }
            this.index = 0;
        }
        if (this.coords.length != 0) {
            this.render();
        }
    }

    public void end() {
        if (this.coords.length != 0) {
            visible = false;
            try {
                this.preloaderThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void render() {
        this.menuXlet.getDrawingEngine().clearBuffer();
        this.menuXlet.getDrawingEngine().clearSavedRect();
        this.menuXlet.getDrawingEngine().addToDrawRect(new Rectangle(this.x, this.y, this.w, this.h));
        Graphics2D g = (Graphics2D)this.menuXlet.getDrawingEngine().getBuffer().getGraphics();
        if (visible) {
            g.setComposite(AlphaComposite.SrcOver);
            g.setClip(new Rectangle(this.x, this.y, this.w, this.h));
            ImageMap im = (ImageMap)this.imagemaps.get(this.index);
            g.drawImage(im.img, this.x, this.y, this.x + this.w, this.y + this.h, im.x, im.y, im.x + im.w, im.y + im.h, null);
        }
        this.menuXlet.getDrawingEngine().paintScreen();
    }
}

