/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Icon;
import com.zoo.util.Debugging;
import com.zoo.util.MenuLanguageMap;
import com.zoo.util.XMLParser;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class Menu {
    protected MenuXlet menuXlet;
    protected ArrayList icons = new ArrayList();
    protected ArrayList buttons = new ArrayList();
    protected Button currSelect = null;
    protected Button defaultSelect = null;
    protected int currPage = 0;
    protected boolean visible = false;
    protected boolean selected = false;
    protected Rectangle clipRect;
    protected String id;
    protected String link;
    protected int x = 0;
    protected int y = 0;
    private MenuLanguageMap menuLanguageMap = null;
    static /* synthetic */ Class class$com$zoo$util$XMLParser;
    static /* synthetic */ Class class$com$zoo$MenuXlet;

    public String getID() {
        return this.id;
    }

    public static Menu createInstance(XMLParser node, MenuXlet menuXlet) {
        String type = node.Attribute.find("type");
        if (type == null || type.equalsIgnoreCase("Menu")) {
            return new Menu(node, menuXlet);
        }
        try {
            Class<?> cl = Class.forName("com.zoo.ui.components.custom." + type);
            Constructor<?> co = cl.getConstructor(class$com$zoo$util$XMLParser == null ? (class$com$zoo$util$XMLParser = Menu.class$("com.zoo.util.XMLParser")) : class$com$zoo$util$XMLParser, class$com$zoo$MenuXlet == null ? (class$com$zoo$MenuXlet = Menu.class$("com.zoo.MenuXlet")) : class$com$zoo$MenuXlet);
            return (Menu)co.newInstance(node, menuXlet);
        }
        catch (Exception ex) {
            Debugging.dmsg("Error instantiating " + type + ": " + ex);
            return null;
        }
    }

    public Menu(XMLParser node, MenuXlet menuXlet) {
        String defaultSelectID;
        String yValue;
        String xValue;
        this.menuXlet = menuXlet;
        this.id = node.Attribute.find("id");
        for (int i = 0; i < node.size(); ++i) {
            this.addUIElement(node.getElement(i));
        }
        this.link = node.Attribute.find("link");
        if (this.link == null) {
            this.link = "";
        }
        if ((xValue = node.Attribute.find("x")) != null) {
            this.x = Integer.parseInt(xValue);
        }
        if ((yValue = node.Attribute.find("y")) != null) {
            this.y = Integer.parseInt(yValue);
        }
        if ((defaultSelectID = node.Attribute.find("defaultSelect")) != null && defaultSelectID.equals("$menulanguage$")) {
            defaultSelectID = this.menuLanguageMap.GetDefaultButton();
        }
        if (defaultSelectID != null) {
            this.defaultSelect = this.getButton(defaultSelectID);
        }
        if (this.defaultSelect == null && this.buttons.size() >= 1) {
            this.defaultSelect = (Button)this.buttons.get(0);
        }
        this.currSelect = this.defaultSelect;
        if (this.currSelect != null) {
            this.currPage = this.currSelect.getPage();
        }
    }

    protected void addUIElement(XMLParser node) {
        if ("icon".equals(node.getTag())) {
            this.icons.add(Icon.createInstance(node, this.menuXlet));
        } else if ("button".equals(node.getTag())) {
            this.buttons.add(new Button(node, this.menuXlet));
        } else if ("menulanguagemap".equals(node.getTag())) {
            this.ProcessMenuLanguageMap(node);
        }
    }

    private void ProcessMenuLanguageMap(XMLParser node) {
        this.menuLanguageMap = new MenuLanguageMap();
        this.menuLanguageMap.ProcessMenuLanguageMap(node);
    }

    public ArrayList getIcons() {
        return this.icons;
    }

    public ArrayList getButtons() {
        return this.buttons;
    }

    public Button getCurrSelect() {
        return this.currSelect;
    }

    public Icon getElement(String id) {
        int i;
        for (i = 0; i < this.icons.size(); ++i) {
            if (!id.equalsIgnoreCase(((Icon)this.icons.get((int)i)).id)) continue;
            return (Icon)this.icons.get(i);
        }
        for (i = 0; i < this.buttons.size(); ++i) {
            if (!id.equalsIgnoreCase(((Button)this.buttons.get((int)i)).id)) continue;
            return (Button)this.buttons.get(i);
        }
        return null;
    }

    public Icon getIcon(String id) {
        for (int i = 0; i < this.icons.size(); ++i) {
            if (!id.equalsIgnoreCase(((Icon)this.icons.get((int)i)).id)) continue;
            return (Icon)this.icons.get(i);
        }
        return null;
    }

    public Button getButton(String id) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!id.equalsIgnoreCase(((Button)this.buttons.get((int)i)).id)) continue;
            return (Button)this.buttons.get(i);
        }
        return null;
    }

    public void render() {
        try {
            Rectangle res;
            int i;
            Rectangle srcRect = null;
            Graphics2D g = (Graphics2D)this.menuXlet.getDrawingEngine().getBuffer().getGraphics();
            g.setComposite(AlphaComposite.Src);
            Rectangle dRect = g.getClipBounds();
            if (this.clipRect != null) {
                g.setClip(this.clipRect);
            }
            for (i = 0; i < this.icons.size(); ++i) {
                res = ((Icon)this.icons.get(i)).render(g, this.currPage, this.x, this.y);
                if (res == null) continue;
                if (srcRect == null) {
                    srcRect = res;
                    continue;
                }
                srcRect.add(res);
            }
            for (i = 0; i < this.buttons.size(); ++i) {
                res = ((Button)this.buttons.get(i)).render(g, this.currPage, this.x, this.y);
                if (res == null) continue;
                if (srcRect == null) {
                    srcRect = res;
                    continue;
                }
                srcRect.add(res);
            }
            if (srcRect != null) {
                this.menuXlet.getDrawingEngine().addToDrawRect(srcRect);
            }
            g.setClip(dRect);
            g.dispose();
        }
        catch (Exception e) {
            Debugging.dmsg("Menu.render(): " + e);
        }
    }

    public void show() {
        this.visible = true;
        for (int i = 0; i < this.getIcons().size(); ++i) {
            ((Icon)this.getIcons().get(i)).resetVisibility();
        }
        for (int i = 0; i < this.getButtons().size(); ++i) {
            Button button = (Button)this.getButtons().get(i);
            button.resetVisibility();
            if (!button.isIndicated() && !button.isSelected()) continue;
            this.showExtras(button);
        }
    }

    public void hide() {
        int i;
        if (this.currSelect != null) {
            this.currSelect.setSelected(false);
            this.currSelect.setActivated(false);
            if (this.currSelect.getPreview() != null) {
                this.menuXlet.getLayoutManager().getMenu(this.currSelect.getPreview()).hide();
            }
        }
        this.visible = false;
        this.selected = false;
        for (i = 0; i < this.getIcons().size(); ++i) {
            ((Icon)this.getIcons().get(i)).setVisible(false);
        }
        for (i = 0; i < this.getButtons().size(); ++i) {
            ((Button)this.getButtons().get(i)).setVisible(false);
        }
    }

    protected void hideExtras(Button button) {
        String[] extras = button.getExtras();
        for (int i = 0; i < extras.length; ++i) {
            this.getIcon(extras[i]).setVisible(false);
        }
    }

    public void hideExtras() {
        this.hideExtras(this.currSelect);
    }

    public void hideExtras(String id) {
        this.hideExtras(this.getButton(id));
    }

    protected void showExtras(Button button) {
        String[] extras = button.getExtras();
        for (int i = 0; i < extras.length; ++i) {
            this.getIcon(extras[i]).setVisible(true);
        }
    }

    protected void showExtras() {
        this.showExtras(this.currSelect);
    }

    public void showExtras(String id) {
        this.showExtras(this.getButton(id));
    }

    public void becomeActivated() {
        this.hideExtras();
        this.currSelect.setActivated(true);
        this.currSelect.setSelected(false);
        this.showExtras();
        this.selected = false;
    }

    public void becomeSelected() {
        boolean runAction = false;
        if (!this.currSelect.isSelected()) {
            runAction = true;
        }
        this.hideExtras();
        this.currSelect.setActivated(false);
        this.currSelect.setSelected(true);
        this.showExtras();
        this.selected = true;
        if (this.currSelect.getPreview() != null) {
            this.menuXlet.getLayoutManager().getMenu(this.currSelect.getPreview()).show();
        }
        if (runAction) {
            this.currSelect.runSelectedAction();
        }
    }

    public void becomeNone() {
        this.hideExtras();
        this.currSelect.setActivated(false);
        this.currSelect.setSelected(false);
        this.showExtras();
        this.selected = false;
        if (this.currSelect.getPreview() != null) {
            Menu preview = this.menuXlet.getLayoutManager().getMenu(this.currSelect.getPreview());
            preview.updateSelect(preview.getDefaultSelect());
            preview.becomeNone();
            preview.hide();
        }
    }

    protected void setIndicator(Button indicatedButton) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = (Button)this.buttons.get(i);
            if (!button.isIndicated()) continue;
            if (this.visible) {
                this.hideExtras(button);
            }
            button.setIndicated(false);
            if (!this.visible) continue;
            this.showExtras(button);
        }
        indicatedButton.setIndicated(true);
        if (this.visible) {
            this.showExtras(indicatedButton);
        }
    }

    public void setIndicator(String id) {
        this.setIndicator(this.getButton(id));
    }

    public void setIndicator() {
        this.setIndicator(this.currSelect);
    }

    public void updateSelect(String id) {
        this.updateSelect(id, false);
    }

    public void updateSelect(String id, boolean isPreview) {
        if (this.currSelect != null) {
            this.hideExtras();
            this.currSelect.setActivated(false);
            this.currSelect.setSelected(false);
            this.showExtras();
        }
        if (this.currSelect.getPreview() != null) {
            this.menuXlet.getLayoutManager().getMenu(this.currSelect.getPreview()).hide();
        }
        Button newSelect = this.getButton(id);
        boolean runAction = false;
        if (newSelect != this.currSelect || newSelect == this.currSelect && !this.currSelect.isSelected()) {
            runAction = true;
        }
        this.currSelect = newSelect;
        if (this.currSelect.getPage() != 0 && this.currPage != this.currSelect.getPage()) {
            int i;
            for (i = 0; i < this.getButtons().size(); ++i) {
                Button button = (Button)this.getButtons().get(i);
                if (button.getPage() == 0 || button.getPage() != this.currPage && button.getPage() != this.currSelect.getPage()) continue;
                button.changed = true;
            }
            for (i = 0; i < this.getIcons().size(); ++i) {
                Icon icon = (Icon)this.getIcons().get(i);
                if (icon.getPage() == 0 || icon.getPage() != this.currPage && icon.getPage() != this.currSelect.getPage() && !(icon.getPage() < 0 & icon.getPage() + this.currSelect.getPage() != 0) && !(icon.getPage() < 0 & icon.getPage() + this.currPage != 0)) continue;
                icon.changed = true;
            }
            this.currPage = this.currSelect.getPage();
        }
        this.hideExtras();
        this.currSelect.setActivated(false);
        this.currSelect.setSelected(true);
        this.showExtras();
        if (this.currSelect.getPreview() != null) {
            Menu preview = this.menuXlet.getLayoutManager().getMenu(this.currSelect.getPreview());
            this.menuXlet.getActionManager().reflectMenu(preview);
            preview.updateSelect(preview.getDefaultSelect(), true);
            preview.becomeNone();
            preview.show();
        }
        this.selected = true;
        if (runAction && !isPreview) {
            this.currSelect.runSelectedAction();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void userEventReceived(int key) {
        if (this.selected && this.currSelect != null) {
            this.currSelect.userEventReceived(key);
        }
    }

    public String getLinkProperty() {
        return this.link;
    }

    public String getDefaultSelect() {
        return this.defaultSelect.getID();
    }

    public void setDefaultSelect(String select) {
        this.defaultSelect = this.getButton(select);
    }

    public void setCurrPage(int page) {
        this.currPage = page;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

