/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components;

import com.zoo.MenuXlet;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.ImageMap;
import com.zoo.util.XMLParser;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class Icon {
    protected MenuXlet menuXlet;
    protected int x;
    protected int y;
    protected int originalX;
    protected int originalY;
    protected int width;
    protected int height;
    protected int[] arrX;
    protected int[] arrY;
    protected int[] arrW;
    protected int[] arrH;
    protected String id = null;
    protected String key = null;
    protected int page = 0;
    protected float alpha = 1.0f;
    protected float originalAlpha = 1.0f;
    protected boolean defaultVisibility = true;
    protected boolean animate = true;
    protected boolean visible;
    protected ImageMap current = null;
    protected static final String NOR = ".png";
    public boolean changed = false;
    Rectangle cRect;
    static /* synthetic */ Class class$com$zoo$util$XMLParser;
    static /* synthetic */ Class class$com$zoo$MenuXlet;

    public static Icon createInstance(XMLParser node, MenuXlet menuXlet) {
        String type = node.Attribute.find("type");
        if (type == null || type.equalsIgnoreCase("Icon")) {
            return new Icon(node, menuXlet);
        }
        try {
            Class<?> cl = Class.forName("com.zoo.ui.components.custom." + type);
            Constructor<?> co = cl.getConstructor(class$com$zoo$util$XMLParser == null ? (class$com$zoo$util$XMLParser = Icon.class$("com.zoo.util.XMLParser")) : class$com$zoo$util$XMLParser, class$com$zoo$MenuXlet == null ? (class$com$zoo$MenuXlet = Icon.class$("com.zoo.MenuXlet")) : class$com$zoo$MenuXlet);
            return (Icon)co.newInstance(node, menuXlet);
        }
        catch (Exception ex) {
            Debugging.dmsg("Error instantiating " + type + ": " + ex);
            return null;
        }
    }

    public Icon(XMLParser node, MenuXlet menuXlet) {
        this.menuXlet = menuXlet;
        Vector att = node.Attribute.attributes;
        for (int i = 0; i < att.size(); ++i) {
            this.setField((XMLParser.Attribute.attribute)att.get(i));
        }
        this.setupDimensions();
        this.setVisible(false);
    }

    protected void setupDimensions() {
        if (this.arrW == null) {
            this.arrW = new int[1];
            this.arrW[0] = this.menuXlet.getResourceManager().getImageDim(this.key + NOR)[0];
            this.width = this.arrW[0];
        }
        if (this.arrH == null) {
            this.arrH = new int[1];
            this.arrH[0] = this.menuXlet.getResourceManager().getImageDim(this.key + NOR)[1];
            this.height = this.arrH[0];
        }
    }

    protected void setField(XMLParser.Attribute.attribute a) {
        try {
            String name = a.name;
            if ("id".equalsIgnoreCase(name)) {
                this.id = a.value;
            } else if ("key".equalsIgnoreCase(name)) {
                this.key = a.value;
                this.setupImageMaps(this.key);
            } else if ("x".equalsIgnoreCase(name)) {
                String[] args = FileUtils.tokenizeString(a.value, ",");
                this.arrX = new int[args.length];
                for (int i = 0; i < this.arrX.length; ++i) {
                    this.arrX[i] = Integer.parseInt(args[i]);
                }
                this.x = this.originalX = this.arrX[0];
            } else if ("y".equalsIgnoreCase(name)) {
                String[] args = FileUtils.tokenizeString(a.value, ",");
                this.arrY = new int[args.length];
                for (int i = 0; i < this.arrY.length; ++i) {
                    this.arrY[i] = Integer.parseInt(args[i]);
                }
                this.y = this.originalY = this.arrY[0];
            } else if ("width".equalsIgnoreCase(name) || "w".equalsIgnoreCase(name)) {
                String[] args = FileUtils.tokenizeString(a.value, ",");
                this.arrW = new int[args.length];
                for (int i = 0; i < this.arrW.length; ++i) {
                    this.arrW[i] = Integer.parseInt(args[i]);
                }
                this.width = this.arrW[0];
            } else if ("height".equalsIgnoreCase(name) || "h".equalsIgnoreCase(name)) {
                String[] args = FileUtils.tokenizeString(a.value, ",");
                this.arrH = new int[args.length];
                for (int i = 0; i < this.arrH.length; ++i) {
                    this.arrH[i] = Integer.parseInt(args[i]);
                }
                this.height = this.arrH[0];
            } else if ("page".equalsIgnoreCase(name)) {
                this.page = Integer.parseInt(a.value);
            } else if ("visible".equalsIgnoreCase(name)) {
                this.defaultVisibility = !"false".equalsIgnoreCase(a.value);
            } else if ("animate".equalsIgnoreCase(name)) {
                this.animate = !"false".equalsIgnoreCase(a.value);
            } else if ("alpha".equalsIgnoreCase(name)) {
                this.originalAlpha = this.alpha = Float.parseFloat(a.value);
            }
        }
        catch (Throwable e) {
            Debugging.dmsg(this.getClass().getName() + ".setField(): " + e);
        }
    }

    public void setupImageMaps(String key) {
        if (this.menuXlet.getResourceManager() != null) {
            this.current = this.menuXlet.getResourceManager().getImageMap(key + NOR);
        }
    }

    public void setVisible(boolean vis) {
        if (vis != this.visible) {
            this.changed = true;
            this.visible = vis;
        }
    }

    public void setAlpha(float alpha) {
        if (alpha != this.alpha) {
            this.changed = true;
            this.alpha = alpha;
        }
    }

    public float getAlpha() {
        return this.originalAlpha;
    }

    public void setPosition(int x, int y) {
        if (x != this.x || y != this.y) {
            this.changed = true;
            this.x = x;
            this.y = y;
        }
    }

    public void setAllPosition(int x, int y) {
        int i;
        this.changed = true;
        this.x = x;
        this.originalX = x;
        for (i = 0; i < this.arrX.length; ++i) {
            this.arrX[i] = x;
        }
        this.y = y;
        this.originalY = y;
        for (i = 0; i < this.arrY.length; ++i) {
            this.arrY[i] = y;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isAnimating() {
        return this.animate;
    }

    public void resetVisibility() {
        this.setVisible(this.defaultVisibility);
        this.setAlpha(this.getAlpha());
        this.setX(this.getX());
        this.setY(this.getY());
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setPage(int p) {
        this.page = p;
    }

    public int getX() {
        return this.originalX;
    }

    public int getY() {
        return this.originalY;
    }

    public int getCurrentX() {
        return this.x;
    }

    public int getCurrentY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getW() {
        return this.width;
    }

    public int getH() {
        return this.height;
    }

    public void setW(int w) {
        this.width = w;
    }

    public void setH(int h) {
        this.height = h;
    }

    public int get(String name) {
        if ("width".equalsIgnoreCase(name)) {
            return this.width;
        }
        if ("height".equalsIgnoreCase(name)) {
            return this.height;
        }
        return -1;
    }

    public Rectangle getRect() {
        if (this.isVisible()) {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
        return null;
    }

    public Rectangle render(Graphics2D g, int currPage, int offsetX, int offsetY) {
        Rectangle dRect = new Rectangle(this.x + offsetX, this.y + offsetY, this.width, this.height);
        if (this.visible && this.current != null && (this.page == 0 || currPage == this.page || this.page < 0 & this.page + currPage != 0)) {
            Rectangle fRect = g.getClipBounds();
            if (fRect != null && !dRect.intersects(fRect) && !fRect.contains(dRect)) {
                return null;
            }
            try {
                g.setComposite(AlphaComposite.getInstance(3, this.alpha));
                g.setClip(dRect);
                this.drawImage(g, this.current, this.x + offsetX, this.y + offsetY, this.width, this.height, null);
                g.setClip(fRect);
            }
            catch (Exception e) {
                Debugging.dmsg("Icon.render(): e : current" + e + " : " + this.current);
            }
        }
        if (this.changed) {
            this.changed = false;
            if (this.cRect != null) {
                dRect.add(this.cRect);
            }
            this.cRect = dRect;
            return dRect;
        }
        return null;
    }

    protected void drawImage(Graphics2D g, ImageMap im, int sX, int sY, int sW, int sH, ImageObserver obs) {
        Rectangle r = g.getClipBounds();
        int offX = r.x - sX;
        int offY = r.y - sY;
        g.drawImage(im.img, sX + offX, sY + offY, sX + sW + offX, sY + sH + offY, im.x + offX, im.y + offY, im.x + im.w + offX, im.y + im.h + offY, obs);
    }

    public ImageMap getImageMap() {
        return this.current;
    }

    public String getID() {
        return this.id;
    }

    public int getPage() {
        return this.page;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

