/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui.components;

import com.zoo.MenuXlet;
import com.zoo.ui.components.Icon;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.SoundManager;
import com.zoo.util.XMLParser;

public class Button
extends Icon {
    protected static final String NOR = "_N.png";
    protected static final String SEL = "_S.png";
    protected static final String ACT = "_A.png";
    private boolean selected;
    private boolean activated;
    private boolean indicated;
    protected String[] normalExtras;
    protected String[] activatedExtras;
    protected String[] selectedExtras;
    protected String[] indicatedExtras;
    protected String up;
    protected String down;
    protected String left;
    protected String right;
    protected String enter;
    protected String select;
    protected String preview;
    private String[] enterCommand = null;

    public Button(XMLParser node, MenuXlet menuXlet) {
        super(node, menuXlet);
        if (this.activatedExtras == null) {
            this.activatedExtras = new String[0];
        }
        if (this.selectedExtras == null) {
            this.selectedExtras = new String[0];
        }
        if (this.normalExtras == null) {
            this.normalExtras = new String[0];
        }
        if (this.indicatedExtras == null) {
            this.indicatedExtras = new String[0];
        }
        if (this.enter != null) {
            this.enterCommand = FileUtils.tokenizeString(this.enter, ",");
        }
    }

    protected void setupDimensions() {
        int i;
        if (this.arrW == null || this.arrW.length != 3) {
            int[] oldArrW = this.arrW == null ? null : (int[])this.arrW.clone();
            int oldLengthW = this.arrW == null ? 0 : this.arrW.length;
            this.arrW = new int[3];
            for (i = 0; i < oldLengthW; ++i) {
                this.arrW[i] = oldArrW[i];
            }
            switch (oldLengthW) {
                case 0: {
                    this.arrW[0] = this.menuXlet.getResourceManager().getImageDim(this.key + NOR)[0];
                    this.width = this.arrW[0];
                }
                case 1: {
                    this.arrW[1] = this.menuXlet.getResourceManager().getImageDim(this.key + SEL)[0];
                }
                case 2: {
                    this.arrW[2] = this.menuXlet.getResourceManager().getImageDim(this.key + ACT)[0];
                }
            }
        }
        if (this.arrH == null || this.arrH.length != 3) {
            int[] oldArrH = this.arrH == null ? null : (int[])this.arrH.clone();
            int oldLengthH = this.arrH == null ? 0 : this.arrH.length;
            this.arrH = new int[3];
            for (i = 0; i < oldLengthH; ++i) {
                this.arrH[i] = oldArrH[i];
            }
            switch (oldLengthH) {
                case 0: {
                    this.arrH[0] = this.menuXlet.getResourceManager().getImageDim(this.key + NOR)[1];
                    this.height = this.arrH[0];
                }
                case 1: {
                    this.arrH[1] = this.menuXlet.getResourceManager().getImageDim(this.key + SEL)[1];
                }
                case 2: {
                    this.arrH[2] = this.menuXlet.getResourceManager().getImageDim(this.key + ACT)[1];
                }
            }
        }
    }

    protected void setField(XMLParser.Attribute.attribute a) {
        try {
            String name = a.name;
            if ("up".equalsIgnoreCase(name)) {
                this.up = a.value;
            } else if ("down".equalsIgnoreCase(name)) {
                this.down = a.value;
            } else if ("left".equalsIgnoreCase(name)) {
                this.left = a.value;
            } else if ("right".equalsIgnoreCase(name)) {
                this.right = a.value;
            } else if ("enter".equalsIgnoreCase(name)) {
                this.enter = a.value;
            } else if ("select".equalsIgnoreCase(name)) {
                this.select = a.value;
            } else if ("preview".equalsIgnoreCase(name)) {
                this.preview = a.value;
            } else if (name.toLowerCase().endsWith("extras")) {
                String[] extras = FileUtils.tokenizeString(a.value, ",");
                if ("normalExtras".equalsIgnoreCase(name)) {
                    this.normalExtras = (String[])extras.clone();
                } else if ("activatedExtras".equalsIgnoreCase(name)) {
                    this.activatedExtras = (String[])extras.clone();
                } else if ("selectedExtras".equalsIgnoreCase(name)) {
                    this.selectedExtras = new String[extras.length];
                    for (int i = 0; i < extras.length; ++i) {
                        this.selectedExtras[i] = extras[i];
                    }
                } else if ("indicatedExtras".equalsIgnoreCase(name)) {
                    this.indicatedExtras = (String[])extras.clone();
                }
            } else {
                super.setField(a);
            }
        }
        catch (Throwable e) {
            Debugging.dmsg(this.getClass().getName() + ".setField(): " + e);
        }
    }

    public void setupImageMaps(String key) {
        if (this.menuXlet.getResourceManager() != null) {
            this.current = this.menuXlet.getResourceManager().getImageMap(key + NOR);
        }
    }

    private void updateState() {
        this.changed = true;
        if (this.isActivated()) {
            this.current = this.menuXlet.getResourceManager().getImageMap(this.key + ACT);
            this.x = this.arrX.length > 2 ? this.arrX[2] : (this.arrX.length > 1 ? this.arrX[1] : this.arrX[0]);
            this.y = this.arrY.length > 2 ? this.arrY[2] : (this.arrY.length > 1 ? this.arrY[1] : this.arrY[0]);
            this.width = this.arrW[2];
            this.height = this.arrH[2];
        } else if (this.isSelected()) {
            this.current = this.menuXlet.getResourceManager().getImageMap(this.key + SEL);
            this.x = this.arrX.length > 1 ? this.arrX[1] : this.arrX[0];
            this.y = this.arrY.length > 1 ? this.arrY[1] : this.arrY[0];
            this.width = this.arrW[1];
            this.height = this.arrH[1];
        } else {
            this.current = this.menuXlet.getResourceManager().getImageMap(this.key + NOR);
            this.x = this.arrX[0];
            this.y = this.arrY[0];
            this.width = this.arrW[0];
            this.height = this.arrH[0];
        }
    }

    public void resetVisibility() {
        this.setVisible(this.defaultVisibility);
        this.setAlpha(this.getAlpha());
        this.updateState();
    }

    public void setSelected(boolean s) {
        if (s != this.selected) {
            this.selected = s;
            this.updateState();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setActivated(boolean a) {
        if (a != this.activated) {
            this.activated = a;
            this.updateState();
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setIndicated(boolean s) {
        this.indicated = s;
    }

    public boolean isIndicated() {
        return this.indicated;
    }

    public String[] getExtras() {
        String[] extras = new String[(this.activated ? this.activatedExtras.length : 0) + (this.selected && !this.activated ? this.selectedExtras.length : 0) + (!this.activated && !this.selected ? this.normalExtras.length : 0) + (this.indicated && this.indicatedExtras.length > 0 ? 1 : 0)];
        int index = 0;
        if (this.selected) {
            int i = 0;
            while (i < this.selectedExtras.length) {
                extras[index++] = this.selectedExtras[i++];
            }
        } else if (this.activated) {
            int i = 0;
            while (i < this.activatedExtras.length) {
                extras[index++] = this.activatedExtras[i++];
            }
        } else {
            int i = 0;
            while (i < this.normalExtras.length) {
                extras[index++] = this.normalExtras[i++];
            }
        }
        if (this.indicated) {
            if ((this.selected || this.activated) && this.indicatedExtras.length > 1) {
                extras[index++] = this.indicatedExtras[1];
            } else if (this.indicatedExtras.length > 0) {
                extras[index++] = this.indicatedExtras[0];
            }
        }
        return extras;
    }

    public String[] getAllExtras() {
        String[] extras = new String[this.activatedExtras.length + this.selectedExtras.length + this.normalExtras.length + this.indicatedExtras.length];
        int index = 0;
        int i = 0;
        while (i < this.selectedExtras.length) {
            extras[index++] = this.selectedExtras[i++];
        }
        i = 0;
        while (i < this.activatedExtras.length) {
            extras[index++] = this.activatedExtras[i++];
        }
        i = 0;
        while (i < this.normalExtras.length) {
            extras[index++] = this.normalExtras[i++];
        }
        i = 0;
        while (i < this.indicatedExtras.length) {
            extras[index++] = this.indicatedExtras[i++];
        }
        return extras;
    }

    public String[] getIndicatedExtras() {
        return this.indicatedExtras;
    }

    public String[] getSelectedExtras() {
        return this.selectedExtras;
    }

    public void userEventReceived(int key) {
        String expression = null;
        switch (key) {
            case 37: {
                expression = this.left;
                break;
            }
            case 39: {
                expression = this.right;
                break;
            }
            case 38: {
                expression = this.up;
                break;
            }
            case 40: {
                expression = this.down;
                break;
            }
            case 10: {
                SoundManager.soundPlayed = true;
                SoundManager.playActivate();
                expression = this.enter;
            }
        }
        if (expression != null) {
            this.menuXlet.getActionManager().handleActions(expression);
        }
    }

    public void runSelectedAction() {
        if (this.select != null) {
            this.menuXlet.getActionManager().handleActions(this.select);
        }
    }

    public boolean isPlayButton() {
        if (this.enterCommand != null) {
            String[] bActions = FileUtils.tokenizeString(this.getEnter(), ";");
            for (int ii = 0; ii < bActions.length; ++ii) {
                if (!bActions[ii].startsWith("play")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getPlayButtonPlaylist() {
        String[] bActions = FileUtils.tokenizeString(this.getEnter(), ";");
        int play_action_location = 1;
        for (int ii = 0; ii < bActions.length; ++ii) {
            if (!bActions[ii].startsWith("play")) continue;
            play_action_location = ii;
        }
        String[] bAction = FileUtils.tokenizeString(bActions[play_action_location], ",");
        return bAction[1];
    }

    public int getPlayButtonPlaymark() {
        String[] bActions = FileUtils.tokenizeString(this.getEnter(), ";");
        int play_action_location = 1;
        for (int ii = 0; ii < bActions.length; ++ii) {
            if (!bActions[ii].startsWith("play")) continue;
            play_action_location = ii;
        }
        String[] bAction = FileUtils.tokenizeString(bActions[play_action_location], ",");
        return Integer.parseInt(bAction[2]);
    }

    public String getUp() {
        return this.up;
    }

    public String getDown() {
        return this.down;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public String getEnter() {
        return this.enter;
    }

    public String getPreview() {
        return this.preview;
    }
}

