/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui;

import com.zoo.MenuXlet;
import com.zoo.event.TitleChangeManager;
import com.zoo.media.Playlist;
import com.zoo.ui.components.Menu;
import com.zoo.ui.components.Preloader;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.LanguageManager;
import com.zoo.util.PersistentSettings;
import com.zoo.util.ResourceManager;
import com.zoo.util.SoundManager;
import com.zoo.util.XMLParser;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.dvb.event.UserEvent;

public class LayoutManager
implements Runnable {
    private Timer tvTimer = null;
    private ArrayList menus = new ArrayList();
    private Stack menuStack = new Stack();
    private boolean isVisible = false;
    private boolean isRunning = false;
    private boolean stopRendering = false;
    private ArrayList audioSelect = new ArrayList();
    private ArrayList subtitleSelect = new ArrayList();
    public MenuXlet menuXlet;
    private boolean renderingPaused = false;
    private static final long minimumFrameDuration = 16L;
    public final Object keyPressMonitor = new Object();
    private boolean blackedOut = false;
    private UserEvent currentUserEvent = null;
    private final Object userEventLock = new Object();

    public Menu getCurrentMenu() {
        if (this.menuStack.isEmpty()) {
            return null;
        }
        return (Menu)this.menuStack.peek();
    }

    public void pushNewMenu(String id) {
        this.menuStack.push(this.getMenu(id));
    }

    public void popCurrentMenu() {
        this.menuStack.pop();
    }

    public Menu getMenu(String id) {
        for (int i = 0; i < this.menus.size(); ++i) {
            if (!id.equalsIgnoreCase(((Menu)this.menus.get(i)).getID())) continue;
            return (Menu)this.menus.get(i);
        }
        return null;
    }

    public void reflectAllMenus() {
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            Menu menu = (Menu)iterator.next();
            this.menuXlet.getActionManager().reflectMenu(menu);
            if (menu.getLinkProperty().equalsIgnoreCase("scenes") && !menu.isSelected()) {
                menu.updateSelect(menu.getDefaultSelect(), true);
                menu.becomeNone();
                menu.hide();
            }
            if (!menu.getLinkProperty().equalsIgnoreCase("commentary") || menu.isSelected()) continue;
            menu.updateSelect(menu.getDefaultSelect(), true);
            menu.becomeNone();
            menu.hide();
        }
    }

    public void init(MenuXlet xlet) {
        this.menuXlet = xlet;
        new Thread(this).start();
    }

    public void loadLanguageLogic(String langCode) {
        try {
            Debugging.dmsg("Entering loadLanguageLogic");
            this.pauseRendering();
            String layoutFile = "layout.xml";
            if (!langCode.equals("")) {
                layoutFile = "layout_" + langCode + ".xml";
            }
            Debugging.dmsg("layoutFile : " + layoutFile);
            if (!FileUtils.fileExists(ResourceManager.getFileRoot() + layoutFile)) {
                layoutFile = "layout.xml";
            }
            Debugging.dmsg("ESS - Loading layout: " + layoutFile);
            BufferedReader in = new BufferedReader(new FileReader(ResourceManager.getFileRoot() + layoutFile));
            XMLParser xmlroot = new XMLParser(in);
            in.close();
            XMLParser rootNode = xmlroot.findElement("layout");
            XMLParser languageMapperNode = null;
            this.audioSelect.clear();
            this.subtitleSelect.clear();
            for (int i = 0; i < rootNode.size(); ++i) {
                XMLParser subNode = rootNode.getElement(i);
                String t = subNode.getTag();
                if (t.equalsIgnoreCase("languagemap")) {
                    languageMapperNode = subNode;
                    continue;
                }
                if (!t.equalsIgnoreCase("menu") || subNode.Attribute.find("link") == null) continue;
                if (subNode.Attribute.find("link").equalsIgnoreCase("audio")) {
                    this.audioSelect.add(this.getMenu(subNode.Attribute.find("id")));
                    continue;
                }
                if (!subNode.Attribute.find("link").equalsIgnoreCase("subtitle")) continue;
                this.subtitleSelect.add(this.getMenu(subNode.Attribute.find("id")));
            }
            LanguageManager.setAudioAndsubtitleComponents(this.audioSelect, this.subtitleSelect);
            if (languageMapperNode != null) {
                LanguageManager.processMaps(languageMapperNode);
            }
            PersistentSettings.setFirstRun(true);
            LanguageManager.setDefaultMapping();
            PersistentSettings.setFirstRun(false);
            this.resumeRendering();
        }
        catch (Throwable e) {
            Debugging.dmsg("MenuFramework.start(): " + e);
        }
    }

    public void load() {
        try {
            this.pauseRendering();
            String layoutFile = "layout.xml";
            String params = PersistentSettings.getString(0);
            if (!params.equals("")) {
                layoutFile = "layout_" + params + ".xml";
            }
            if (!FileUtils.fileExists(ResourceManager.getFileRoot() + layoutFile)) {
                layoutFile = "layout.xml";
            }
            Debugging.dmsg("ESS - Loading layout: " + layoutFile);
            BufferedReader in = new BufferedReader(new FileReader(ResourceManager.getFileRoot() + layoutFile));
            XMLParser xmlroot = new XMLParser(in);
            in.close();
            XMLParser rootNode = xmlroot.findElement("layout");
            String[] img_src = FileUtils.tokenizeString(rootNode.Attribute.find("im"), ",");
            String[] img_txt = FileUtils.tokenizeString(rootNode.Attribute.find("ic"), ",");
            Debugging.dmsg("attempting to load resources");
            this.menuXlet.getResourceManager().loadImageResources(img_src, img_txt);
            this.addRootItems(rootNode);
            this.resumeRendering();
        }
        catch (Throwable e) {
            Debugging.dmsg("MenuFramework.start(): " + e);
        }
    }

    public void addRootItems(XMLParser node) {
        Debugging.dmsg("# of items to add: " + node.size());
        XMLParser languageMapperNode = null;
        for (int i = 0; i < node.size(); ++i) {
            XMLParser subNode = node.getElement(i);
            String t = subNode.getTag();
            if (t.equalsIgnoreCase("languagemap")) {
                languageMapperNode = subNode;
                continue;
            }
            if (!t.equalsIgnoreCase("menu")) continue;
            Menu m = Menu.createInstance(subNode, this.menuXlet);
            if (m.getLinkProperty().equalsIgnoreCase("audio")) {
                this.audioSelect.add(m);
            }
            if (m.getLinkProperty().equalsIgnoreCase("subtitle")) {
                this.subtitleSelect.add(m);
            }
            this.menus.add(m);
        }
        LanguageManager.setAudioAndsubtitleComponents(this.audioSelect, this.subtitleSelect);
        if (languageMapperNode != null) {
            LanguageManager.processMaps(languageMapperNode);
        }
    }

    public void pauseRendering() {
        this.renderingPaused = true;
    }

    public void resumeRendering() {
        this.renderingPaused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        while (!this.stopRendering) {
            long startTime = System.currentTimeMillis();
            Object object = this.keyPressMonitor;
            synchronized (object) {
                if (!this.renderingPaused && !Preloader.visible) {
                    if (this.menuXlet.getAnimationManager() != null) {
                        this.menuXlet.getAnimationManager().nextFrame();
                    }
                    this.paintScreen();
                }
            }
            long frameDuration = (System.currentTimeMillis() - startTime) % 16L;
            try {
                Thread.sleep(16L - frameDuration);
            }
            catch (InterruptedException e) {
                Debugging.dmsg("LayoutManager.run(): " + e);
            }
        }
        this.isRunning = false;
    }

    public boolean isShowingMenus() {
        return !this.menuStack.empty();
    }

    public void hideMenu() {
        boolean disableTimeline = !this.menuStack.empty() && this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeline() != null && ((Menu)this.menuStack.peek()).getID().equals(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeline() + "_SS");
        this.menuXlet.getVideoPlayer().resizeVideo(0, 0, 1920, 1080);
        while (!this.menuStack.empty()) {
            Menu m = (Menu)this.menuStack.pop();
            m.hide();
        }
        if (!disableTimeline) {
            this.menuXlet.getVideoPlayer().enableTimeline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMenu() {
        Object object = this.keyPressMonitor;
        synchronized (object) {
            this.menuXlet.getVideoPlayer().resizeVideo(0, 0, 1920, 1080);
            while (!this.menuStack.empty()) {
                Menu m = (Menu)this.menuStack.pop();
            }
            for (int i = 0; i < this.menus.size(); ++i) {
                ((Menu)this.menus.get(i)).hide();
            }
            this.paintScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventReceived(final UserEvent e) {
        if (e.getType() != 401) {
            return;
        }
        Object object = this.userEventLock;
        synchronized (object) {
            if (this.currentUserEvent != null) {
                return;
            }
        }
        new Thread(){

            public void run() {
                LayoutManager.this.handleUserEvent(e);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUserEvent(UserEvent e) {
        Object object = this.userEventLock;
        synchronized (object) {
            this.currentUserEvent = e;
        }
        Debugging.dmsg("userEventReceived(UserEvent e)");
        String currentPlaylistId = this.menuXlet.getVideoPlayer().getCurrentPlaylist().getID();
        if (currentPlaylistId.startsWith("Trailer_") && this.menuStack.empty()) {
            this.userEventReceived(461);
            Debugging.dmsg("return 1");
        } else if (currentPlaylistId.startsWith("OptBackground") && e.getCode() == 53 && this.menuXlet.getVideoPlayer().getPlaylist("RNIB_Feature") != null) {
            SoundManager.playChime();
            this.hideMenu();
            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
            this.menuXlet.getVideoPlayer().startPlaylistAtMark("RNIB_Feature", 0, false);
            Debugging.dmsg("return 2");
        } else {
            this.userEventReceived(e.getCode());
        }
        Object object2 = this.userEventLock;
        synchronized (object2) {
            this.currentUserEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventReceived(int key) {
        Debugging.dmsg("userEventReceived(int key)");
        Object object = this.keyPressMonitor;
        synchronized (object) {
            if (this.menuXlet.getVideoPlayer().getCurrentPlaylist() != null && !this.menuXlet.getVideoPlayer().getTimelineShowing()) {
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeOutDuration() != 0L) {
                    this.setTimer(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeOutDuration());
                } else {
                    this.setTimer();
                }
            }
            if (key == 461) {
                String actions;
                if (this.menuXlet.getVideoPlayer().getLockoutPopup()) {
                    return;
                }
                if (this.menuStack.empty() || this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeline() != null && ((Menu)this.menuStack.peek()).getID().equals(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeline() + "_SS")) {
                    if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeOutDuration() != 0L) {
                        this.setTimer(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getTimeOutDuration());
                    } else {
                        this.setTimer();
                    }
                    this.menuXlet.getVideoPlayer().disableTimeline();
                    actions = this.menuXlet.getVideoPlayer().getCurrentPlaylist().getOnPopUpOn();
                    if (actions != null) {
                        this.menuXlet.getActionManager().handleActions(actions);
                    }
                } else {
                    actions = this.menuXlet.getVideoPlayer().getCurrentPlaylist().getOnPopUpOff();
                    if (actions != null) {
                        this.menuXlet.getActionManager().handleActions(actions);
                    }
                    this.menuXlet.getVideoPlayer().enableTimeline();
                }
            }
            if (key == 10 && this.menuXlet.getVideoPlayer().getCurrentPlaylist().isMultiAngle() && this.menuStack.empty()) {
                int currAngle = this.menuXlet.getVideoPlayer().getCurrentAngle();
                Debugging.dmsg("currAngle :" + ++currAngle);
                if (currAngle > this.menuXlet.getVideoPlayer().getAvailableAngles()) {
                    currAngle = 1;
                }
                Debugging.dmsg("currAngle :" + currAngle);
                this.menuXlet.getVideoPlayer().setAngle(currAngle);
            } else if (!this.menuStack.empty()) {
                ((Menu)this.menuStack.peek()).userEventReceived(key);
            }
        }
    }

    public void paintScreen() {
        Graphics2D bg = (Graphics2D)this.menuXlet.getDrawingEngine().getBuffer().getGraphics();
        this.menuXlet.getDrawingEngine().clearBuffer();
        if (!this.blackedOut) {
            this.menuXlet.getDrawingEngine().clearSavedRect();
        } else {
            this.menuXlet.getDrawingEngine().addToDrawRect(new Rectangle(0, 0, 1920, 1080));
            this.blackedOut = false;
        }
        Iterator it = this.menus.iterator();
        while (it.hasNext()) {
            ((Menu)it.next()).render();
        }
        this.menuXlet.getDrawingEngine().paintScreen();
    }

    public void blackoutScreen() {
        this.menuXlet.getDrawingEngine().blackoutBuffer();
        this.menuXlet.getDrawingEngine().paintFullScreen();
        this.blackedOut = true;
    }

    public void destroy() {
        this.stopRendering = true;
        this.resetTimer(this.tvTimer);
        while (this.isRunning) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.paintScreen();
        System.gc();
    }

    public void resetTimer(Timer timer) {
        try {
            if (timer != null) {
                timer.cancel();
            }
        }
        catch (Exception e) {
            Debugging.dmsg("could not schedule Timer: " + e);
        }
    }

    public void resetTimer() {
        this.resetTimer(this.tvTimer);
    }

    public void setTimer() {
        this.setTimer(30000L);
    }

    public void setTimer(long delay) {
        this.resetTimer(this.tvTimer);
        try {
            this.tvTimer = new Timer();
            this.tvTimer.schedule((TimerTask)new HideMenuTask(), delay);
        }
        catch (Exception e) {
            Debugging.dmsg("could not schedule Timer: " + e);
        }
    }

    class HideMenuTask
    extends TimerTask {
        HideMenuTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Debugging.dmsg("***pre timerWentOff***");
            Object object = LayoutManager.this.keyPressMonitor;
            synchronized (object) {
                Debugging.dmsg("***timerWentOff***");
                Playlist pl = LayoutManager.this.menuXlet.getVideoPlayer().getCurrentPlaylist();
                if (pl != null && !LayoutManager.this.menuStack.empty()) {
                    Debugging.dmsg("***timerWentOff***");
                    String actions = LayoutManager.this.menuXlet.getVideoPlayer().getCurrentPlaylist().getOnPopUpOff();
                    if (actions != null) {
                        LayoutManager.this.menuXlet.getActionManager().handleActions(actions);
                    }
                }
            }
        }
    }
}

