/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.ui;

import com.zoo.MenuXlet;
import com.zoo.animation.FadeAnimation;
import com.zoo.animation.SlideAnimation;
import com.zoo.event.TitleChangeManager;
import com.zoo.media.Playlist;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Icon;
import com.zoo.ui.components.Menu;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.DiscTrackerManager;
import com.zoo.util.FileUtils;
import com.zoo.util.LanguageManager;
import com.zoo.util.PersistentSettings;
import com.zoo.util.SoundManager;
import com.zoo.util.TitleChanging;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class ActionManager {
    public MenuXlet menuXlet;
    private int stopJapanLogicSwitch = 0;
    private Timer timer = null;
    public boolean BLOCK_RNIB = false;

    public void init(MenuXlet xlet) {
        this.menuXlet = xlet;
    }

    public void handleActions(String expression) {
        String[] expressionTokens = FileUtils.tokenizeString(expression, ";");
        for (int i = 0; i < expressionTokens.length; ++i) {
            if (expressionTokens[i].startsWith("wait,")) {
                long delay = Long.parseLong(expressionTokens[i].substring(5));
                String remainingExpression = "";
                for (int j = i + 1; j < expressionTokens.length; ++j) {
                    remainingExpression = remainingExpression + expressionTokens[j];
                    if (j == expressionTokens.length - 1) continue;
                    remainingExpression = remainingExpression + ";";
                }
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new HandleActionsTask(remainingExpression), delay);
                return;
            }
            this.handleAction(expressionTokens[i]);
        }
    }

    private void handleAction(String expression) {
        String[] expressionTokens = FileUtils.tokenizeString(expression, ",");
        Debugging.dmsg("ExpressionTokens = " + expressionTokens[0]);
        if (expressionTokens.length > 0) {
            String command = expressionTokens[0];
            if (command.equalsIgnoreCase("updateSelect")) {
                if (expressionTokens.length == 2) {
                    this.updateSelect(expressionTokens[1]);
                }
            } else if (command.equalsIgnoreCase("updateMenu")) {
                switch (expressionTokens.length) {
                    case 1: {
                        this.updateMenu();
                        break;
                    }
                    case 2: {
                        this.updateMenu(expressionTokens[1], false, false);
                        break;
                    }
                    case 3: {
                        this.updateMenu(expressionTokens[1], expressionTokens[2], false);
                    }
                }
            } else if (command.equalsIgnoreCase("updateMenuAndHide")) {
                switch (expressionTokens.length) {
                    case 2: {
                        this.updateMenu(expressionTokens[1], true, false);
                        break;
                    }
                    case 3: {
                        this.updateMenu(expressionTokens[1], expressionTokens[2], true);
                    }
                }
            } else if (command.equalsIgnoreCase("waitUntilMediaTimeGreaterThan")) {
                long lapsedMediaTime = Long.parseLong(expressionTokens[1]);
                while (this.menuXlet.getVideoPlayer().getPlayer().getMediaNanoseconds() / 1000000L < lapsedMediaTime) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            } else if (command.equalsIgnoreCase("updateMenuPreviewed")) {
                switch (expressionTokens.length) {
                    case 2: {
                        this.updateMenu(expressionTokens[1], false, true);
                    }
                }
            } else if (command.equalsIgnoreCase("disctracker")) {
                Debugging.dmsg("Playlist to play = " + expressionTokens[2]);
                this.menuXlet.setState(4);
                if (this.menuXlet.getLayoutManager().getCurrentMenu().getLinkProperty().equalsIgnoreCase("commentary") && this.menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable()) {
                    LanguageManager.checkStreamSurfing(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                } else {
                    Debugging.dmsg("DiscTrackerManager.getTrackerState() = " + DiscTrackerManager.getTrackerState());
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("resumeable")) {
                        this.setPlayOnceBlock(this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]), "setBlock");
                    }
                    Debugging.dmsg("Playlist to play = " + expressionTokens[2]);
                    Debugging.dmsg("Playlist is played once? " + this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed());
                    if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed()) {
                        expressionTokens[2] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist();
                    }
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("resumeable") && DiscTrackerManager.getTrackerPlaylistID().equalsIgnoreCase(expressionTokens[2])) {
                        Debugging.dmsg("DiscTracker show menu ids match ");
                        switch (expressionTokens.length) {
                            case 4: {
                                this.updateMenu(expressionTokens[1], false, false);
                                break;
                            }
                            case 5: {
                                this.updateMenu(expressionTokens[1], expressionTokens[2], false);
                            }
                        }
                    } else {
                        Debugging.dmsg("DiscTracker DON'T show menu ids DON'T match " + DiscTrackerManager.getTrackerPlaylistID() + " != " + expressionTokens[2]);
                        if (!DiscTrackerManager.getTrackerState().equalsIgnoreCase("off")) {
                            DiscTrackerManager.setTrackerState("playback");
                        }
                        this.menuXlet.getVideoPlayer().setLockoutTimeline(true);
                        this.menuXlet.getLayoutManager().hideMenu();
                        this.menuXlet.getLayoutManager().paintScreen();
                        this.menuXlet.getVideoPlayer().stop();
                        if (expressionTokens[2].startsWith("Feature")) {
                            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        } else if (expressionTokens[2].startsWith("Warnings_prefeature") && TitleChangeManager.getTitleNumber() == 1) {
                            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                        switch (expressionTokens.length) {
                            case 4: {
                                Playlist.overrideOnStart(null);
                                this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[2], Integer.parseInt(expressionTokens[3]), true);
                                break;
                            }
                            case 5: {
                                Playlist.overrideOnStart(null);
                                this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[3], Integer.parseInt(expressionTokens[4]), true);
                            }
                        }
                    }
                }
            } else if (command.equalsIgnoreCase("disctrackerWithIntro")) {
                Debugging.dmsg("Playlist to play = " + expressionTokens[2]);
                this.menuXlet.setState(4);
                if (this.menuXlet.getLayoutManager().getCurrentMenu().getLinkProperty().equalsIgnoreCase("commentary") && this.menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable()) {
                    LanguageManager.checkStreamSurfing(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                } else if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("off")) {
                    switch (expressionTokens.length) {
                        case 5: {
                            this.updateMenu(expressionTokens[4], true, false);
                            break;
                        }
                        case 6: {
                            this.updateMenu(expressionTokens[4], expressionTokens[5], true);
                        }
                    }
                } else {
                    Debugging.dmsg("DiscTrackerManager.getTrackerState() = " + DiscTrackerManager.getTrackerState());
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("resumeable")) {
                        this.setPlayOnceBlock(this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]), "setBlock");
                        this.setPlayOnceBlock(this.menuXlet.getVideoPlayer().getPlaylist(this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist()), "setBlock");
                    }
                    Debugging.dmsg("Playlist to play = " + expressionTokens[2]);
                    Debugging.dmsg("Playlist is played once? " + this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed());
                    if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed()) {
                        expressionTokens[2] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist();
                        if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed()) {
                            expressionTokens[2] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist();
                        }
                    }
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("resumeable") && DiscTrackerManager.getTrackerPlaylistID().equalsIgnoreCase(expressionTokens[2])) {
                        Debugging.dmsg("DiscTracker show menu ids match ");
                        this.updateMenu(expressionTokens[1], false, false);
                    } else {
                        Debugging.dmsg("DiscTracker DON'T show menu ids DON'T match " + DiscTrackerManager.getTrackerPlaylistID() + " != " + expressionTokens[2]);
                        if (!DiscTrackerManager.getTrackerState().equalsIgnoreCase("off")) {
                            DiscTrackerManager.setTrackerState("playback");
                        }
                        this.menuXlet.getVideoPlayer().setLockoutTimeline(true);
                        this.menuXlet.getLayoutManager().hideMenu();
                        this.menuXlet.getLayoutManager().paintScreen();
                        this.menuXlet.getVideoPlayer().stop();
                        if (expressionTokens[2].startsWith("Feature")) {
                            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        } else if (expressionTokens[2].startsWith("Warnings_prefeature") && TitleChangeManager.getTitleNumber() == 1) {
                            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                        Playlist.overrideOnStart(null);
                        this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[2], Integer.parseInt(expressionTokens[3]), true);
                    }
                }
            } else if (command.equalsIgnoreCase("disctrackerWithIntroBonusPopup")) {
                Debugging.dmsg("Playlist to play = " + expressionTokens[2]);
                this.menuXlet.setState(4);
                if (this.menuXlet.getLayoutManager().getCurrentMenu().getLinkProperty().equalsIgnoreCase("commentary") && this.menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable()) {
                    LanguageManager.checkStreamSurfing(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                } else {
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("off")) {
                        expressionTokens[2] = expressionTokens[4];
                    }
                    Debugging.dmsg("DiscTrackerManager.getTrackerState() = " + DiscTrackerManager.getTrackerState());
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("resumeable")) {
                        this.setPlayOnceBlock(this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]), "setBlock");
                        this.setPlayOnceBlock(this.menuXlet.getVideoPlayer().getPlaylist(this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist()), "setBlock");
                    }
                    Debugging.dmsg("Playlist to play = " + expressionTokens[2]);
                    Debugging.dmsg("Playlist is played once? " + this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed());
                    if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed()) {
                        expressionTokens[2] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist();
                        if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getPlayOnceBlockPlayed()) {
                            expressionTokens[2] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[2]).getNextPlaylist();
                        }
                    }
                    if (DiscTrackerManager.getTrackerState().equalsIgnoreCase("resumeable") && DiscTrackerManager.getTrackerPlaylistID().equalsIgnoreCase(expressionTokens[2])) {
                        Debugging.dmsg("DiscTracker show menu ids match ");
                        this.updateMenu(expressionTokens[1], false, false);
                    } else {
                        Debugging.dmsg("DiscTracker DON'T show menu ids DON'T match " + DiscTrackerManager.getTrackerPlaylistID() + " != " + expressionTokens[2]);
                        if (!DiscTrackerManager.getTrackerState().equalsIgnoreCase("off")) {
                            DiscTrackerManager.setTrackerState("playback");
                        }
                        this.menuXlet.getVideoPlayer().setLockoutTimeline(true);
                        this.menuXlet.getLayoutManager().hideMenu();
                        this.menuXlet.getLayoutManager().paintScreen();
                        this.menuXlet.getVideoPlayer().stop();
                        if (expressionTokens[2].startsWith("Feature")) {
                            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        } else if (expressionTokens[2].startsWith("Warnings_prefeature") && TitleChangeManager.getTitleNumber() == 1) {
                            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                        Playlist.overrideOnStart(null);
                        this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[2], Integer.parseInt(expressionTokens[3]), true);
                    }
                }
            } else if (command.equalsIgnoreCase("showMenu")) {
                for (int index = 1; index < expressionTokens.length; index += 2) {
                    Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    if (currentMenu != null) {
                        currentMenu.becomeActivated();
                    }
                    this.menuXlet.getLayoutManager().pushNewMenu(expressionTokens[index]);
                    currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    currentMenu.show();
                    if (index < expressionTokens.length - 1) {
                        currentMenu.updateSelect(expressionTokens[index + 1]);
                        continue;
                    }
                    this.reflectMenu(currentMenu);
                    currentMenu.updateSelect(currentMenu.getDefaultSelect());
                }
            } else if (command.equalsIgnoreCase("showMenuHybridDVM")) {
                int player_region = 0;
                player_region = BDProperties.getPlayerRegion();
                if (player_region == 3) {
                    player_region = 4;
                }
                for (int index = 1; index < expressionTokens.length; index += 2) {
                    int region = 0;
                    if (expressionTokens[index].equalsIgnoreCase("A")) {
                        region = 1;
                    } else if (expressionTokens[index].equalsIgnoreCase("B")) {
                        region = 2;
                    } else if (expressionTokens[index].equalsIgnoreCase("C")) {
                        region = 4;
                    }
                    if (region != 0 && region != player_region) continue;
                    Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    if (currentMenu != null) {
                        currentMenu.becomeActivated();
                    }
                    Debugging.dmsg("expressionTokens[index+1] " + expressionTokens[index + 1]);
                    this.menuXlet.getLayoutManager().pushNewMenu(expressionTokens[index + 1]);
                    currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    currentMenu.show();
                    this.reflectMenu(currentMenu);
                    currentMenu.updateSelect(currentMenu.getDefaultSelect());
                    break;
                }
            } else if (command.equalsIgnoreCase("showMenuCheckDiscTracker")) {
                String[] newexpressionTokens = null;
                String[] comands = FileUtils.tokenizeString(expressionTokens[1], "?");
                String target_menu = "none";
                if (DiscTrackerManager.featureAccesedOnce) {
                    target_menu = DiscTrackerManager.getTrackerPlaylistID();
                    Debugging.dmsg("featureAccesedOnce target_menu = " + target_menu);
                }
                for (int ii = 0; ii < comands.length; ++ii) {
                    if (!comands[ii].startsWith(target_menu + ":")) continue;
                    Debugging.dmsg("target_menu = " + target_menu + ":");
                    newexpressionTokens = FileUtils.tokenizeString(comands[ii], ":");
                }
                Debugging.dmsg(" newexpressionTokens = " + (String)newexpressionTokens[1]);
                if (newexpressionTokens != null) {
                    for (int index = 1; index < newexpressionTokens.length; index += 2) {
                        Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                        if (currentMenu != null) {
                            currentMenu.becomeActivated();
                        }
                        this.menuXlet.getLayoutManager().pushNewMenu(newexpressionTokens[index]);
                        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                        currentMenu.show();
                        if (index < newexpressionTokens.length - 1) {
                            currentMenu.updateSelect(newexpressionTokens[index + 1]);
                            continue;
                        }
                        this.reflectMenu(currentMenu);
                        currentMenu.updateSelect(currentMenu.getDefaultSelect());
                    }
                }
            } else if (command.equalsIgnoreCase("showMenuCheckCommentary")) {
                String[] newexpressionTokens = null;
                String[] comands = FileUtils.tokenizeString(expressionTokens[1], "?");
                String commentary_stream = String.valueOf(0);
                if (PersistentSettings.getBoolean(14)) {
                    commentary_stream = String.valueOf(PersistentSettings.getInt(15));
                }
                for (int ii = 0; ii < comands.length; ++ii) {
                    if (!comands[ii].startsWith(commentary_stream)) continue;
                    newexpressionTokens = FileUtils.tokenizeString(comands[ii], ":");
                }
                if (newexpressionTokens != null) {
                    for (int index = 1; index < newexpressionTokens.length; index += 2) {
                        Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                        if (currentMenu != null) {
                            currentMenu.becomeActivated();
                        }
                        this.menuXlet.getLayoutManager().pushNewMenu(newexpressionTokens[index]);
                        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                        currentMenu.show();
                        if (index < newexpressionTokens.length - 1) {
                            currentMenu.updateSelect(newexpressionTokens[index + 1]);
                            continue;
                        }
                        this.reflectMenu(currentMenu);
                        currentMenu.updateSelect(currentMenu.getDefaultSelect());
                    }
                }
            } else if (command.equalsIgnoreCase("showMenuAndHideCheckCommentary")) {
                Menu currentMenu = null;
                String[] newexpressionTokens = null;
                String[] comands = FileUtils.tokenizeString(expressionTokens[1], "?");
                String commentary_stream = String.valueOf(0);
                if (PersistentSettings.getBoolean(14)) {
                    commentary_stream = String.valueOf(PersistentSettings.getInt(15));
                }
                for (int ii = 0; ii < comands.length; ++ii) {
                    if (!comands[ii].startsWith(commentary_stream)) continue;
                    newexpressionTokens = FileUtils.tokenizeString(comands[ii], ":");
                }
                if (newexpressionTokens != null) {
                    for (int index = 1; index < newexpressionTokens.length; index += 2) {
                        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                        if (currentMenu != null) {
                            currentMenu.becomeActivated();
                            currentMenu.hideExtras();
                        }
                        this.menuXlet.getLayoutManager().pushNewMenu(newexpressionTokens[index]);
                        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                        if (index < newexpressionTokens.length - 1) {
                            currentMenu.updateSelect(newexpressionTokens[index + 1]);
                            continue;
                        }
                        this.reflectMenu(currentMenu);
                        currentMenu.updateSelect(currentMenu.getDefaultSelect());
                    }
                    if (currentMenu != null) {
                        currentMenu.show();
                    }
                }
            } else if (command.equalsIgnoreCase("showMenuAndHide")) {
                Menu currentMenu = null;
                for (int index = 1; index < expressionTokens.length; index += 2) {
                    currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    if (currentMenu != null) {
                        currentMenu.becomeActivated();
                        currentMenu.hideExtras();
                    }
                    this.menuXlet.getLayoutManager().pushNewMenu(expressionTokens[index]);
                    currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    if (index < expressionTokens.length - 1) {
                        currentMenu.updateSelect(expressionTokens[index + 1]);
                        continue;
                    }
                    this.reflectMenu(currentMenu);
                    currentMenu.updateSelect(currentMenu.getDefaultSelect());
                }
                if (currentMenu != null) {
                    currentMenu.show();
                }
            } else if (command.equalsIgnoreCase("setIndicator")) {
                switch (expressionTokens.length) {
                    case 1: {
                        this.menuXlet.getLayoutManager().getCurrentMenu().setIndicator();
                        break;
                    }
                    case 2: {
                        this.menuXlet.getLayoutManager().getCurrentMenu().setIndicator(expressionTokens[1]);
                    }
                }
            } else if (command.equalsIgnoreCase("jumpTitle")) {
                if (expressionTokens.length >= 2) {
                    Thread thread = null;
                    switch (expressionTokens.length) {
                        class JumpTitleRunnable
                        implements Runnable {
                            int title;
                            String lang;

                            JumpTitleRunnable(int title) {
                                this.title = title;
                            }

                            JumpTitleRunnable(int title, String lang) {
                                this.title = title;
                                this.lang = lang;
                            }

                            public void run() {
                                Debugging.dmsg("ESS - jump to new title");
                                if (this.lang != null && !this.lang.equals("")) {
                                    this.lang = this.lang.toLowerCase();
                                    PersistentSettings.setString(0, this.lang);
                                }
                                PersistentSettings.setBoolean(13, true);
                                PersistentSettings.writeSettings();
                                ActionManager.this.menuXlet.getVideoPlayer().stop();
                                TitleChanging.changeTitle(ActionManager.this.menuXlet.getContext(), this.title);
                            }
                        }
                        case 2: {
                            thread = new Thread(new JumpTitleRunnable(Integer.parseInt(expressionTokens[1])));
                            thread.start();
                            break;
                        }
                        case 3: {
                            thread = new Thread(new JumpTitleRunnable(Integer.parseInt(expressionTokens[1]), expressionTokens[2]));
                            thread.start();
                        }
                    }
                }
            } else if (command.equalsIgnoreCase("jumpTitleSynchronous")) {
                switch (expressionTokens.length) {
                    case 2: {
                        this.menuXlet.getVideoPlayer().stop();
                        TitleChangeManager.changeTitle(this.menuXlet.getContext(), Integer.parseInt(expressionTokens[1]));
                        break;
                    }
                }
            } else if (command.equalsIgnoreCase("forcePopUpOn")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().userEventReceived(461);
                }
            } else if (command.equalsIgnoreCase("setMenuLanguageRNIB")) {
                int player_region = 0;
                player_region = BDProperties.getPlayerRegion();
                if (player_region == 3) {
                    player_region = 4;
                }
                for (int index = 1; index < expressionTokens.length; index += 2) {
                    int region = 0;
                    if (expressionTokens[index].equalsIgnoreCase("A")) {
                        region = 1;
                    } else if (expressionTokens[index].equalsIgnoreCase("B")) {
                        region = 2;
                    } else if (expressionTokens[index].equalsIgnoreCase("C")) {
                        region = 4;
                    }
                    if (region != 0 && region != player_region) continue;
                    PersistentSettings.setString(0, expressionTokens[index + 1]);
                    Debugging.dmsg("setMenuLanguageRNIB " + expressionTokens[index + 1]);
                    break;
                }
            } else if (command.equalsIgnoreCase("resume")) {
                if (expressionTokens.length == 3) {
                    // empty if block
                }
                Playlist.overrideOnStart(null);
                if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getPlayOnceBlockPlayed()) {
                    this.menuXlet.getVideoPlayer().stop();
                    TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    expressionTokens[1] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getNextPlaylist();
                }
                this.menuXlet.getLayoutManager().hideMenu();
                this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[1], Integer.parseInt(expressionTokens[2]), true);
            } else if (command.equalsIgnoreCase("bonusResume")) {
                if (expressionTokens.length == 3) {
                    // empty if block
                }
                Debugging.dmsg("bonusResume ? = : " + this.menuXlet.getVideoPlayer().getCurrentPlaylist().getresumeToLastPlaylist());
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().getresumeToLastPlaylist() != null) {
                    Debugging.dmsg("bonusResume = : " + this.menuXlet.getVideoPlayer().getCurrentPlaylist().getresumeToLastPlaylist());
                    Playlist.overrideOnStart(null);
                    this.menuXlet.getLayoutManager().hideMenu();
                    this.menuXlet.getVideoPlayer().startPlaylistAtMark(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getresumeToLastPlaylist(), 0, true);
                } else {
                    Debugging.dmsg("bonusResume = : " + expressionTokens[1]);
                    this.menuXlet.getLayoutManager().hideMenu();
                    this.menuXlet.getVideoPlayer().stop();
                    TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
                    this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[1], Integer.parseInt(expressionTokens[2]), false);
                }
            } else if (command.equalsIgnoreCase("play")) {
                if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getID().startsWith("Warning") || this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getID().startsWith("Episode")) {
                    Playlist.overrideOnStart(null);
                }
                if (expressionTokens.length == 3) {
                    if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getPlayOnceBlockPlayed()) {
                        this.menuXlet.getVideoPlayer().stop();
                        TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        expressionTokens[1] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getNextPlaylist();
                    }
                    this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[1], Integer.parseInt(expressionTokens[2]), false);
                } else if (expressionTokens.length == 4) {
                    if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().isResumable() || this.menuXlet.getVideoPlayer().getCurrentPlaylist().getEpisodeNumber() > 0) {
                        if (expressionTokens[3].equalsIgnoreCase("self")) {
                            this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).setresumeToLastPlaylist(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getID());
                        } else {
                            this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).setresumeToLastPlaylist(expressionTokens[3]);
                        }
                    } else {
                        this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).setresumeToLastPlaylist(null);
                    }
                    Playlist.overrideOnStart(null);
                    this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[1], Integer.parseInt(expressionTokens[2]), false);
                }
            } else if (command.equalsIgnoreCase("playCommentary")) {
                Debugging.dmsg("expressionTokens[1] " + expressionTokens[1]);
                Debugging.dmsg("CurrentPlaylist " + this.menuXlet.getVideoPlayer().getCurrentPlaylist().getID());
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().getEpisodeNumber() != this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getEpisodeNumber()) {
                    this.menuXlet.getLayoutManager().hideMenu();
                    this.menuXlet.getLayoutManager().paintScreen();
                    this.menuXlet.getVideoPlayer().stop();
                    if (this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getPlayOnceBlockPlayed()) {
                        this.menuXlet.getVideoPlayer().stop();
                        TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Debugging.dmsg("Thread.sleep(1000L); " + ex);
                        }
                        expressionTokens[1] = this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).getNextPlaylist();
                    }
                    if (expressionTokens[1].startsWith("Episode")) {
                        TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Debugging.dmsg("Thread.sleep(1000L); " + ex);
                        }
                    }
                    Playlist.overrideOnStart(null);
                    this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[1], Integer.parseInt(expressionTokens[2]), false);
                } else {
                    LanguageManager.checkStreamSurfing(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                }
            } else if (command.equalsIgnoreCase("playBonusResumeOveride")) {
                Debugging.dmsg("playBonusResumeOveride = : " + this.menuXlet.getVideoPlayer().getCurrentPlaylist().getresumeToLastPlaylist());
                this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]).setresumeToLastPlaylist(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getresumeToLastPlaylist());
                this.menuXlet.getVideoPlayer().startPlaylistAtMark(expressionTokens[1], Integer.parseInt(expressionTokens[2]), false);
            } else if (command.equalsIgnoreCase("skipToMark")) {
                this.menuXlet.getVideoPlayer().skipToMark(Integer.parseInt(expressionTokens[1]));
            } else if (command.equalsIgnoreCase("playNextChapter")) {
                int currPlayMark = BDProperties.getChapterNumber();
                this.menuXlet.getVideoPlayer().looping = true;
                this.menuXlet.getVideoPlayer().startPlaylistAtMark(this.menuXlet.getVideoPlayer().getCurrentPlaylist().getID(), currPlayMark, false, false);
            } else if (command.equalsIgnoreCase("timeOutMenu")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().setTimer(5000L);
                }
            } else if (command.equalsIgnoreCase("playTimecode")) {
                if (expressionTokens.length == 3) {
                    this.menuXlet.getLayoutManager().hideMenu();
                    this.menuXlet.getVideoPlayer().startPlaylistAtTC(expressionTokens[1], Integer.parseInt(expressionTokens[2]), false);
                } else if (expressionTokens.length == 2) {
                    DiscTrackerManager.setTrackerState("playback");
                    Playlist.overrideOnStart(null);
                    this.menuXlet.getLayoutManager().hideMenu();
                    this.menuXlet.getVideoPlayer().startPlaylistAtTC(expressionTokens[1], DiscTrackerManager.getTrackerTime(), false);
                }
            } else if (command.equalsIgnoreCase("playLocalizedCard")) {
                String targetPlaylist = expressionTokens[1];
                for (int index = 2; index < expressionTokens.length; index += 2) {
                    if (this.menuXlet.getVideoPlayer().getCurrentAudio() != Integer.parseInt(expressionTokens[index])) continue;
                    Playlist.overrideOnStart(null);
                    targetPlaylist = expressionTokens[index + 1];
                }
                this.menuXlet.getLayoutManager().hideMenu();
                if (targetPlaylist.startsWith("Dub") || targetPlaylist.startsWith("Warning") || targetPlaylist.startsWith("Top")) {
                    DiscTrackerManager.setTrackerPlayMarkWithoutVailidation(0);
                }
                this.menuXlet.getVideoPlayer().startPlaylistAtMark(targetPlaylist, 0, false);
            } else if (command.equalsIgnoreCase("setAudio")) {
                this.menuXlet.getLayoutManager().setTimer(5000L);
                LanguageManager.setAudioSelectID(this.menuXlet.getLayoutManager().getCurrentMenu().getCurrSelect().getID());
                this.menuXlet.getLayoutManager().getCurrentMenu().setIndicator();
                PersistentSettings.setBoolean(14, false);
                if (expressionTokens.length == 4) {
                    if (this.stopJapanLogicSwitch == 0) {
                        LanguageManager.setSubtitleSelectID(this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButton(expressionTokens[2]).getID());
                        this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).setIndicator(expressionTokens[2]);
                        PersistentSettings.setBoolean(16, true);
                    }
                    this.stopJapanLogicSwitch = Integer.parseInt(expressionTokens[3]);
                }
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().isLanguageManaged()) {
                    LanguageManager.setAudioAndSubtitleStreams(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                }
            } else if (command.equalsIgnoreCase("setAudioAndSubtitle")) {
                this.menuXlet.getLayoutManager().setTimer(5000L);
                LanguageManager.setAudioSelectID(this.menuXlet.getLayoutManager().getCurrentMenu().getCurrSelect().getID());
                this.menuXlet.getLayoutManager().getCurrentMenu().setIndicator();
                PersistentSettings.setBoolean(14, false);
                LanguageManager.setSubtitleSelectID(this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButton(expressionTokens[2]).getID());
                this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).setIndicator(expressionTokens[2]);
                PersistentSettings.setBoolean(16, true);
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().isLanguageManaged()) {
                    LanguageManager.setAudioAndSubtitleStreams(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                }
            } else if (command.equalsIgnoreCase("setSubtitle")) {
                this.menuXlet.getLayoutManager().setTimer(5000L);
                LanguageManager.setSubtitleSelectID(this.menuXlet.getLayoutManager().getCurrentMenu().getCurrSelect().getID());
                this.menuXlet.getLayoutManager().getCurrentMenu().setIndicator();
                PersistentSettings.setBoolean(16, true);
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().isLanguageManaged()) {
                    LanguageManager.setAudioAndSubtitleStreams(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                }
            } else if (command.equalsIgnoreCase("setStream")) {
                Debugging.dmsg("setStream " + expressionTokens[2] + " " + expressionTokens[3]);
                if (expressionTokens[1].equalsIgnoreCase("audio")) {
                    LanguageManager.setAudioSelectID(this.menuXlet.getLayoutManager().getMenu(expressionTokens[2]).getButton(expressionTokens[3]).getID());
                    this.menuXlet.getLayoutManager().getMenu(expressionTokens[2]).setIndicator(expressionTokens[3]);
                    PersistentSettings.setBoolean(14, false);
                } else {
                    LanguageManager.setSubtitleSelectID(this.menuXlet.getLayoutManager().getMenu(expressionTokens[2]).getButton(expressionTokens[3]).getID());
                    this.menuXlet.getLayoutManager().getMenu(expressionTokens[2]).setIndicator(expressionTokens[3]);
                    PersistentSettings.setBoolean(16, true);
                }
            } else if (command.equalsIgnoreCase("setCommentary")) {
                this.menuXlet.getLayoutManager().setTimer(5000L);
                String state = expressionTokens[1];
                if (state.equalsIgnoreCase("on")) {
                    PersistentSettings.setBoolean(14, true);
                    PersistentSettings.setBoolean(16, false);
                    PersistentSettings.setInt(15, Integer.parseInt(expressionTokens[2]));
                    Debugging.dmsg("SETTING_COMMENTARYAUDIOSTREAM " + PersistentSettings.getInt(15));
                } else {
                    int stream = Integer.parseInt(expressionTokens[2]);
                    if (stream == PersistentSettings.getInt(15)) {
                        PersistentSettings.setBoolean(14, false);
                    }
                }
                this.menuXlet.getLayoutManager().getCurrentMenu().setIndicator();
                if (this.menuXlet.getVideoPlayer().getCurrentPlaylist().isLanguageManaged()) {
                    LanguageManager.setAudioAndSubtitleStreams(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
                } else {
                    LanguageManager.UpdateIndicatorsCommentaryStateChange();
                }
                this.updateCommentary(this.menuXlet.getLayoutManager().getCurrentMenu());
            } else if (command.equalsIgnoreCase("hideMenu")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().hideMenu();
                }
            } else if (command.equalsIgnoreCase("hideTimeline")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getVideoPlayer().toggleTimeline("off");
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    this.menuXlet.getLayoutManager().hideMenu();
                }
            } else if (command.equalsIgnoreCase("showTimeline")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getVideoPlayer().toggleTimeline("on");
                }
            } else if (command.equalsIgnoreCase("pauseRendering")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().pauseRendering();
                }
            } else if (command.equalsIgnoreCase("resumeRendering")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().resumeRendering();
                }
            } else if (command.equalsIgnoreCase("blackoutScreen")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().blackoutScreen();
                }
            } else if (command.equalsIgnoreCase("cancelTimer")) {
                if (expressionTokens.length == 1) {
                    this.menuXlet.getLayoutManager().resetTimer();
                }
            } else if (command.equalsIgnoreCase("defaultSelect")) {
                if (expressionTokens.length == 3) {
                    Menu menu = this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]);
                    menu.setDefaultSelect(expressionTokens[2]);
                } else if (expressionTokens.length == 2) {
                    Menu menu = this.menuXlet.getLayoutManager().getCurrentMenu();
                    menu.setDefaultSelect(expressionTokens[1]);
                }
            } else if (command.equalsIgnoreCase("resizeVideo")) {
                int x = 0;
                int y = 0;
                int w = 1920;
                int h = 1080;
                switch (expressionTokens.length) {
                    case 5: {
                        h = Integer.parseInt(expressionTokens[4]);
                    }
                    case 4: {
                        w = Integer.parseInt(expressionTokens[3]);
                    }
                    case 3: {
                        y = Integer.parseInt(expressionTokens[2]);
                    }
                    case 2: {
                        x = Integer.parseInt(expressionTokens[1]);
                    }
                }
                this.menuXlet.getVideoPlayer().resizeVideo(x, y, w, h);
            } else if (command.equalsIgnoreCase("overrideTimeline")) {
                long time = -1L;
                int chapter = 0;
                switch (expressionTokens.length) {
                    case 3: {
                        chapter = Integer.parseInt(expressionTokens[2]);
                    }
                    case 2: {
                        time = Long.parseLong(expressionTokens[1]) * 1000000000L;
                    }
                }
                this.menuXlet.getVideoPlayer().overrideTimelineData(time, chapter);
            } else if (command.equalsIgnoreCase("playChime")) {
                if (!this.BLOCK_RNIB) {
                    SoundManager.playChime();
                }
            } else if (command.equalsIgnoreCase("playSelect")) {
                SoundManager.playSelect();
            } else if (command.equalsIgnoreCase("playActivate")) {
                SoundManager.playActivate();
            } else if (command.equalsIgnoreCase("setPlayOnce")) {
                this.setPlayOnceBlock(this.menuXlet.getVideoPlayer().getPlaylist(expressionTokens[1]), expressionTokens[2]);
            } else if (command.equalsIgnoreCase("checkSurfing")) {
                LanguageManager.checkStreamSurfing(this.menuXlet.getVideoPlayer().getCurrentPlaylist());
            } else if (command.equalsIgnoreCase("stillLoading")) {
                this.menuXlet.stillLoading = true;
            } else if (command.equalsIgnoreCase("playTrailers")) {
                this.playTrailers();
            } else if (command.equalsIgnoreCase("playStayTuned")) {
                this.menuXlet.getVideoPlayer().startPlaylistAtMarkSynchronized("StayTuned_" + PersistentSettings.getString(0), 0, false);
            } else if (command.equalsIgnoreCase("playTopMenu")) {
                this.playTopMenu();
            } else if (command.equalsIgnoreCase("loadAssets")) {
                this.menuXlet.loadAssets();
            } else if (command.equalsIgnoreCase("loadLanguageLogic")) {
                this.menuXlet.getLayoutManager().loadLanguageLogic(expressionTokens[1]);
            } else if (command.equalsIgnoreCase("playLogo")) {
                this.menuXlet.getLayoutManager().hideMenu();
                this.menuXlet.getLayoutManager().paintScreen();
                this.menuXlet.getVideoPlayer().destroyPlayer();
                this.menuXlet.hasTrailers = expressionTokens[1].equals("1");
                if (expressionTokens.length == 3) {
                    this.menuXlet.setMenuLanguage(expressionTokens[2], 1);
                } else if (expressionTokens.length == 4) {
                    this.menuXlet.setMenuLanguage(expressionTokens[2], Integer.parseInt(expressionTokens[3]));
                }
            } else if (command.equalsIgnoreCase("fadeIn") || command.equalsIgnoreCase("fadeOut")) {
                float startAlpha = 0.0f;
                float endAlpha = 1.0f;
                if (command.equalsIgnoreCase("fadeOut")) {
                    startAlpha = 1.0f;
                    endAlpha = 0.0f;
                }
                FadeAnimation animation = null;
                if (expressionTokens.length == 2) {
                    animation = new FadeAnimation(this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(expressionTokens[1]), startAlpha, endAlpha, 500L);
                }
                if (expressionTokens.length == 3) {
                    animation = new FadeAnimation(this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcon(expressionTokens[2]), startAlpha, endAlpha, 500L);
                }
                if (animation != null) {
                    this.menuXlet.getAnimationManager().addAnimation(animation);
                    this.menuXlet.getAnimationManager().startAnimation();
                }
            } else if (command.equalsIgnoreCase("flashActivated")) {
                this.menuXlet.getLayoutManager().getCurrentMenu().becomeActivated();
                this.menuXlet.getLayoutManager().paintScreen();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.menuXlet.getLayoutManager().getCurrentMenu().becomeSelected();
                this.menuXlet.getLayoutManager().paintScreen();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            } else if (command.equalsIgnoreCase("flashIcon")) {
                Icon icon = this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(expressionTokens[1]);
                icon.setVisible(true);
                this.menuXlet.getLayoutManager().paintScreen();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                icon.setVisible(false);
                this.menuXlet.getLayoutManager().paintScreen();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            } else if (command.equalsIgnoreCase("setCurrPage")) {
                this.menuXlet.getLayoutManager().getCurrentMenu().setCurrPage(Integer.parseInt(expressionTokens[1]));
            } else if (command.equalsIgnoreCase("slideIconHorizontally")) {
                Debugging.dmsg("slideIconHorizontally");
                if (expressionTokens.length == 5) {
                    Debugging.dmsg("got the correct number of tokens");
                    Icon icon = this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(expressionTokens[1]);
                    Debugging.dmsg("icon: " + icon);
                    int startX = Integer.parseInt(expressionTokens[2]);
                    int endX = Integer.parseInt(expressionTokens[3]);
                    long duration = Long.parseLong(expressionTokens[4]);
                    SlideAnimation animation = new SlideAnimation(icon, startX, icon.getY(), endX, icon.getY(), duration);
                    this.menuXlet.getAnimationManager().addAnimation(animation);
                    this.menuXlet.getAnimationManager().runAnimationSynchronously();
                }
            } else if (command.equalsIgnoreCase("slideAndFade")) {
                if (expressionTokens.length == 4) {
                    Icon target2;
                    SlideAnimation animation2;
                    FadeAnimation animation1;
                    Icon target1;
                    int i;
                    int direction = expressionTokens[3].equalsIgnoreCase("left") ? -1 : 1;
                    Button button1 = this.menuXlet.getLayoutManager().getCurrentMenu().getButton(expressionTokens[1]);
                    Button button2 = this.menuXlet.getLayoutManager().getCurrentMenu().getButton(expressionTokens[2]);
                    ArrayList<Icon> targets1 = new ArrayList<Icon>();
                    ArrayList<Icon> targets2 = new ArrayList<Icon>();
                    targets1.add(button1);
                    targets2.add(button2);
                    for (i = 0; i < button1.getSelectedExtras().length; ++i) {
                        targets1.add(this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(button1.getSelectedExtras()[i]));
                    }
                    for (i = 0; i < button2.getSelectedExtras().length; ++i) {
                        targets2.add(this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(button2.getSelectedExtras()[i]));
                    }
                    for (i = 0; i < targets1.size(); ++i) {
                        target1 = (Icon)targets1.get(i);
                        animation1 = new FadeAnimation(target1, 1.0f, 0.0f, 200L);
                        animation2 = new SlideAnimation(target1, target1.getX(), target1.getY(), target1.getX() + 150 * direction, target1.getY(), 200L);
                        this.menuXlet.getAnimationManager().addAnimation(animation1);
                        this.menuXlet.getAnimationManager().addAnimation(animation2);
                    }
                    for (i = 0; i < targets2.size(); ++i) {
                        target2 = (Icon)targets2.get(i);
                        animation1 = new FadeAnimation(target2, 0.0f, 1.0f, 200L);
                        animation2 = new SlideAnimation(target2, target2.getX() - 150 * direction, target2.getY(), target2.getX(), target2.getY(), 200L);
                        this.menuXlet.getAnimationManager().addAnimation(animation1);
                        this.menuXlet.getAnimationManager().addAnimation(animation2);
                    }
                    for (i = 0; i < targets2.size(); ++i) {
                        target2 = (Icon)targets2.get(i);
                        target2.setVisible(true);
                    }
                    this.menuXlet.getAnimationManager().runAnimationSynchronously();
                    for (i = 0; i < targets1.size(); ++i) {
                        target1 = (Icon)targets1.get(i);
                        target1.setVisible(false);
                    }
                }
            } else if (command.equalsIgnoreCase("slideButtons")) {
                Button target1;
                Button target2;
                SlideAnimation animation2;
                FadeAnimation animation1;
                Button btn;
                int i;
                int direction = 1;
                long time = 200L;
                int move = 150;
                if (expressionTokens[5].equalsIgnoreCase("left") || expressionTokens[5].equalsIgnoreCase("up")) {
                    direction = -1;
                }
                if (expressionTokens.length > 6) {
                    move = Integer.parseInt(expressionTokens[6]);
                }
                if (expressionTokens.length > 7) {
                    time = Long.parseLong(expressionTokens[7]);
                }
                ArrayList<Button> targets1 = new ArrayList<Button>();
                ArrayList<Button> targets2 = new ArrayList<Button>();
                ArrayList iconTargets2 = new ArrayList();
                for (i = 0; i < this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButtons().size(); ++i) {
                    btn = (Button)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButtons().get(i);
                    if (btn.getPage() != Integer.parseInt(expressionTokens[2])) continue;
                    targets1.add(btn);
                    animation1 = new FadeAnimation(btn, 1.0f, 0.0f, time);
                    animation2 = new SlideAnimation(btn, btn.getX(), btn.getY(), btn.getX() + move * direction, btn.getY(), time);
                    this.menuXlet.getAnimationManager().addAnimation(animation1);
                    this.menuXlet.getAnimationManager().addAnimation(animation2);
                    String[] icons = btn.getExtras();
                    if (icons.length <= 0) continue;
                    boolean ii = false;
                    Icon icn = this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcon(icons[0]);
                    SlideAnimation animation3 = new SlideAnimation(icn, icn.getX(), icn.getY(), icn.getX() + move * direction, icn.getY(), time);
                    this.menuXlet.getAnimationManager().addAnimation(animation3);
                }
                for (i = 0; i < this.menuXlet.getLayoutManager().getMenu(expressionTokens[3]).getButtons().size(); ++i) {
                    btn = (Button)this.menuXlet.getLayoutManager().getMenu(expressionTokens[3]).getButtons().get(i);
                    if (btn.getPage() != Integer.parseInt(expressionTokens[4])) continue;
                    targets2.add(btn);
                    animation1 = new FadeAnimation(btn, 0.0f, 0.1f, time);
                    animation2 = new SlideAnimation(btn, btn.getX() + move * direction, btn.getY(), btn.getX(), btn.getY(), time);
                    this.menuXlet.getAnimationManager().addAnimation(animation1);
                    this.menuXlet.getAnimationManager().addAnimation(animation2);
                }
                for (i = 0; i < targets2.size(); ++i) {
                    target2 = (Button)targets2.get(i);
                    target2.setVisible(true);
                }
                this.menuXlet.getAnimationManager().runAnimationSynchronously();
                for (i = 0; i < targets1.size(); ++i) {
                    target1 = (Button)targets1.get(i);
                    target1.setVisible(false);
                }
                for (i = 0; i < targets1.size(); ++i) {
                    target1 = (Button)targets1.get(i);
                    target1.resetVisibility();
                }
                for (i = 0; i < targets2.size(); ++i) {
                    target2 = (Button)targets2.get(i);
                    target2.resetVisibility();
                }
            } else if (command.equalsIgnoreCase("slideMenu")) {
                SlideAnimation animation2;
                FadeAnimation animation1;
                int i;
                int direction = 1;
                int up = 0;
                int down = Integer.parseInt(expressionTokens[3]);
                if (expressionTokens[2].equalsIgnoreCase("up")) {
                    down = 0;
                    up = Integer.parseInt(expressionTokens[3]);
                }
                ArrayList<Button> btnTargets = new ArrayList<Button>();
                ArrayList<Icon> iconTargets = new ArrayList<Icon>();
                for (i = 0; i < this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButtons().size(); ++i) {
                    Button btn = (Button)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButtons().get(i);
                    btnTargets.add(btn);
                    animation1 = new FadeAnimation(btn, 0.0f, 1.0f, 100L);
                    animation2 = new SlideAnimation(btn, btn.getX(), btn.getY() + up * direction, btn.getX(), btn.getY() + down * direction, 200L);
                    Debugging.dmsg("btn, btn.getX(), btn.getCurrentX()" + btn.getID() + " " + btn.getX() + " " + btn.getCurrentX());
                    this.menuXlet.getAnimationManager().addAnimation(animation1);
                    this.menuXlet.getAnimationManager().addAnimation(animation2);
                }
                for (i = 0; i < this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcons().size(); ++i) {
                    Icon icon = (Icon)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcons().get(i);
                    iconTargets.add(icon);
                    animation1 = new FadeAnimation(icon, 0.0f, 1.0f, 100L);
                    animation2 = new SlideAnimation(icon, icon.getX(), icon.getY() + up * direction, icon.getX(), icon.getY() + down * direction, 200L);
                    this.menuXlet.getAnimationManager().addAnimation(animation1);
                    this.menuXlet.getAnimationManager().addAnimation(animation2);
                }
                for (i = 0; i < iconTargets.size(); ++i) {
                    Icon iconTarget2 = (Icon)iconTargets.get(i);
                    iconTarget2.setVisible(true);
                }
                for (i = 0; i < btnTargets.size(); ++i) {
                    Button target2 = (Button)btnTargets.get(i);
                    target2.setVisible(true);
                }
                this.menuXlet.getAnimationManager().runAnimationSynchronously();
            } else if (command.equalsIgnoreCase("menuFadeIn") || command.equalsIgnoreCase("menuFadeOut")) {
                int i;
                float startAlpha = 1.0f;
                float endAlpha = 0.0f;
                if (command.equalsIgnoreCase("menuFadeIn")) {
                    startAlpha = 0.0f;
                    endAlpha = 1.0f;
                }
                FadeAnimation animation = null;
                for (i = 0; i < this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcons().size(); ++i) {
                    Icon icon = (Icon)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcons().get(i);
                    animation = !icon.isAnimating() ? new FadeAnimation((Icon)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcons().get(i), 1.0f, 1.0f, Long.parseLong(expressionTokens[2])) : new FadeAnimation((Icon)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getIcons().get(i), startAlpha, endAlpha, Long.parseLong(expressionTokens[2]));
                    this.menuXlet.getAnimationManager().addAnimation(animation);
                }
                for (i = 0; i < this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButtons().size(); ++i) {
                    animation = new FadeAnimation((Button)this.menuXlet.getLayoutManager().getMenu(expressionTokens[1]).getButtons().get(i), startAlpha, endAlpha, Long.parseLong(expressionTokens[2]));
                    this.menuXlet.getAnimationManager().addAnimation(animation);
                }
                if (command.equalsIgnoreCase("menuFadeIn")) {
                    this.menuXlet.getAnimationManager().startAnimation();
                } else {
                    this.menuXlet.getAnimationManager().runAnimationSynchronously();
                }
            } else if (command.equalsIgnoreCase("crossFade")) {
                Icon icon1 = this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(expressionTokens[1]);
                Icon icon2 = this.menuXlet.getLayoutManager().getCurrentMenu().getIcon(expressionTokens[2]);
                FadeAnimation animation1 = new FadeAnimation(icon1, 1.0f, 0.0f, 250L);
                FadeAnimation animation2 = new FadeAnimation(icon2, 0.0f, 1.0f, 250L);
                SlideAnimation animation3 = new SlideAnimation(icon1, icon1.getX(), icon1.getY(), icon1.getX() - 100, icon1.getY(), 200L);
                SlideAnimation animation4 = new SlideAnimation(icon2, icon2.getX() - 100, icon2.getY(), icon2.getX(), icon2.getY(), 200L);
                this.menuXlet.getAnimationManager().addAnimation(animation1);
                this.menuXlet.getAnimationManager().addAnimation(animation2);
                this.menuXlet.getAnimationManager().addAnimation(animation3);
                this.menuXlet.getAnimationManager().addAnimation(animation4);
                this.menuXlet.getAnimationManager().runAnimationSynchronously();
            } else if (command.equalsIgnoreCase("complexAnimationTest")) {
                FadeAnimation animation1 = new FadeAnimation(this.menuXlet.getLayoutManager().getCurrentMenu().getIcon("animation_test1"), 0.0f, 1.0f, 500L);
                FadeAnimation animation2 = new FadeAnimation(this.menuXlet.getLayoutManager().getCurrentMenu().getIcon("animation_test2"), 1.0f, 0.0f, 2000L);
                SlideAnimation animation3 = new SlideAnimation(this.menuXlet.getLayoutManager().getCurrentMenu().getIcon("animation_test1"), 10, 10, 200, 10, 500L);
                this.menuXlet.getAnimationManager().addAnimation(animation1);
                this.menuXlet.getAnimationManager().addAnimation(animation2);
                this.menuXlet.getAnimationManager().addAnimation(animation3);
                this.menuXlet.getAnimationManager().startAnimation();
            }
        }
    }

    public void updateSelect(String targetButton) {
        SoundManager.playSelect();
        Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        Debugging.dmsg("currentMenu.updateSelect(targetButton) == " + currentMenu.getID() + ":" + targetButton);
        currentMenu.updateSelect(targetButton);
    }

    public void updateMenu(String targetMenu, String targetButton, boolean hidePrevious) {
        if (!SoundManager.soundPlayed) {
            SoundManager.playActivate();
        } else {
            SoundManager.soundPlayed = false;
        }
        if (targetButton.equalsIgnoreCase("$audio$") || targetButton.equalsIgnoreCase("$subtitle$")) {
            ArrayList buttons = this.menuXlet.getLayoutManager().getMenu(targetMenu).getButtons();
            for (int ii = 0; ii < buttons.size(); ++ii) {
                Button b = (Button)buttons.get(ii);
                if (ii == 0) {
                    targetButton = b.getID();
                }
                if (!b.isIndicated()) continue;
                targetButton = b.getID();
            }
        }
        Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        if (hidePrevious) {
            currentMenu.hide();
        } else {
            currentMenu.becomeActivated();
        }
        this.menuXlet.getLayoutManager().pushNewMenu(targetMenu);
        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        currentMenu.show();
        currentMenu.updateSelect(targetButton);
    }

    public void updateMenu(String targetMenu, boolean hidePrevious, boolean previewed) {
        if (!SoundManager.soundPlayed) {
            SoundManager.playActivate();
        } else {
            SoundManager.soundPlayed = false;
        }
        Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        if (hidePrevious) {
            currentMenu.hide();
        } else {
            currentMenu.becomeActivated();
        }
        this.menuXlet.getLayoutManager().pushNewMenu(targetMenu);
        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        currentMenu.show();
        this.reflectMenu(currentMenu);
        if (previewed) {
            currentMenu.becomeSelected();
        } else {
            currentMenu.updateSelect(currentMenu.getDefaultSelect());
        }
    }

    public void updateMenu() {
        SoundManager.playSelect();
        Menu currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        currentMenu.becomeNone();
        currentMenu.hide();
        this.menuXlet.getLayoutManager().popCurrentMenu();
        currentMenu = this.menuXlet.getLayoutManager().getCurrentMenu();
        currentMenu.becomeSelected();
        currentMenu.show();
    }

    private void setPlayOnceBlock(Playlist p, String flag) {
        if (p.getPlayOnceStart()) {
            if (flag.equalsIgnoreCase("resetBlock")) {
                p.setPlayOnceBlockPlayed(false);
            } else {
                p.setPlayOnceBlockPlayed(true);
            }
            String playedPlaylists = "";
            boolean first = true;
            for (int i = 0; i < this.menuXlet.getVideoPlayer().getPlaylists().size(); ++i) {
                if (!((Playlist)this.menuXlet.getVideoPlayer().getPlaylists().get(i)).getPlayOnceBlockPlayed()) continue;
                if (!first) {
                    playedPlaylists = playedPlaylists + ",";
                }
                playedPlaylists = playedPlaylists + i;
                first = false;
            }
            PersistentSettings.setString(12, playedPlaylists);
        }
    }

    public void reflectMenu(Menu menu) {
        if (menu.getLinkProperty().equalsIgnoreCase("scenes")) {
            this.updateSceneSelect(menu);
        }
        if (menu.getLinkProperty().equalsIgnoreCase("commentary")) {
            this.updateCommentary(menu);
        }
        if (menu.getLinkProperty().equalsIgnoreCase("episode")) {
            this.updateEpisode(menu);
        }
    }

    private void updateSceneSelect(Menu menu) {
        boolean resumeValid = PersistentSettings.getBoolean(1);
        ArrayList buttons = menu.getButtons();
        String firstSceneButton = "";
        for (int i = 0; i < buttons.size(); ++i) {
            Button b = (Button)buttons.get(i);
            if (!b.isPlayButton()) continue;
            firstSceneButton = b.getID();
            break;
        }
        if (firstSceneButton.equals("")) {
            return;
        }
        String resumePlaylist = PersistentSettings.getString(3);
        int resumePlaymark = (int)this.menuXlet.getVideoPlayer().getTimelineData()[1];
        resumePlaymark = resumePlaymark > 0 ? resumePlaymark - 1 : 0;
        String sceneButton = "";
        for (int i = 0; i < buttons.size(); ++i) {
            Button b = (Button)buttons.get(i);
            if (!b.isPlayButton()) continue;
            String buttonPlaylist = b.getPlayButtonPlaylist();
            int buttonPlaymark = b.getPlayButtonPlaymark();
            if (!resumePlaylist.equalsIgnoreCase(buttonPlaylist)) continue;
            if (buttonPlaymark > resumePlaymark) break;
            sceneButton = b.getID();
        }
        if (!sceneButton.equals("")) {
            menu.setDefaultSelect(sceneButton);
        } else {
            menu.setDefaultSelect(firstSceneButton);
        }
    }

    private void updateEpisode(Menu menu) {
        ArrayList buttons = menu.getButtons();
        int lastEpisodePlayed = 1;
        lastEpisodePlayed = this.menuXlet.getVideoPlayer().episodeNumber;
        if (lastEpisodePlayed < 1) {
            lastEpisodePlayed = 1;
        }
        Button b = (Button)buttons.get(lastEpisodePlayed - 1);
        String episodeButton = b.getID();
        menu.setDefaultSelect(episodeButton);
    }

    public void playTrailers() {
        if (this.menuXlet.getState() == 3) {
            this.menuXlet.getVideoPlayer().startPlaylistAtMark("Trailer_" + PersistentSettings.getString(0), 0, false);
        } else if (this.menuXlet.getState() == 2) {
            this.menuXlet.moveOnAfterLoading = true;
            this.menuXlet.getVideoPlayer().startPlaylistAtMark("LoadingTimeDisclaimer_" + PersistentSettings.getString(0), 0, false);
            this.menuXlet.startTime = System.currentTimeMillis();
        }
    }

    public void playTopMenu() {
        this.menuXlet.setState(4);
        this.menuXlet.getVideoPlayer().startPlaylistAtMark("TopMenuIntro_" + PersistentSettings.getString(0), 0, false);
    }

    private void updateCommentary(Menu menu) {
        Debugging.dmsg("updateCommentary comm state == " + PersistentSettings.getBoolean(14));
        ArrayList buttons = menu.getButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            Button b = (Button)buttons.get(i);
            menu.hideExtras(b.getID());
            b.setIndicated(false);
            String[] bActions = FileUtils.tokenizeString(b.getEnter(), ";");
            int comentary_action_location = 0;
            for (int ii = 0; ii < bActions.length; ++ii) {
                if (!bActions[ii].startsWith("setCommentary")) continue;
                comentary_action_location = ii;
            }
            String[] bAction = FileUtils.tokenizeString(bActions[comentary_action_location], ",");
            int stream = Integer.parseInt(bAction[2]);
            if (bAction[1].equalsIgnoreCase("on")) {
                if (stream != PersistentSettings.getInt(15) || !PersistentSettings.getBoolean(14)) continue;
                Debugging.dmsg("updateCommentary " + b.getID() + " is indicated because comm on and streams match");
                b.setIndicated(true);
                menu.showExtras(b.getID());
                continue;
            }
            if (stream == PersistentSettings.getInt(15) && PersistentSettings.getBoolean(14)) {
                Debugging.dmsg("Do not indicate this off button because it's associated on button is already indicated");
                continue;
            }
            Debugging.dmsg("updateCommentary " + b.getID() + " is indicated because comm off or comm on and stream doesn't match");
            b.setIndicated(true);
            menu.showExtras(b.getID());
        }
    }

    public void destroy() {
    }

    class HandleActionsTask
    extends TimerTask {
        private String expression = "";

        public HandleActionsTask(String expression) {
            this.expression = expression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ActionManager.this.menuXlet.getLayoutManager().keyPressMonitor;
            synchronized (object) {
                ActionManager.this.handleActions(this.expression);
            }
        }
    }
}

