/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.startuplogic;

import com.zoo.MenuXlet;
import com.zoo.StartupLogic;
import com.zoo.event.TitleChangeEvent;
import com.zoo.event.TitleChangeManager;
import com.zoo.event.TitleStartedEvent;
import com.zoo.event.TitleStoppedEvent;
import com.zoo.media.PlayerEvent;
import com.zoo.media.PlaylistEndedEvent;
import com.zoo.ui.components.Preloader;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.PersistentSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.bluray.system.RegisterAccess;
import org.dvb.event.UserEvent;

public class DisneyFML
implements StartupLogic {
    protected static boolean REGION_CHECK = false;
    protected static int REGION_MASK = Integer.parseInt("001", 2);
    protected static boolean AUS_HYBRID_SKU = false;
    protected static boolean RUS_HYBRID_SKU = false;
    protected static boolean DVM_HYBRID_SKU = false;
    protected static boolean US_SKU = false;
    protected static int PARENTAL_LEVEL = -1;
    protected static final String DVM_PLAYLIST = "OptBackground";
    protected static final String REGION_CARD_PLAYLIST = "RegionCard";
    protected static final String PARENTAL_CARD_PLAYLIST = "ParentalWarning";
    protected static final String MAGIC_VIDEO_PLAYLIST = "Logo";
    protected static final String PLAYLIST_FML_CARDS = "FMLCards";
    protected static final String PLAYLIST_TRAILERS = "Trailer";
    protected static final String PLAYLIST_TOP_MENU = "TopMenuIntro";
    protected static final int GPR_TITLE_RELOADING = 2000;
    protected static final int GPR_TOP_MENU_PRESSED = 2001;
    protected static final int GPR_8SEC_EXPIRED = 2002;
    protected static final int GPR_MAGIC_VIDEO_ENDED = 2003;
    protected static final int GPR_START_LOADING_ASSETS = 2004;
    protected static final int GPR_ASSETS_LOADED = 2005;
    protected MenuXlet menuXlet;
    protected boolean ltdcBegun = false;
    protected boolean ltdcMinimumDurationPassed = false;
    protected boolean ltdcMaximumDurationPassed = false;
    protected String languageSuffix = "";
    protected static final Object ltdcMonitor = new Object();
    protected static final Object videoPlayerMonitor = new Object();
    protected int currentComboState = 0;
    protected boolean relinquishedControl = false;
    protected Preloader preloader;

    public void setMenuXlet(MenuXlet menuXlet) {
        this.menuXlet = menuXlet;
    }

    public void setMenuLanguage(String language, int dialect) {
        PersistentSettings.setString(0, language);
        int b1 = language.charAt(0) << 16;
        int b2 = language.charAt(1) << 8;
        char b3 = language.charAt(2);
        RegisterAccess.getInstance().setGPR(3003, b1 | b2 | b3);
        RegisterAccess.getInstance().setGPR(3004, dialect);
        this.languageSuffix = "_" + language;
        TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
        this.runTitle1Start();
    }

    public void getMenuLanguage() {
        int languageValue = RegisterAccess.getInstance().getGPR(3003);
        char b3 = (char)(languageValue & 0xFF);
        char b2 = (char)(languageValue >> 8 & 0xFF);
        char b1 = (char)(languageValue >> 16 & 0xFF);
        String language = String.valueOf(b1) + String.valueOf(b2) + String.valueOf(b3);
        Debugging.dmsg(language);
        this.languageSuffix = "_" + language;
        Debugging.dmsg("getMenuLanguage: " + language);
        PersistentSettings.setString(0, language);
    }

    public void run() {
        this.runStartupSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileCopy(String from, String to) {
        File fromFile = new File(from);
        File toFile = new File(to);
        FileInputStream fromStream = null;
        FileOutputStream toStream = null;
        try {
            int bytesRead;
            fromStream = new FileInputStream(fromFile);
            toStream = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = fromStream.read(buffer)) != -1) {
                toStream.write(buffer, 0, bytesRead);
            }
        }
        catch (FileNotFoundException e) {
            Debugging.dmsg("File not found: " + e);
        }
        catch (IOException e) {
            Debugging.dmsg("IO Exception: " + e);
        }
        finally {
            if (fromStream != null) {
                try {
                    fromStream.close();
                }
                catch (IOException e) {}
            }
            if (toStream != null) {
                try {
                    toStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void runStartupSequence() {
        if (this.menuXlet.REGION_CHECK) {
            REGION_CHECK = true;
        }
        if (this.menuXlet.US_SKU) {
            US_SKU = true;
        }
        if (this.menuXlet.AUS_HYBRID_SKU) {
            AUS_HYBRID_SKU = true;
        }
        if (this.menuXlet.RUS_HYBRID_SKU) {
            RUS_HYBRID_SKU = true;
        }
        if (this.menuXlet.DVM_HYBRID_SKU) {
            DVM_HYBRID_SKU = true;
        }
        if (this.menuXlet.PARENTAL_LEVEL != -1) {
            PARENTAL_LEVEL = this.menuXlet.PARENTAL_LEVEL;
        }
        if (this.menuXlet.REGION_MASK != -1) {
            REGION_MASK = this.menuXlet.REGION_MASK;
        }
        Debugging.dmsg("DisneyFML.runStartupSequence()");
        Debugging.dmsg(" REGION_CHECK = " + REGION_CHECK);
        Debugging.dmsg(" SKIP_DVM_US_SKU = " + US_SKU);
        Debugging.dmsg(" SKIP_DVM_AUS_SKU = " + AUS_HYBRID_SKU);
        Debugging.dmsg(" SKIP_DVM_RUS_SKU = " + RUS_HYBRID_SKU);
        Debugging.dmsg(" SHOW_DVM_HYBRID_SKU = " + DVM_HYBRID_SKU);
        Debugging.dmsg(" PARENTAL_LEVEL = " + PARENTAL_LEVEL);
        Debugging.dmsg(" REGION_MASK = " + REGION_MASK);
        Debugging.dmsg(" BDProperties.getPlayerRegion() = " + BDProperties.getPlayerRegion());
        if (REGION_CHECK && (BDProperties.getPlayerRegion() & REGION_MASK) == 0) {
            this.menuXlet.doPreliminaryStartupLogic();
            this.menuXlet.getVideoPlayer().startPlaylistAtMark(REGION_CARD_PLAYLIST, 0, false);
            return;
        }
        if (BDProperties.getPlayerParentalSetting() < PARENTAL_LEVEL && BDProperties.getPlayerRegion() == 1) {
            this.menuXlet.doPreliminaryStartupLogic();
            this.menuXlet.getVideoPlayer().startPlaylistAtMark(PARENTAL_CARD_PLAYLIST, 0, false);
            return;
        }
        Debugging.dmsg("isTitleReloading: " + this.isTitleReloading());
        if (this.isTitleReloading()) {
            this.menuXlet.doPreliminaryStartupLogic();
            this.getMenuLanguage();
            if (this.getTopMenuPressed()) {
                TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
                this.runTopMenuTitle2to3MinutesCard();
            } else {
                TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                if (this.get8SecExpired()) {
                    this.runTitle12to3MinutesCard();
                } else {
                    this.runTitle1StayTunedCard();
                }
            }
        } else {
            this.menuXlet.doPreliminaryStartupLogic();
            if (RUS_HYBRID_SKU && (BDProperties.getPlayerRegion() == 3 || BDProperties.getPlayerRegion() == 4)) {
                this.menuXlet.hasTrailers = false;
                this.setMenuLanguage("rus", 1);
                Debugging.dmsg("RUS_HYBRID_SKU block");
            } else if (AUS_HYBRID_SKU && BDProperties.getPlayerRegion() == 2) {
                this.menuXlet.hasTrailers = false;
                this.setMenuLanguage("aus", 1);
                Debugging.dmsg("AUS_HYBRID_SKU block");
            } else if (DVM_HYBRID_SKU && (BDProperties.getPlayerRegion() == 2 || BDProperties.getPlayerRegion() == 3 || BDProperties.getPlayerRegion() == 4)) {
                this.menuXlet.getLayoutManager().load();
                this.menuXlet.getVideoPlayer().startPlaylistAtItem(DVM_PLAYLIST, 99, false);
                Debugging.dmsg("DVM_HYBRID_SKU block");
            } else if (!this.menuXlet.hasRNIB && US_SKU && BDProperties.getMenuLanguage() == 6647399 && BDProperties.getPlayerRegion() == 1) {
                this.setMenuLanguage("eng", 1);
                Debugging.dmsg("US_SKU eng menu block");
            } else {
                this.menuXlet.getLayoutManager().load();
                this.menuXlet.getVideoPlayer().startPlaylistAtItem(DVM_PLAYLIST, 99, false);
                Debugging.dmsg("default DVM block");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTitle1Start() {
        Debugging.dmsg("DisneyFML.runTitle1Start()");
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(MAGIC_VIDEO_PLAYLIST + this.languageSuffix, 0, false);
        Debugging.dmsg("told the videoPlayer to do it;");
        while (!this.getMagicVideoEnded()) {
            Object object = videoPlayerMonitor;
            synchronized (object) {
                try {
                    videoPlayerMonitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.getTopMenuPressed()) continue;
        }
        Debugging.dmsg("magic ");
        if (this.getTopMenuPressed()) {
            return;
        }
        if (this.menuXlet.hasTrailers) {
            this.runTitle1StayTunedCard();
        } else {
            TitleChangeManager.changeTitleAsynchronous(this.menuXlet.getContext(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTitle1StayTunedCard() {
        Debugging.dmsg("DisneyFML.runTitle1StayTunedCard()");
        this.menuXlet.getVideoPlayer().startPlaylistAtItem(PLAYLIST_FML_CARDS + this.languageSuffix, 0, false);
        Object object = videoPlayerMonitor;
        synchronized (object) {
            try {
                videoPlayerMonitor.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.processLoadingAssets();
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.getTopMenuPressed()) {
            return;
        }
        this.set8SecExpired(true);
        if (!this.getAssetsLoaded()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.getTopMenuPressed()) {
                return;
            }
            if (!this.getAssetsLoaded()) {
                this.runTitle12to3MinutesCard();
                return;
            }
        }
        if (this.getTopMenuPressed()) {
            return;
        }
        this.runTrailersStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run2to3MinutesCard(boolean topMenuTitle) {
        this.startPreloader();
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_FML_CARDS + this.languageSuffix, 1, false);
        Object object = videoPlayerMonitor;
        synchronized (object) {
            try {
                videoPlayerMonitor.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.ltdcBegun = true;
        if (!topMenuTitle && this.getTopMenuPressed()) {
            return;
        }
        if (!this.getStartLoadingAssets()) {
            this.processLoadingAssets();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.ltdcMinimumDurationPassed = true;
        Object e = ltdcMonitor;
        synchronized (e) {
            ltdcMonitor.notifyAll();
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ltdcMaximumDurationPassed = true;
        object = ltdcMonitor;
        synchronized (object) {
            ltdcMonitor.notifyAll();
        }
    }

    protected void runTopMenuTitle2to3MinutesCard() {
        Debugging.dmsg("DisneyFML.runTopMenuTitle2to3MinutesCard()");
        this.run2to3MinutesCard(true);
    }

    protected void runTitle12to3MinutesCard() {
        Debugging.dmsg("DisneyFML.runTitle12to3MinutesCard()");
        this.run2to3MinutesCard(false);
    }

    protected void runTrailersStart() {
        this.stopPreloader();
        Debugging.dmsg("DisneyFML.runTrailersStart()");
        this.relinquishedControl = true;
        this.menuXlet.relinquishControl();
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_TRAILERS + this.languageSuffix, 0, false);
    }

    protected void runTopMenuTitleTopMenu() {
        this.stopPreloader();
        Debugging.dmsg("DisneyFML.runTopMenuTitleTopMenu()");
        this.relinquishedControl = true;
        this.menuXlet.relinquishControl();
        if (this.languageSuffix.equals("")) {
            String language = "eng";
            int dialect = 1;
            PersistentSettings.setString(0, language);
            int b1 = language.charAt(0) << 16;
            int b2 = language.charAt(1) << 8;
            char b3 = language.charAt(2);
            RegisterAccess.getInstance().setGPR(3003, b1 | b2 | b3);
            RegisterAccess.getInstance().setGPR(3004, dialect);
            this.languageSuffix = "_" + language;
        }
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_TOP_MENU + this.languageSuffix, 0, false);
    }

    void topMenuEvent() {
        Debugging.dmsg("DisneyFML.topMenuEvent()");
        this.setTopMenuPressed(true);
        if (this.getAssetsLoaded()) {
            this.runTopMenuTitleTopMenu();
        } else {
            this.runTopMenuTitle2to3MinutesCard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assetsLoadedEvent() {
        Debugging.dmsg("DisneyFML.assetsLoadedEvent()");
        if (!this.getTopMenuPressed() && !this.get8SecExpired()) {
            return;
        }
        while (!this.ltdcMinimumDurationPassed) {
            Object object = ltdcMonitor;
            synchronized (object) {
                try {
                    ltdcMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.getTopMenuPressed()) {
            this.runTopMenuTitleTopMenu();
        } else {
            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
            this.runTrailersStart();
        }
    }

    protected void processLoadingAssets() {
        Debugging.dmsg("DisneyFML.processLoadingAssets()");
        this.setStartLoadingAssets(true);
        ProcessLoadingAssetsThread thread = new ProcessLoadingAssetsThread();
        thread.start();
    }

    protected boolean isTitleReloading() {
        return TitleChangeManager.getTitleReloading();
    }

    protected boolean getTopMenuPressed() {
        return RegisterAccess.getInstance().getGPR(2001) == 1;
    }

    protected boolean get8SecExpired() {
        return RegisterAccess.getInstance().getGPR(2002) == 1;
    }

    protected boolean getMagicVideoEnded() {
        return RegisterAccess.getInstance().getGPR(2003) == 1;
    }

    protected boolean getStartLoadingAssets() {
        return RegisterAccess.getInstance().getGPR(2004) == 1;
    }

    protected boolean getAssetsLoaded() {
        return RegisterAccess.getInstance().getGPR(2005) == 1;
    }

    protected void setIsTitleReloading() {
        TitleChangeManager.setTitleReloading();
    }

    protected void setTopMenuPressed(boolean value) {
        RegisterAccess.getInstance().setGPR(2001, value ? 1 : 0);
    }

    protected void set8SecExpired(boolean value) {
        RegisterAccess.getInstance().setGPR(2002, value ? 1 : 0);
    }

    protected void setMagicVideoEnded(boolean value) {
        RegisterAccess.getInstance().setGPR(2003, value ? 1 : 0);
    }

    protected void setStartLoadingAssets(boolean value) {
        RegisterAccess.getInstance().setGPR(2004, value ? 1 : 0);
    }

    protected void setAssetsLoaded(boolean value) {
        RegisterAccess.getInstance().setGPR(2005, value ? 1 : 0);
    }

    public void titleChangeEventReceived(TitleChangeEvent evt) {
        if (this.relinquishedControl) {
            this.currentComboState = 0;
            return;
        }
        if (evt instanceof TitleStartedEvent) {
            Debugging.dmsg("titleStartedEvent: " + evt.getTitle());
            if (evt.getTitle() == 0) {
                this.topMenuEvent();
            }
        } else if (evt instanceof TitleStoppedEvent) {
            Debugging.dmsg("titleStoppedEvent: " + evt.getTitle());
            if (evt.getTitle() == 1) {
                this.setTopMenuPressed(true);
                this.menuXlet.getVideoPlayer().stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerEventReceived(PlayerEvent evt) {
        if (this.relinquishedControl) {
            return;
        }
        if (evt instanceof PlaylistEndedEvent && evt.getPlaylist().getID().equals(MAGIC_VIDEO_PLAYLIST + this.languageSuffix)) {
            this.setMagicVideoEnded(true);
        }
        Object object = videoPlayerMonitor;
        synchronized (object) {
            videoPlayerMonitor.notifyAll();
        }
    }

    public void userEventReceived(UserEvent evt) {
    }

    public void destroy() {
        this.setAssetsLoaded(false);
        this.setStartLoadingAssets(false);
        this.setIsTitleReloading();
    }

    private void startPreloader() {
        this.menuXlet.getLayoutManager().pauseRendering();
        this.preloader = new Preloader(this.menuXlet);
    }

    private void stopPreloader() {
        if (this.preloader != null) {
            this.preloader.end();
            this.preloader = null;
            this.menuXlet.getLayoutManager().resumeRendering();
        }
    }

    class ProcessLoadingAssetsThread
    extends Thread {
        ProcessLoadingAssetsThread() {
        }

        public void run() {
            DisneyFML.this.menuXlet.loadAssets();
            DisneyFML.this.setAssetsLoaded(true);
            DisneyFML.this.assetsLoadedEvent();
        }
    }
}

