/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.startuplogic;

import com.disney.bdlive.g2b.G2B;
import com.disney.bdlive.g2b.G2BStatusEvent;
import com.disney.bdlive.g2b.G2BStatusListener;
import com.zoo.MenuXlet;
import com.zoo.StartupLogic;
import com.zoo.event.TitleChangeEvent;
import com.zoo.event.TitleChangeManager;
import com.zoo.event.TitleStartedEvent;
import com.zoo.event.TitleStoppedEvent;
import com.zoo.media.PlayerEvent;
import com.zoo.media.PlaylistEndedEvent;
import com.zoo.ui.components.Preloader;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.PersistentSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.TimerTask;
import org.bluray.system.RegisterAccess;
import org.bluray.vfs.VFSManager;
import org.dvb.event.UserEvent;

public class DisneyBootloaderFML
implements StartupLogic,
G2BStatusListener {
    protected static final boolean REGION_CHECK = false;
    protected static final int REGION_MASK = Integer.parseInt("001", 2);
    protected static final boolean US_SKU = false;
    protected static boolean SKIP_DVM = false;
    protected static final int PARENTAL_LEVEL = 0;
    protected static final String DVM_PLAYLIST = "OptBackground";
    protected static final String REGION_CARD_PLAYLIST = "RegionCard";
    protected static final String PARENTAL_CARD_PLAYLIST = "ParentalWarning";
    protected static final String MAGIC_VIDEO_PLAYLIST = "Logo";
    protected static final String PLAYLIST_FML_CARDS = "FMLCards";
    protected static final String PLAYLIST_TRAILERS = "Trailer";
    protected static final String PLAYLIST_TOP_MENU = "TopMenuIntro";
    protected static final String PLAYLIST_G2B_CARDS = "G2BCards";
    protected static final boolean USE_LOCAL_TEST_PACKAGE = false;
    protected static final boolean DISPLAY_G2B_DEBUG_MESSAGES = false;
    protected static final int[] secretCombination = new int[]{403, 404, 405, 406};
    protected static final int GPR_TITLE_RELOADING = 2000;
    protected static final int GPR_TOP_MENU_PRESSED = 2001;
    protected static final int GPR_8SEC_EXPIRED = 2002;
    protected static final int GPR_MAGIC_VIDEO_ENDED = 2003;
    protected static final int GPR_START_LOADING_ASSETS = 2004;
    protected static final int GPR_ASSETS_LOADED = 2005;
    protected MenuXlet menuXlet;
    protected static final G2B g2B = G2B.getInstance();
    protected boolean isProfile2Supported = false;
    protected boolean ltdcBegun = false;
    protected boolean ltdcMinimumDurationPassed = false;
    protected boolean ltdcMaximumDurationPassed = false;
    protected String languageSuffix = "";
    protected static final Object g2BMonitor = new Object();
    protected static final Object ltdcMonitor = new Object();
    protected static final Object videoPlayerMonitor = new Object();
    protected int currentComboState = 0;
    protected boolean relinquishedControl = false;
    protected Preloader preloader;

    public void setMenuXlet(MenuXlet menuXlet) {
        this.menuXlet = menuXlet;
    }

    public void applyUpdate() {
        String rootOnBUDA = BDProperties.getBindingUnitRoot() + "/7fff0c8e/" + BDProperties.getDiscID() + "/";
        String updateRootOnBUDA = BDProperties.getBindingUnitRoot() + "/7fff0c8e/" + BDProperties.getDiscID() + "/updates/g2b/v1/";
        try {
            VFSManager.getInstance().requestUpdating(updateRootOnBUDA + "update.bmf", updateRootOnBUDA + "update.bsf", false);
        }
        catch (Exception e) {
            Debugging.dmsg("applyUpdate(): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMenuLanguage(String language, int dialect) {
        PersistentSettings.setString(0, language);
        int b1 = language.charAt(0) << 16;
        int b2 = language.charAt(1) << 8;
        char b3 = language.charAt(2);
        RegisterAccess.getInstance().setGPR(3003, b1 | b2 | b3);
        RegisterAccess.getInstance().setGPR(3004, dialect);
        this.languageSuffix = "_" + language;
        TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
        if (g2B != null && (g2B.isUpdateDetermining() || g2B.isUpdateDownloading())) {
            Object object = g2BMonitor;
            synchronized (object) {
                try {
                    g2BMonitor.wait(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        this.runTitle1Start();
    }

    public void getMenuLanguage() {
        int languageValue = RegisterAccess.getInstance().getGPR(3003);
        char b3 = (char)(languageValue & 0xFF);
        char b2 = (char)(languageValue >> 8 & 0xFF);
        char b1 = (char)(languageValue >> 16 & 0xFF);
        String language = String.valueOf(b1) + String.valueOf(b2) + String.valueOf(b3);
        Debugging.dmsg(language);
        this.languageSuffix = "_" + language;
        Debugging.dmsg("getMenuLanguage: " + language);
        PersistentSettings.setString(0, language);
    }

    public void run() {
        this.runStartupSequence();
    }

    public void replaceTestUpdate() {
        Debugging.dmsg("replacing assets with test assets");
        Debugging.dmsg(BDProperties.getBindingUnitRoot());
        String updateRootOnDisc = BDProperties.getVFSRoot() + "/BDMV/JAR/UPDATE/";
        String updateRootOnBUDA = BDProperties.getBindingUnitRoot() + "/7fff0c8e/" + BDProperties.getDiscID() + "/updates/g2b/v1/";
        this.fileCopy(updateRootOnDisc + "bumf.bmf", updateRootOnBUDA + "update.bmf");
        this.fileCopy(updateRootOnDisc + "bumf.bsf", updateRootOnBUDA + "update.bsf");
        this.fileCopy(updateRootOnDisc + "12345.bdj", updateRootOnBUDA + "12345.bdj");
        this.fileCopy(updateRootOnDisc + "06996.jar", updateRootOnBUDA + "06996.jar");
    }

    protected void displayG2BState() {
        if (g2B == null) {
            return;
        }
        Debugging.dmsg("G2B State: " + g2B.isUpdateAvailable() + " " + g2B.isUpdateApplied() + " " + g2B.isUpdateComplete() + " " + g2B.isUpdateDetermining() + " " + g2B.isUpdateDownloading() + " " + g2B.isUpdateError() + " " + g2B.isUpdateInactive());
        if (g2B.isUpdateError()) {
            Debugging.dmsg("G2B Error Code: " + g2B.getUpdateErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileCopy(String from, String to) {
        File fromFile = new File(from);
        File toFile = new File(to);
        FileInputStream fromStream = null;
        FileOutputStream toStream = null;
        try {
            int bytesRead;
            fromStream = new FileInputStream(fromFile);
            toStream = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = fromStream.read(buffer)) != -1) {
                toStream.write(buffer, 0, bytesRead);
            }
        }
        catch (FileNotFoundException e) {
            Debugging.dmsg("File not found: " + e);
        }
        catch (IOException e) {
            Debugging.dmsg("IO Exception: " + e);
        }
        finally {
            if (fromStream != null) {
                try {
                    fromStream.close();
                }
                catch (IOException e) {}
            }
            if (toStream != null) {
                try {
                    toStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void runStartupSequence() {
        Debugging.dmsg("DisneyBootloaderFML.runStartupSequence()");
        try {
            this.isProfile2Supported = BDProperties.isProfile2Supported().equalsIgnoreCase("YES");
        }
        catch (Exception e) {
            this.isProfile2Supported = false;
        }
        Debugging.dmsg("isTitleReloading: " + this.isTitleReloading());
        if (this.isTitleReloading()) {
            this.menuXlet.doPreliminaryStartupLogic();
            this.getMenuLanguage();
            if (this.getTopMenuPressed()) {
                TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
                this.runTopMenuTitle2to3MinutesCard();
            } else {
                TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
                if (this.get8SecExpired()) {
                    this.runTitle12to3MinutesCard();
                } else {
                    this.runTitle1StayTunedCard();
                }
            }
        } else {
            if (this.isProfile2Supported) {
                g2B.addStatusListener((G2BStatusListener)this);
                g2B.open(this.menuXlet.getContext());
                g2B.connect();
            }
            this.menuXlet.doPreliminaryStartupLogic();
            if (SKIP_DVM && BDProperties.getMenuLanguage() == 6647399) {
                this.setMenuLanguage("eng", 1);
            } else {
                this.menuXlet.getLayoutManager().load();
                this.menuXlet.getVideoPlayer().startPlaylistAtItem(DVM_PLAYLIST, 99, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTitle1Start() {
        Debugging.dmsg("DisneyBootloaderFML.runTitle1Start()");
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(MAGIC_VIDEO_PLAYLIST + this.languageSuffix, 0, false);
        Debugging.dmsg("told the videoPlayer to do it;");
        while (!this.getMagicVideoEnded()) {
            Object object = videoPlayerMonitor;
            synchronized (object) {
                try {
                    videoPlayerMonitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.getTopMenuPressed()) continue;
        }
        Debugging.dmsg("magic ");
        if (this.getTopMenuPressed()) {
            return;
        }
        if (this.isProfile2Supported && g2B != null && g2B.isUpdateComplete()) {
            this.processStatusApply();
        }
        if (this.isProfile2Supported && g2B != null && g2B.isUpdateError()) {
            this.processStatusError();
        }
        if (this.menuXlet.hasTrailers) {
            this.runTitle1StayTunedCard();
        } else {
            TitleChangeManager.changeTitleAsynchronous(this.menuXlet.getContext(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTitle1StayTunedCard() {
        Debugging.dmsg("DisneyBootloaderFML.runTitle1StayTunedCard()");
        this.menuXlet.getVideoPlayer().startPlaylistAtItem(PLAYLIST_FML_CARDS + this.languageSuffix, 0, false);
        Object object = videoPlayerMonitor;
        synchronized (object) {
            try {
                videoPlayerMonitor.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.processLoadingAssets();
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.getTopMenuPressed()) {
            return;
        }
        this.set8SecExpired(true);
        if (!this.getAssetsLoaded()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.getTopMenuPressed()) {
                return;
            }
            if (!this.getAssetsLoaded()) {
                this.runTitle12to3MinutesCard();
                return;
            }
        }
        if (this.getTopMenuPressed()) {
            return;
        }
        if (this.isProfile2Supported && g2B != null && g2B.isUpdateDetermining()) {
            g2B.close();
        } else {
            this.processStatusUpdate();
            this.processStatusError();
        }
        if (this.getTopMenuPressed()) {
            return;
        }
        this.runTrailersStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run2to3MinutesCard(boolean topMenuTitle) {
        this.startPreloader();
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_FML_CARDS + this.languageSuffix, 1, false);
        Object object = videoPlayerMonitor;
        synchronized (object) {
            try {
                videoPlayerMonitor.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.ltdcBegun = true;
        if (!topMenuTitle && this.getTopMenuPressed()) {
            return;
        }
        if (!this.getStartLoadingAssets()) {
            this.processLoadingAssets();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.ltdcMinimumDurationPassed = true;
        Object e = ltdcMonitor;
        synchronized (e) {
            ltdcMonitor.notifyAll();
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ltdcMaximumDurationPassed = true;
        object = ltdcMonitor;
        synchronized (object) {
            ltdcMonitor.notifyAll();
        }
    }

    protected void runTopMenuTitle2to3MinutesCard() {
        Debugging.dmsg("DisneyBootloaderFML.runTopMenuTitle2to3MinutesCard()");
        this.run2to3MinutesCard(true);
    }

    protected void runTitle12to3MinutesCard() {
        Debugging.dmsg("DisneyBootloaderFML.runTitle12to3MinutesCard()");
        this.run2to3MinutesCard(false);
    }

    protected void runTrailersStart() {
        this.stopPreloader();
        Debugging.dmsg("DisneyBootloaderFML.runTrailersStart()");
        this.relinquishedControl = true;
        this.menuXlet.relinquishControl();
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_TRAILERS + this.languageSuffix, 0, false);
    }

    protected void runTopMenuTitleTopMenu() {
        this.stopPreloader();
        Debugging.dmsg("DisneyBootloaderFML.runTopMenuTitleTopMenu()");
        this.relinquishedControl = true;
        this.menuXlet.relinquishControl();
        if (this.languageSuffix.equals("")) {
            String language = "eng";
            int dialect = 1;
            PersistentSettings.setString(0, language);
            int b1 = language.charAt(0) << 16;
            int b2 = language.charAt(1) << 8;
            char b3 = language.charAt(2);
            RegisterAccess.getInstance().setGPR(3003, b1 | b2 | b3);
            RegisterAccess.getInstance().setGPR(3004, dialect);
            this.languageSuffix = "_" + language;
        }
        this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_TOP_MENU + this.languageSuffix, 0, false);
    }

    protected void processStatusApply() {
        Debugging.dmsg("DisneyBootloaderFML.processStatusApply()");
        if (!this.isProfile2Supported || g2B == null) {
            return;
        }
        Debugging.dmsg("g2B.apply()");
        g2B.apply();
        for (int numRetries = 15; !g2B.isUpdateApplied() && numRetries > 0; --numRetries) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (g2B.isUpdateApplied()) {
            this.relinquishedControl = true;
            this.setAssetsLoaded(false);
            this.setStartLoadingAssets(false);
            this.setIsTitleReloading();
            TitleChangeManager.changeTitleAsynchronous(this.menuXlet.getContext(), 48);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStatusUpdate() {
        Debugging.dmsg("DisneyBootloaderFML.processStatusUpdate()");
        if (!this.isProfile2Supported || g2B == null) {
            return;
        }
        if (g2B.isUpdateDetermining() || g2B.isUpdateDownloading()) {
            if (this.ltdcBegun) {
                while (!this.ltdcMaximumDurationPassed) {
                    Object object = ltdcMonitor;
                    synchronized (object) {
                        try {
                            ltdcMonitor.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            } else {
                this.menuXlet.getVideoPlayer().startPlaylistAtMark(PLAYLIST_FML_CARDS + this.languageSuffix, 1, false);
                Object object = videoPlayerMonitor;
                synchronized (object) {
                    try {
                        videoPlayerMonitor.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.ltdcMinimumDurationPassed = true;
                Object e = ltdcMonitor;
                synchronized (e) {
                    ltdcMonitor.notifyAll();
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.ltdcMaximumDurationPassed = true;
                object = ltdcMonitor;
                synchronized (object) {
                    ltdcMonitor.notifyAll();
                }
            }
            this.updateTimeoutEvent();
        } else if (g2B.isUpdateComplete()) {
            this.processStatusApply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStatusError() {
        block14: {
            block13: {
                Debugging.dmsg("processStatusError");
                if (!this.isProfile2Supported || g2B == null) {
                    return;
                }
                if (!g2B.isUpdateError()) {
                    return;
                }
                int errorCode = g2B.getUpdateErrorCode();
                Debugging.dmsg("error code: " + errorCode);
                if (errorCode == 900) {
                    this.menuXlet.getVideoPlayer().startPlaylistAtItem(PLAYLIST_G2B_CARDS + this.languageSuffix, 2, false);
                }
                if (errorCode == 901) {
                    this.menuXlet.getVideoPlayer().startPlaylistAtItem(PLAYLIST_G2B_CARDS + this.languageSuffix, 1, false);
                }
                if (errorCode == 902) {
                    this.menuXlet.getVideoPlayer().startPlaylistAtItem(PLAYLIST_G2B_CARDS + this.languageSuffix, 0, false);
                }
                g2B.close();
                if (errorCode == 900) break block13;
                if (errorCode == 901) break block13;
                if (errorCode != 902) break block14;
            }
            Object object = videoPlayerMonitor;
            synchronized (object) {
                try {
                    videoPlayerMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void topMenuEvent() {
        Debugging.dmsg("DisneyBootloaderFML.topMenuEvent()");
        this.setTopMenuPressed(true);
        if (g2B != null && g2B.isUpdateComplete()) {
            this.processStatusApply();
        }
        if (this.getAssetsLoaded()) {
            this.processStatusUpdate();
            this.processStatusError();
            this.runTopMenuTitleTopMenu();
        } else {
            this.runTopMenuTitle2to3MinutesCard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assetsLoadedEvent() {
        Debugging.dmsg("DisneyBootloaderFML.assetsLoadedEvent()");
        if (!this.getTopMenuPressed() && !this.get8SecExpired()) {
            return;
        }
        while (!this.ltdcMinimumDurationPassed) {
            Object object = ltdcMonitor;
            synchronized (object) {
                try {
                    ltdcMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.processStatusUpdate();
        this.processStatusError();
        if (this.getTopMenuPressed()) {
            this.runTopMenuTitleTopMenu();
        } else {
            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
            this.runTrailersStart();
        }
    }

    protected void updateTimeoutEvent() {
        Debugging.dmsg("DisneyBootloaderFML.updateTimeoutEvent()");
        if (!this.isProfile2Supported || g2B == null) {
            return;
        }
        g2B.close();
        if (this.getTopMenuPressed()) {
            this.runTopMenuTitleTopMenu();
        } else {
            this.runTrailersStart();
        }
    }

    protected void processLoadingAssets() {
        Debugging.dmsg("DisneyBootloaderFML.processLoadingAssets()");
        this.setStartLoadingAssets(true);
        ProcessLoadingAssetsThread thread = new ProcessLoadingAssetsThread();
        thread.start();
    }

    protected boolean isTitleReloading() {
        return TitleChangeManager.getTitleReloading();
    }

    protected boolean getTopMenuPressed() {
        return RegisterAccess.getInstance().getGPR(2001) == 1;
    }

    protected boolean get8SecExpired() {
        return RegisterAccess.getInstance().getGPR(2002) == 1;
    }

    protected boolean getMagicVideoEnded() {
        return RegisterAccess.getInstance().getGPR(2003) == 1;
    }

    protected boolean getStartLoadingAssets() {
        return RegisterAccess.getInstance().getGPR(2004) == 1;
    }

    protected boolean getAssetsLoaded() {
        return RegisterAccess.getInstance().getGPR(2005) == 1;
    }

    protected void setIsTitleReloading() {
        TitleChangeManager.setTitleReloading();
    }

    protected void setTopMenuPressed(boolean value) {
        RegisterAccess.getInstance().setGPR(2001, value ? 1 : 0);
    }

    protected void set8SecExpired(boolean value) {
        RegisterAccess.getInstance().setGPR(2002, value ? 1 : 0);
    }

    protected void setMagicVideoEnded(boolean value) {
        RegisterAccess.getInstance().setGPR(2003, value ? 1 : 0);
    }

    protected void setStartLoadingAssets(boolean value) {
        RegisterAccess.getInstance().setGPR(2004, value ? 1 : 0);
    }

    protected void setAssetsLoaded(boolean value) {
        RegisterAccess.getInstance().setGPR(2005, value ? 1 : 0);
    }

    public void titleChangeEventReceived(TitleChangeEvent evt) {
        if (this.relinquishedControl) {
            this.currentComboState = 0;
            return;
        }
        if (evt instanceof TitleStartedEvent) {
            Debugging.dmsg("titleStartedEvent: " + evt.getTitle());
            if (evt.getTitle() == 0) {
                this.topMenuEvent();
            }
        } else if (evt instanceof TitleStoppedEvent) {
            Debugging.dmsg("titleStoppedEvent: " + evt.getTitle());
            if (evt.getTitle() == 1) {
                this.setTopMenuPressed(true);
                this.menuXlet.getVideoPlayer().stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerEventReceived(PlayerEvent evt) {
        if (this.relinquishedControl) {
            return;
        }
        if (evt instanceof PlaylistEndedEvent && evt.getPlaylist().getID().equals(MAGIC_VIDEO_PLAYLIST + this.languageSuffix)) {
            this.setMagicVideoEnded(true);
        }
        Object object = videoPlayerMonitor;
        synchronized (object) {
            videoPlayerMonitor.notifyAll();
        }
    }

    public static String g2BCodeToString(int code) {
        switch (code) {
            case 100: {
                return "g2b.STATUS_UPDATE_INACTIVE";
            }
            case 102: {
                return "g2b.STATUS_UPDATE_DETERMINING";
            }
            case 101: {
                return "STATUS_UPDATE_NOUPDATE";
            }
            case 103: {
                return "STATUS_UPDATE_DOWNLOADING";
            }
            case 104: {
                return "STATUS_UPDATE_COMPLETE";
            }
            case 105: {
                return "STATUS_UPDATE_DOWNLOAD_ERROR";
            }
            case 106: {
                return "STATUS_UPDATE_APPLIED";
            }
            case 900: {
                return "ERROR_STORAGE_TOOSMALL";
            }
            case 901: {
                return "ERROR_STORAGE_FULL";
            }
            case 902: {
                return "ERROR_STORAGE_NOTINSERTED";
            }
            case 903: {
                return "ERROR_NETWORK_FAILURE";
            }
            case 904: {
                return "ERROR_VFS_FAILURE";
            }
            case 999: {
                return "ERROR_GENERAL_FAILURE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusChanged(G2BStatusEvent evt) {
        if (evt.code != 102 && evt.code != 103) {
            Object object = g2BMonitor;
            synchronized (object) {
                g2BMonitor.notifyAll();
            }
        }
        if (g2B.isUpdateError()) {
            Debugging.dmsg("G2B.statusChanged(): " + DisneyBootloaderFML.g2BCodeToString(evt.code) + "(" + DisneyBootloaderFML.g2BCodeToString(g2B.getUpdateErrorCode()) + ")");
        } else {
            Debugging.dmsg("G2B.statusChanged(): " + DisneyBootloaderFML.g2BCodeToString(evt.code));
        }
        if (!this.isProfile2Supported || g2B == null) {
            return;
        }
        if (g2B.isUpdateDetermining() || g2B.isUpdateInactive()) {
            return;
        }
        if (g2B.isUpdateAvailable()) {
            if (!this.getTopMenuPressed() && !this.get8SecExpired()) {
                return;
            }
            if (g2B.isUpdateComplete()) {
                this.processStatusApply();
                return;
            }
            if (!this.getAssetsLoaded()) {
                return;
            }
            this.processStatusError();
        } else {
            if (!this.getTopMenuPressed() && !this.get8SecExpired()) {
                return;
            }
            if (!this.getAssetsLoaded()) {
                return;
            }
        }
        if (this.getTopMenuPressed()) {
            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 0);
            this.runTopMenuTitleTopMenu();
        } else {
            TitleChangeManager.changeTitle(this.menuXlet.getContext(), 1);
            this.runTrailersStart();
        }
    }

    public void userEventReceived(UserEvent evt) {
        if (evt.getType() == 401 && this.relinquishedControl && TitleChangeManager.getTitleNumber() == 0) {
            if (evt.getCode() == secretCombination[this.currentComboState]) {
                if (this.currentComboState == secretCombination.length - 1) {
                    this.setAssetsLoaded(false);
                    this.setStartLoadingAssets(false);
                    this.setTopMenuPressed(true);
                    this.setIsTitleReloading();
                    RegisterAccess.getInstance().setGPR(1999, 2);
                    TitleChangeManager.changeTitleAsynchronous(this.menuXlet.getContext(), 48);
                } else {
                    ++this.currentComboState;
                }
            } else {
                this.currentComboState = 0;
            }
        }
    }

    public void destroy() {
        this.setAssetsLoaded(false);
        this.setStartLoadingAssets(false);
        this.setIsTitleReloading();
    }

    private void startPreloader() {
        this.menuXlet.getLayoutManager().pauseRendering();
        this.preloader = new Preloader(this.menuXlet);
    }

    private void stopPreloader() {
        if (this.preloader != null) {
            this.preloader.end();
            this.preloader = null;
            this.menuXlet.getLayoutManager().resumeRendering();
        }
    }

    class ProcessLoadingAssetsThread
    extends Thread {
        ProcessLoadingAssetsThread() {
        }

        public void run() {
            DisneyBootloaderFML.this.menuXlet.loadAssets();
            DisneyBootloaderFML.this.setAssetsLoaded(true);
            DisneyBootloaderFML.this.assetsLoadedEvent();
        }
    }

    protected class G2BCheckerTask
    extends TimerTask {
        protected G2BCheckerTask() {
        }

        public void run() {
            DisneyBootloaderFML.this.displayG2BState();
        }
    }
}

