/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.media;

import com.zoo.MenuXlet;
import com.zoo.media.PlayerEvent;
import com.zoo.media.PlayerListener;
import com.zoo.media.Playlist;
import com.zoo.media.PlaylistEndedEvent;
import com.zoo.media.PlaylistStartedEvent;
import com.zoo.util.AWTVideoSizeUtility;
import com.zoo.util.AngleChangeUtility;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.DiscTrackerManager;
import com.zoo.util.FileUtils;
import com.zoo.util.LanguageManager;
import com.zoo.util.PersistentSettings;
import com.zoo.util.PlaylistUtility;
import com.zoo.util.PrimaryAudioUtility;
import com.zoo.util.ResourceManager;
import com.zoo.util.SubtitleUtility;
import com.zoo.util.XMLParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.selection.ServiceContextException;
import org.bluray.media.PlayListChangeControl;
import org.bluray.media.PlaybackControl;
import org.bluray.media.PlaybackListener;
import org.bluray.media.PlaybackMarkEvent;
import org.bluray.media.PlaybackPlayItemEvent;
import org.bluray.media.StreamNotAvailableException;
import org.bluray.net.BDLocator;
import org.bluray.ti.PlayList;
import org.bluray.ti.Title;
import org.davic.media.MediaPresentedEvent;

public class VideoPlayer
implements ControllerListener,
PlaybackListener,
Runnable {
    public static final String DEFAULT_DISC_CONFIG = "disc";
    public static final String ROOT_TAG = "disc";
    private static Player player = null;
    private MenuXlet menuXlet;
    private Playlist currPlaylist;
    private int currPlayMark = -1;
    private int currPlayItem = -1;
    private Playlist playOnceBlockStart = null;
    private int currentTitle = -1;
    private ArrayList playlists = new ArrayList();
    private ArrayList disctracker_playlists = new ArrayList();
    private int currState = 0;
    private boolean resumeValid = false;
    private Playlist resumePlaylist = null;
    private int resumePlayMark = -1;
    private long resumeTime = 0L;
    private int resumePlayMark_backup = -1;
    private long resumeTime_backup = 0L;
    private boolean blockResumeBackup = false;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static PlayList[] BDplayLists = null;
    private String startPL_playList;
    private int startPL_playMark;
    private int startPL_playItem;
    private boolean startPL_tryResume;
    private boolean startPL_hideMenu;
    private long startPL_TC;
    public boolean looping = false;
    private boolean startEventOccurred = false;
    private boolean mediaPresentedEventOccurred = false;
    private boolean isSD = false;
    private boolean lockoutPopup = false;
    private boolean videoScaled = false;
    private boolean timelineShowing = false;
    private boolean lockoutTimeline = false;
    private boolean timelineEnabled = true;
    private Timer timelineTimer = null;
    private Timer unlocktimelineTimer = null;
    private Timer startEventTimer = null;
    private Timer mediaPositionTimer = null;
    private long lastMediaNanos = 0L;
    private long timelineOverrideTime = -1L;
    private int timelineOverrideChapter = 0;
    public final Object mediaMonitor = new Object();
    private boolean resized = false;
    private boolean startingNewPlaylist = false;
    Timer unblockTimer = null;
    boolean alreadyUnblocked = false;
    public int episodeNumber = -1;
    boolean prefetchComplete = false;
    private final Object prefetchMonitor = new Object();
    private PlaybackControl playbackControl = null;
    protected static ArrayList listeners = new ArrayList();
    private PlayListChangeControl plcontrol = null;
    Timer mediaPresentedEventTimer = null;
    private final Object timelineLock = new Object();
    boolean ready = false;
    static /* synthetic */ Class class$org$bluray$media$PlaybackControl;
    static /* synthetic */ Class class$org$bluray$media$PlayListChangeControl;

    public void addPlayerListener(PlayerListener listener) {
        listeners.add(listener);
    }

    public void removePlayerListener(PlayerListener listener) {
        listeners.remove(listener);
    }

    void firePlayerEvent(PlayerEvent evt) {
        for (int i = 0; i < listeners.size(); ++i) {
            Thread thread = new Thread(new EventRunnable(evt, (PlayerListener)listeners.get(i)));
            thread.start();
        }
    }

    public void init(MenuXlet xlet) {
        this.menuXlet = xlet;
        try {
            int i;
            String discConfig = "disc.xml";
            String params = PersistentSettings.getString(0);
            if (!params.equals("")) {
                discConfig = "disc_" + params + ".xml";
            }
            if (!FileUtils.fileExists(ResourceManager.getFileRoot() + discConfig)) {
                discConfig = "disc.xml";
            }
            Debugging.dmsg("ESS - Loading discconfig: " + discConfig);
            String filename = ResourceManager.getFileRoot() + discConfig;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            XMLParser xmlroot = new XMLParser(in);
            in.close();
            XMLParser rootNode = xmlroot.findElement("disc");
            for (int i2 = 0; i2 < rootNode.size(); ++i2) {
                XMLParser n = rootNode.getElement(i2);
                this.addPlaylist(n);
            }
            String playlistStatus = PersistentSettings.getString(12);
            String[] tokens = FileUtils.tokenizeString(playlistStatus, ",");
            if (tokens != null) {
                for (i = 0; i < tokens.length; ++i) {
                    int playlistIdx = Integer.parseInt(tokens[i]);
                    if (playlistIdx >= this.playlists.size()) continue;
                    Playlist p = (Playlist)this.playlists.get(Integer.parseInt(tokens[i]));
                    p.setPlayOnceBlockPlayed(true);
                }
            }
            for (i = 0; i < this.playlists.size(); ++i) {
                Playlist p = (Playlist)this.playlists.get(i);
                if (p.isResumableDiscTracker()) {
                    this.disctracker_playlists.add(p.getID());
                }
                if (this.disctracker_playlists.isEmpty()) continue;
                Debugging.dmsg("                         Setting Disc Tracker in INITIALIZE VIDEO PLAYER");
                PersistentSettings.setLong(2, DiscTrackerManager.getTrackerTime());
                PersistentSettings.setInt(4, DiscTrackerManager.getTrackerPlayMark());
            }
            this.addPlayitems();
            this.mediaPositionTimer = new Timer();
            class MonitorPositionTask
            extends TimerTask {
                MonitorPositionTask() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = VideoPlayer.this.mediaMonitor;
                    synchronized (object) {
                        try {
                            long currentMediaNanos = player.getMediaNanoseconds();
                            if (VideoPlayer.this.currPlaylist != null && VideoPlayer.this.currPlaylist.isResumable()) {
                                VideoPlayer.this.resumeTime = player.getMediaNanoseconds();
                                VideoPlayer.this.resumePlaylist = VideoPlayer.this.currPlaylist;
                                VideoPlayer.this.resumePlayMark = BDProperties.getChapterNumber() - 1;
                                DiscTrackerManager.setTrackerTime(VideoPlayer.this.resumeTime);
                                DiscTrackerManager.setTrackerPlayMark(VideoPlayer.this.resumePlayMark);
                                if (VideoPlayer.this.resumePlaylist != null && VideoPlayer.this.currPlaylist != null && VideoPlayer.this.resumeValid) {
                                    PersistentSettings.setString(3, VideoPlayer.this.resumePlaylist.getID());
                                }
                            }
                            if (!(currentMediaNanos - VideoPlayer.this.lastMediaNanos <= 2000000000L && currentMediaNanos - VideoPlayer.this.lastMediaNanos >= 0L || player.getRate() != 1.0f || VideoPlayer.this.lockoutPopup || VideoPlayer.this.lockoutTimeline || !VideoPlayer.this.currPlaylist.isResumable())) {
                                if (BDProperties.getChapterNumber() > 0 && BDProperties.getChapterNumber() <= VideoPlayer.this.menuXlet.getLayoutManager().getMenu(VideoPlayer.this.currPlaylist.getTimeline() + "_SS").getButtons().size()) {
                                    Debugging.dmsg("+++++mediaMonitor : showTimeline()");
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException ex) {
                                        // empty catch block
                                    }
                                    VideoPlayer.this.showTimeline();
                                }
                                VideoPlayer.this.hideTimeline();
                            }
                            VideoPlayer.this.lastMediaNanos = currentMediaNanos;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.mediaPositionTimer.schedule((TimerTask)new MonitorPositionTask(), 1000L, 400L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addPlaylist(XMLParser n) {
        this.playlists.add(new Playlist(n));
    }

    public void start() {
        Playlist startPlaylist = Playlist.getTrailerPlaylist();
        try {
            BDLocator locator = new BDLocator(startPlaylist.getLocator());
            org.davic.media.MediaLocator ml = new org.davic.media.MediaLocator((org.davic.net.Locator)locator);
            player = Manager.createPlayer((MediaLocator)ml);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (startPlaylist != null) {
                this.startPlaylistAtMark(startPlaylist.getID(), 0, false);
            }
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.start(): " + e);
        }
    }

    public void initializePlayer() {
        try {
            Playlist playlist = Playlist.getDVMPlaylist();
            if (playlist == null) {
                return;
            }
            BDLocator locator = new BDLocator(playlist.getLocator());
            org.davic.media.MediaLocator ml = new org.davic.media.MediaLocator((org.davic.net.Locator)locator);
            player = Manager.createPlayer((MediaLocator)ml);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.initializePlayer(): " + e);
        }
    }

    public void start_firstPlay() {
        Playlist startPlaylist = Playlist.getDVMPlaylist();
        try {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            int parentalLevel = 1;
            int regionCode = 1;
            if (BDProperties.getPlayerRegion() == regionCode && BDProperties.getPlayerParentalSetting() < parentalLevel) {
                this.startPlaylistAtMark("ParentalWarning", 0, false);
                return;
            }
            if (startPlaylist != null) {
                this.startPlaylistAtItem(startPlaylist.getID(), 99, false);
            }
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.start(): " + e);
        }
    }

    public synchronized void startPlaylistAtMark(String p, int m, boolean tryResume) {
        this.startPlaylistAtMark(p, m, tryResume, true);
    }

    public synchronized void startPlaylistAtMark(String p, int m, boolean tryResume, boolean hideMenu) {
        this.startPL_playList = p;
        this.startPL_playMark = m;
        this.startPL_playItem = -1;
        this.startPL_TC = -1L;
        this.startPL_tryResume = tryResume;
        this.startPL_hideMenu = hideMenu;
        Thread t = new Thread(this);
        t.setName("playlistStartUpMark");
        t.start();
    }

    public synchronized void startPlaylistAtMarkSynchronized(String p, int m, boolean tryResume) {
        this.startPL_playList = p;
        this.startPL_playMark = m;
        this.startPL_playItem = -1;
        this.startPL_TC = -1L;
        this.startPL_tryResume = tryResume;
        this.startPL_hideMenu = true;
        this.run();
    }

    public synchronized void startPlaylistAtItem(String p, int i, boolean tryResume) {
        this.startPL_playList = p;
        this.startPL_playMark = 0;
        this.startPL_playItem = i;
        this.startPL_TC = -1L;
        this.startPL_tryResume = tryResume;
        this.startPL_hideMenu = true;
        Thread t = new Thread(this);
        t.setName("playlistStartUpItem");
        t.start();
    }

    public synchronized void startPlaylistAtTC(String p, long reqTC, boolean tryResume) {
        this.startPL_playList = p;
        this.startPL_playMark = 0;
        this.startPL_playItem = -1;
        this.startPL_TC = reqTC;
        this.startPL_tryResume = tryResume;
        this.startPL_hideMenu = true;
        Thread t = new Thread(this);
        t.setName("playlistStartUpTC");
        t.start();
    }

    public void run() {
        Debugging.dmsg(this.startPL_playList + " " + this.startPL_playItem + " " + this.startPL_playMark + " " + this.startPL_TC + " " + this.startPL_tryResume + " " + this.startPL_hideMenu);
        this.startPlaylist(this.startPL_playList, this.startPL_playItem, this.startPL_playMark, this.startPL_TC, this.startPL_tryResume, this.startPL_hideMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startPlaylist(String p, int i, int m, long reqTC, boolean tryResume, boolean hideMenu) {
        long startPlayTime = 0L;
        DiscTrackerManager.rejectFurtherInput = true;
        if (hideMenu) {
            this.lockoutPopup = true;
        }
        this.timelineOverrideTime = -1L;
        this.timelineOverrideChapter = 0;
        try {
            this.mediaPositionTimer.wait();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.timelineShowing) {
            if (this.timelineTimer != null) {
                try {
                    this.timelineTimer.cancel();
                    this.timelineTimer = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.timelineShowing = false;
            Object e = this.menuXlet.getLayoutManager().keyPressMonitor;
            synchronized (e) {
                this.menuXlet.getLayoutManager().getMenu(this.currPlaylist.getTimeline()).hide();
            }
        }
        LanguageManager.checkStreamSurfing(this.currPlaylist);
        try {
            Debugging.dmsg("start new playlist");
            this.startingNewPlaylist = true;
            if (tryResume && this.resumeValid && this.getPlaylist(p).getID().equalsIgnoreCase(this.resumePlaylist.getID())) {
                Debugging.dmsg("Trying Resume: " + this.getPlaylist(p).getID());
                this.currPlaylist = this.resumePlaylist;
                startPlayTime = this.resumeTime = DiscTrackerManager.getTrackerTime();
            } else if (tryResume && this.resumeValid && this.episodeNumber > 0 && this.getPlaylist(p).getEpisodeNumber() > 0 && this.resumePlaylist.getID().endsWith("PA")) {
                Debugging.dmsg("Trying Resume for Episodic: " + this.getCurrentPlaylist().getID());
                this.currPlaylist = this.resumePlaylist;
                startPlayTime = this.resumeTime = DiscTrackerManager.getTrackerTime();
            } else {
                Debugging.dmsg("NO Resume: " + this.getPlaylist(p).getID());
                this.updateResumeInfo();
                this.currPlaylist = this.getPlaylist(p);
                if (reqTC != -1L) {
                    startPlayTime = reqTC;
                }
            }
            if (this.currPlaylist.getTimeline() == null || this.currPlaylist.getTimeline().equals("")) {
                this.disableTimeline();
            }
            if (hideMenu) {
                this.menuXlet.getLayoutManager().hideMenu();
            }
            this.currPlayMark = m;
            this.currPlayItem = i;
            if (this.currPlayItem != -1) {
                this.currPlayMark = -1;
            }
            this.skipPlayOnceVideos();
            this.startEventOccurred = false;
            this.mediaPresentedEventOccurred = false;
            if (player != null) {
                player.removeControllerListener((ControllerListener)this);
            }
            Player stopPlayer = player;
            BDLocator locator = new BDLocator(null, -1, this.currPlaylist.getPlaylistID(), this.currPlayItem, this.currPlayMark, null);
            org.davic.media.MediaLocator ml = new org.davic.media.MediaLocator((org.davic.net.Locator)locator);
            player = Manager.createPlayer((MediaLocator)ml);
            if (this.currPlayMark != -1) {
                PlaylistUtility.setPlaylist(locator, player);
            }
            player.addControllerListener((ControllerListener)this);
            player.prefetch();
            this.waitForPrefetch();
            if (startPlayTime != 0L) {
                player.setMediaTime(new Time(startPlayTime));
            }
            if (this.resized) {
                this.resizeVideo(0, 0, 1920, 1080);
            }
            LanguageManager.setAudioAndSubtitleStreams(this.currPlaylist);
            this.startingNewPlaylist = false;
            if (stopPlayer != null) {
                stopPlayer.stop();
                stopPlayer.close();
                stopPlayer.deallocate();
            }
            player.start();
            if (this.currPlaylist.isResumable()) {
                this.resumeValid = true;
                DiscTrackerManager.setTrackerPlaylistID(this.currPlaylist.getID());
                PersistentSettings.setBoolean(1, true);
            }
            if (this.currPlaylist.getEpisodeNumber() > 0) {
                this.episodeNumber = this.currPlaylist.getEpisodeNumber();
            }
            if (this.currPlaylist.getEpisodeNumber() > 0 && !this.currPlaylist.isResumable()) {
                this.resumeValid = false;
            }
            DiscTrackerManager.rejectFurtherInput = false;
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.startPlaylistAt(): " + e);
        }
    }

    public void skipToMark(int mark) {
        PlaybackControl pc = this.getPlaybackControl();
        pc.skipToMark(mark);
        this.playbackControl = null;
    }

    private PlaybackControl getPlaybackControl() {
        if (null == this.playbackControl) {
            this.playbackControl = (PlaybackControl)player.getControl((class$org$bluray$media$PlaybackControl == null ? (class$org$bluray$media$PlaybackControl = VideoPlayer.class$("org.bluray.media.PlaybackControl")) : class$org$bluray$media$PlaybackControl).getName());
        }
        return this.playbackControl;
    }

    private PlayListChangeControl getPlayListControl() throws NoPlayerException, SecurityException, IOException, ServiceContextException {
        if (this.plcontrol == null) {
            String name = (class$org$bluray$media$PlayListChangeControl == null ? (class$org$bluray$media$PlayListChangeControl = VideoPlayer.class$("org.bluray.media.PlayListChangeControl")) : class$org$bluray$media$PlayListChangeControl).getName();
            this.plcontrol = (PlayListChangeControl)this.getPlayer().getControl(name);
        }
        return this.plcontrol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPrefetch() {
        this.prefetchComplete = false;
        for (int remainingRetries = 10; !this.prefetchComplete && remainingRetries > 0; --remainingRetries) {
            Debugging.dmsg("waiting for prefetch");
            Object object = this.prefetchMonitor;
            synchronized (object) {
                try {
                    this.prefetchMonitor.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void skipPlayOnceVideos() {
        boolean processedSkip;
        do {
            processedSkip = false;
            if (!this.getCurrentPlaylist().getPlayOnceStart() && !this.getCurrentPlaylist().getPlayOnceOnEntry()) continue;
            if (this.getCurrentPlaylist().getPlayOnceBlockPlayed()) {
                boolean skipped = false;
                do {
                    String nextList;
                    if (this.getCurrentPlaylist().getPlayOnceEnd() || this.getCurrentPlaylist().getPlayOnceOnEntry()) {
                        skipped = true;
                    }
                    if ((nextList = this.getCurrentPlaylist().getNextPlaylist()) == null) {
                        this.currPlaylist = null;
                        return;
                    }
                    this.currPlaylist = this.getPlaylist(nextList);
                    this.currPlayMark = this.getCurrentPlaylist().getNextPlayMark();
                    processedSkip = true;
                } while (!skipped);
                if (this.getCurrentPlaylist() != null) continue;
                continue;
            }
            if (this.getCurrentPlaylist().getPlayOnceOnEntry()) continue;
            this.playOnceBlockStart = this.getCurrentPlaylist();
        } while (processedSkip);
    }

    public Player getPlayer() {
        return player;
    }

    public Playlist getPlaylist(String d) {
        for (int i = 0; i < this.playlists.size(); ++i) {
            if (!d.equalsIgnoreCase(((Playlist)this.playlists.get(i)).getID())) continue;
            return (Playlist)this.playlists.get(i);
        }
        return null;
    }

    public int getPlaylistCount() {
        return this.playlists.size();
    }

    public ArrayList getPlaylists() {
        return this.playlists;
    }

    public Playlist getPlaylist(int idx) {
        return (Playlist)this.playlists.get(idx);
    }

    public Playlist getCurrentPlaylist() {
        return this.currPlaylist;
    }

    public synchronized void setAngle(int angle_id) {
        try {
            AngleChangeUtility.setAngle(angle_id, player);
        }
        catch (Exception e) {
            Debugging.dmsg("could not set Angle!::: " + e);
        }
    }

    public synchronized void setDefaultAngle() {
        try {
            AngleChangeUtility.setDefaultAngle(player);
        }
        catch (Exception e) {
            Debugging.dmsg("could not set default Angle!::: " + e);
        }
    }

    public synchronized int getCurrentAngle() {
        int curAngle = AngleChangeUtility.getCurrentAngle(player);
        return curAngle;
    }

    public synchronized int getAvailableAngles() {
        int availableAngles = AngleChangeUtility.getAvailableAngles(player);
        return availableAngles;
    }

    public int getPlayback() {
        return this.currState;
    }

    public synchronized void setAudio(int stream_id) {
        try {
            PrimaryAudioUtility.setStream(stream_id, player);
        }
        catch (Exception e) {
            Debugging.dmsg("could not set Audio!::: " + e);
        }
    }

    public synchronized int getCurrentAudio() {
        int curAudioStream = PrimaryAudioUtility.getCurrentStream(player);
        return curAudioStream;
    }

    public synchronized void setSubtitles(int subtitle_stream_id) throws StreamNotAvailableException {
        SubtitleUtility.enable(subtitle_stream_id, player);
    }

    public synchronized void setSubtitlesOff(int subtitle_stream_id) throws StreamNotAvailableException {
        SubtitleUtility.disable(subtitle_stream_id, player);
    }

    public Time getCurrentTime() {
        return player.getMediaTime();
    }

    public float getCurrentRate() {
        return player.getRate();
    }

    public void stop() {
        try {
            if (player != null) {
                this.disableTimeline();
                this.updateResumeInfo();
                this.blockResumeBackup = true;
                player.stop();
            }
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.stop(): " + e);
        }
    }

    public void destroy() {
        Debugging.dmsg("videoPlayer.destroy()");
        try {
            LanguageManager.checkStreamSurfing(this.currPlaylist);
            this.updateResumeInfo();
            this.stop();
            player.close();
            player = null;
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.destroy(): " + e);
        }
    }

    public void handleTitleStart(int title_id) {
        this.currentTitle = title_id;
        this.start();
    }

    public void handleTitleStop(int title_id) {
        if (title_id == 1) {
            try {
                this.updateResumeInfo();
            }
            catch (Exception e) {
                Debugging.dmsg("Could not update resume info : " + e);
            }
        }
        this.stop();
    }

    private void addPlayerListeners(Player player) {
        try {
            if (player != null) {
                player.addControllerListener((ControllerListener)this);
                Debugging.dmsg("ControllerListener added to Player");
            }
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.addPlayerListeners: " + e);
        }
    }

    private void removePlayerListeners(Player player, Playlist playlist) {
        try {
            player.removeControllerListener((ControllerListener)this);
            Debugging.dmsg("ControllerListener removed from Player");
        }
        catch (Exception e) {
            Debugging.dmsg("VideoPlayer.removePlayerListeners: " + e);
        }
    }

    private void handleStartEvent() {
        Debugging.dmsg("******ENTERING HANDLE START EVENT from******" + this.currPlaylist.getID());
        if (this.startingNewPlaylist) {
            return;
        }
        this.blockResumeBackup = false;
        this.menuXlet.getLayoutManager().resetTimer();
        if (this.currPlaylist.getPlayOnceOnEntry()) {
            this.currPlaylist.setPlayOnceBlockPlayed(true);
            this.updatePersistentSettingsPlayOnceStatus();
        }
        if (this.currPlaylist.isResumableDiscTracker()) {
            DiscTrackerManager.setFeatureAccesedOnce(true);
        }
        if (this.currPlaylist.isResumableDiscTracker() && !DiscTrackerManager.getTrackerState().equals("off")) {
            DiscTrackerManager.setTrackerState("playback");
        }
        this.lockoutTimeline = true;
        Debugging.dmsg("                lockoutTimeline = true");
        String actions = this.currPlaylist.getOnStart();
        if (this.currPlaylist.getOnStartOverrideNextOnStart() != null) {
            Playlist.overrideOnStart(this.currPlaylist.getOnStartOverrideNextOnStart());
        }
        if (this.currPlaylist.isMultiAngle()) {
            this.setDefaultAngle();
        }
        if (this.currPlaylist.getID().startsWith("DubCards")) {
            DiscTrackerManager.setTrackerPlayMarkWithoutVailidation(0);
        }
        if (this.currPlaylist.getID().startsWith("Warnings")) {
            DiscTrackerManager.setTrackerPlayMarkWithoutVailidation(0);
        }
        if (this.startEventTimer != null) {
            this.startEventTimer.cancel();
        }
        this.startEventTimer = new Timer();
        class StartEventTask
        extends TimerTask {
            String actions;

            StartEventTask(String actions) {
                this.actions = actions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ((VideoPlayer)VideoPlayer.this).menuXlet.getLayoutManager().keyPressMonitor;
                synchronized (object) {
                    Debugging.dmsg("*******************************onStart actions: " + this.actions);
                    if (this.actions != null) {
                        VideoPlayer.this.menuXlet.getActionManager().handleActions(this.actions);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    Debugging.dmsg("                 enable 1");
                    VideoPlayer.this.disableTimeline();
                    if (!VideoPlayer.this.currPlaylist.isResumableDiscTracker()) {
                        VideoPlayer.this.lockoutPopup = false;
                    }
                }
                object = VideoPlayer.this.mediaMonitor;
                synchronized (object) {
                    try {
                        VideoPlayer.this.mediaPositionTimer.notify();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.startEventTimer.schedule((TimerTask)new StartEventTask(actions), this.isSD != this.currPlaylist.getIsSD() ? 1000L : 0L);
        this.isSD = this.currPlaylist.getIsSD();
        if (this.currPlaylist.isResumable()) {
            try {
                if (this.unlocktimelineTimer != null) {
                    this.unlocktimelineTimer.cancel();
                }
                this.unlocktimelineTimer = new Timer();
                class UnlockTimelineEventTask
                extends TimerTask {
                    UnlockTimelineEventTask() {
                    }

                    public void run() {
                        VideoPlayer.this.lockoutTimeline = false;
                        VideoPlayer.this.enableTimeline();
                        VideoPlayer.this.lockoutPopup = false;
                        Debugging.dmsg("           Unlock == lockoutTimeline = false");
                    }
                }
                this.unlocktimelineTimer.schedule((TimerTask)new UnlockTimelineEventTask(), 2000L);
            }
            catch (Exception e) {
                Debugging.dmsg("  could not sceduale timer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent arg1) {
        if (arg1 instanceof PrefetchCompleteEvent) {
            Debugging.dmsg("VideoPlayer.controllerUpdate - PrefetchCompleteEvent :" + this.currPlaylist.getID());
            this.prefetchComplete = true;
            Object object = this.prefetchMonitor;
            synchronized (object) {
                this.prefetchMonitor.notifyAll();
            }
        } else if (arg1 instanceof StartEvent) {
            PlaylistStartedEvent evt = new PlaylistStartedEvent(this);
            evt.setPlaylist(this.currPlaylist);
            this.firePlayerEvent(evt);
            this.menuXlet.startTime = System.currentTimeMillis();
            Debugging.dmsg("VideoPlayer.controllerUpdate - StartEvent: " + this.currPlaylist.getID());
            Debugging.dmsg("currPlaylist.getEpisodeNumber(): " + this.currPlaylist.getEpisodeNumber());
            Debugging.dmsg("currPlaylist.hasCommentary(): " + this.currPlaylist.hasCommentary());
            if (this.currPlaylist.getEpisodeNumber() > 0 && !this.currPlaylist.hasCommentary()) {
                Debugging.dmsg("Controller update, start event, turn commentary off");
                PersistentSettings.setBoolean(14, false);
                PersistentSettings.setInt(15, 33);
            }
            this.menuXlet.onStartEventOccurred = true;
            LanguageManager.setAudioAndSubtitleStreams(this.currPlaylist);
            if (!this.looping) {
                if (this.mediaPresentedEventOccurred) {
                    this.mediaPresentedEventOccurred = false;
                    this.handleStartEvent();
                } else {
                    this.startEventOccurred = true;
                    if (this.mediaPresentedEventTimer != null) {
                        this.mediaPresentedEventTimer.cancel();
                    }
                    this.mediaPresentedEventTimer = new Timer();
                    this.mediaPresentedEventTimer.schedule((TimerTask)new GenerateMediaPresentedEventTask(), 5000L);
                }
            } else {
                this.looping = false;
            }
        } else if (arg1 instanceof MediaPresentedEvent) {
            if (this.startEventOccurred) {
                this.startEventOccurred = false;
                this.handleStartEvent();
            } else {
                if (this.mediaPresentedEventTimer != null) {
                    this.mediaPresentedEventTimer.cancel();
                    this.mediaPresentedEventTimer = null;
                }
                this.mediaPresentedEventOccurred = true;
            }
        } else if (arg1 instanceof EndOfMediaEvent) {
            Debugging.dmsg("VideoPlayer.controllerUpdate - EndOfMediaEvent: " + this.currPlaylist.getID());
            this.lockoutTimeline = true;
            PlaylistEndedEvent evt = new PlaylistEndedEvent(this);
            evt.setPlaylist(this.currPlaylist);
            this.firePlayerEvent(evt);
            this.menuXlet.waitingForVideoPlayback = false;
            Debugging.dmsg("currPlaylist = " + this.getCurrentPlaylist().getID());
            Debugging.dmsg("currPlaylist resumeable ? = " + this.getCurrentPlaylist().isResumable());
            if (this.getCurrentPlaylist().isResumable()) {
                PersistentSettings.setBoolean(1, false);
                PersistentSettings.setInt(4, 0);
                this.resumeValid = false;
                DiscTrackerManager.setTrackerTime(0L);
                DiscTrackerManager.setTrackerPlayMarkWithoutVailidation(0);
                DiscTrackerManager.setTrackerState("initial");
                this.updateResumeInfo();
                if (this.currPlaylist.isResumableDiscTracker()) {
                    Debugging.dmsg("currPlaylist.isResumableDiscTracker()");
                    if (this.disctracker_playlists.contains(this.currPlaylist.getID())) {
                        Debugging.dmsg("disctracker_playlists.remove(currPlaylist.getID()) " + this.currPlaylist.getID());
                        this.disctracker_playlists.remove(this.currPlaylist.getID());
                    }
                    if (this.disctracker_playlists.isEmpty()) {
                        Debugging.dmsg("disctracker_playlists.isEmpty())");
                        DiscTrackerManager.setTrackerState("off");
                    }
                }
            }
            if (this.getCurrentPlaylist().getPlayOnceEnd() && this.playOnceBlockStart != null) {
                this.playOnceBlockStart.setPlayOnceBlockPlayed(true);
                this.playOnceBlockStart = null;
                this.updatePersistentSettingsPlayOnceStatus();
            }
            if (this.currPlaylist.doesLoop()) {
                this.looping = true;
                player.setMediaTime(new Time(0.0));
                player.start();
            } else {
                String actions;
                if (this.currPlaylist.getOnEndOverrideNextOnStart() != null) {
                    Playlist.overrideOnStart(this.currPlaylist.getOnEndOverrideNextOnStart());
                }
                if ((actions = this.currPlaylist.getOnEnd()) != null) {
                    this.menuXlet.getActionManager().handleActions(actions);
                }
            }
            if (this.currPlaylist.isLastEpisode()) {
                this.episodeNumber = 0;
            }
        } else if (arg1 instanceof RateChangeEvent) {
            Debugging.dmsg("VideoPlayer.controllerUpdate - RateChangeEvent");
            if (player != null && this.currPlaylist.getTimeline() != null) {
                if (player.getRate() != 1.0f) {
                    Debugging.dmsg("showtimeline() - RateChangeEvent");
                    this.showTimeline();
                } else {
                    this.hideTimeline();
                }
            }
        } else if (arg1 instanceof StopAtTimeEvent) {
            if (player != null) {
                // empty if block
            }
        } else if (arg1 instanceof ResourceUnavailableEvent) {
            this.lockoutTimeline = true;
        } else if (arg1 instanceof StopEvent) {
            if (this.unblockTimer != null) {
                this.unblockTimer.cancel();
                this.unblockTimer = null;
            }
            this.unblock();
        }
    }

    public void toggleTimeline(String state) {
        if (state.equalsIgnoreCase("on")) {
            this.showTimeline();
        } else if (this.timelineTimer == null) {
            try {
                if (this.timelineTimer != null) {
                    this.timelineTimer.cancel();
                }
                this.timelineTimer = new Timer();
                this.timelineTimer.schedule((TimerTask)new HideTimelineTask(), 100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTimeline() {
        try {
            this.timelineTimer.cancel();
            this.timelineTimer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.timelineEnabled) {
            Object object = this.menuXlet.getLayoutManager().keyPressMonitor;
            synchronized (object) {
                if (this.currPlaylist.getTimeline() != null && !this.currPlaylist.getTimeline().equals("")) {
                    if (player.getRate() == 0.0f) {
                        this.timelineOverrideChapter = BDProperties.getChapterNumber();
                        this.timelineOverrideTime = this.getPlayer().getMediaNanoseconds();
                        this.menuXlet.getActionManager().handleActions("showMenu," + this.currPlaylist.getTimeline() + "_SS");
                    } else {
                        this.menuXlet.getActionManager().handleActions("hideMenu;overrideTimeline");
                    }
                    this.menuXlet.getLayoutManager().getMenu(this.currPlaylist.getTimeline()).show();
                    this.timelineShowing = true;
                }
            }
        }
    }

    private void hideTimeline() {
        if (this.timelineTimer == null) {
            if (this.timelineShowing && this.menuXlet.getLayoutManager().isShowingMenus()) {
                this.menuXlet.getActionManager().handleActions("hideMenu;overrideTimeline");
            }
            try {
                if (this.timelineTimer != null) {
                    this.timelineTimer.cancel();
                }
                this.timelineTimer = new Timer();
                this.timelineTimer.schedule((TimerTask)new HideTimelineTask(), 5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableTimeline() {
        Object object = this.timelineLock;
        synchronized (object) {
            Debugging.dmsg("         enableTimeline()");
            if (this.currPlaylist.getTimeline() == null || this.currPlaylist.getTimeline().equals("") || this.timelineEnabled || this.lockoutTimeline) {
                return;
            }
            this.timelineEnabled = true;
            if (this.timelineTimer != null) {
                try {
                    this.timelineTimer.cancel();
                    this.timelineTimer = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timelineShowing = false;
            }
            if (this.timelineShowing || player.getRate() == 0.0f) {
                Object object2 = this.menuXlet.getLayoutManager().keyPressMonitor;
                synchronized (object2) {
                    if (player.getRate() == 0.0f) {
                        this.timelineOverrideChapter = BDProperties.getChapterNumber();
                        this.timelineOverrideTime = this.getPlayer().getMediaNanoseconds();
                        this.menuXlet.getActionManager().handleActions("showMenu," + this.currPlaylist.getTimeline() + "_SS");
                    }
                    this.menuXlet.getLayoutManager().getMenu(this.currPlaylist.getTimeline()).show();
                    this.timelineShowing = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTimeline() {
        Object object = this.timelineLock;
        synchronized (object) {
            Debugging.dmsg("           disableTimeline()");
            if (this.currPlaylist.getTimeline() == null || this.currPlaylist.getTimeline().equals("")) {
                return;
            }
            if (!this.timelineEnabled) {
                return;
            }
            this.timelineEnabled = false;
            if (this.timelineShowing) {
                if (this.timelineTimer != null) {
                    try {
                        this.timelineTimer.cancel();
                        this.timelineTimer = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.timelineShowing = false;
                }
                Object object2 = this.menuXlet.getLayoutManager().keyPressMonitor;
                synchronized (object2) {
                    this.menuXlet.getLayoutManager().getMenu(this.currPlaylist.getTimeline()).hide();
                    if (this.menuXlet.getLayoutManager().isShowingMenus()) {
                        this.menuXlet.getActionManager().handleActions("hideMenu;overrideTimeline");
                    }
                    this.timelineShowing = false;
                }
            }
        }
    }

    public boolean getTimelineShowing() {
        return this.timelineShowing;
    }

    public void markReached(PlaybackMarkEvent event) {
        Debugging.dmsg("markReached(PlaybackMarkEvent event): " + event.getMark());
        Debugging.dmsg("markReached(currPlaylist): " + this.currPlaylist.getID());
    }

    public void playItemReached(PlaybackPlayItemEvent event) {
        Debugging.dmsg("VideoPlayer.playItemReached(): " + event.getPlayItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block(boolean autoCancel) {
        Debugging.dmsg("           block(): " + autoCancel);
        if (this.unblockTimer != null) {
            this.unblockTimer.cancel();
            this.unblockTimer = null;
        }
        if (autoCancel) {
            try {
                this.alreadyUnblocked = false;
                this.unblockTimer = new Timer();
                this.unblockTimer.schedule((TimerTask)new UnblockTask(), 1000L);
            }
            catch (Exception e) {
                Debugging.dmsg("could not schedule Timer: " + e);
            }
        }
        VideoPlayer videoPlayer = this;
        synchronized (videoPlayer) {
            if (!this.ready) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.ready = false;
    }

    public void block() {
        Debugging.dmsg("              block()");
        this.block(false);
    }

    public synchronized void unblock() {
        Debugging.dmsg("              unblock()");
        this.alreadyUnblocked = true;
        this.ready = true;
        this.notifyAll();
    }

    public void readResumeInfo() {
        this.resumeValid = PersistentSettings.getBoolean(1);
        this.resumePlaylist = this.getPlaylist(PersistentSettings.getString(3));
        this.resumePlayMark = PersistentSettings.getInt(4);
        this.resumeTime = PersistentSettings.getLong(2);
    }

    public void updateResumeInfo() {
        Debugging.dmsg("Update Resume RETURN This is not used anymore");
    }

    private PlayList GetBDPlayListFromZMFPlaylist(Playlist pl) {
        if (BDplayLists == null) {
            try {
                int titleIdx = BDProperties.getTitleNumber();
                SIManager manager = SIManager.createInstance();
                BDLocator loc = new BDLocator(null, titleIdx, -1);
                Title title = (Title)manager.getService((Locator)loc);
                BDplayLists = title != null ? title.getPlayLists() : new PlayList[0];
            }
            catch (Throwable e) {
                Debugging.dmsg("ESS - Failed to locate title information");
                BDplayLists = new PlayList[0];
            }
        }
        for (int idx = 0; idx < BDplayLists.length; ++idx) {
            if (pl.getPlaylistID() != BDplayLists[idx].getId()) continue;
            return BDplayLists[idx];
        }
        return null;
    }

    private void addPlayitems() {
        for (int playlistIdx = 0; playlistIdx < this.playlists.size(); ++playlistIdx) {
            Playlist playlist = (Playlist)this.playlists.get(playlistIdx);
            if (playlist == null) continue;
            playlist.addPlayitems(null);
        }
    }

    private void updatePersistentSettingsPlayOnceStatus() {
        String playedPlaylists = "";
        boolean first = true;
        for (int i = 0; i < this.playlists.size(); ++i) {
            if (!((Playlist)this.playlists.get(i)).getPlayOnceBlockPlayed()) continue;
            if (!first) {
                playedPlaylists = playedPlaylists + ",";
            }
            playedPlaylists = playedPlaylists + i;
            first = false;
        }
        PersistentSettings.setString(12, playedPlaylists);
    }

    public boolean getLockoutPopup() {
        return this.lockoutPopup;
    }

    public boolean getLockoutTimeline() {
        return this.lockoutTimeline;
    }

    public void setLockoutPopup(boolean flag) {
        this.lockoutPopup = flag;
    }

    public void setLockoutTimeline(boolean flag) {
        this.lockoutTimeline = flag;
    }

    public void resizeVideo(int x, int y, int w, int h) {
        if (x == 0 && y == 0 && w == 1920 && h == 1080) {
            if (this.resized) {
                this.resized = false;
                AWTVideoSizeUtility.setVideoDimension(player, x, y, w, h);
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {}
            }
        } else {
            this.resized = true;
            AWTVideoSizeUtility.setVideoDimension(player, x, y, w, h);
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public long[] getTimelineData() {
        long[] rval = new long[]{0L, 0L, 0L};
        if (this.currPlaylist.getTimeline() != null) {
            rval[0] = this.getPlayer().getMediaNanoseconds();
            rval[1] = BDProperties.getChapterNumber();
            float rate = this.getPlayer().getRate();
            if (rate == 0.0f) {
                if (this.timelineOverrideTime >= 0L) {
                    rval[0] = this.timelineOverrideTime;
                    rval[1] = this.timelineOverrideChapter;
                }
                rval[2] = 0L;
            } else {
                rval[2] = rate > 1.0f ? 2L : (rate < 0.0f ? 3L : 1L);
            }
        } else {
            String state = DiscTrackerManager.getTrackerState();
            if (this.timelineOverrideTime >= 0L) {
                rval[0] = this.timelineOverrideTime;
                rval[1] = this.timelineOverrideChapter;
                rval[2] = 0L;
            } else if (state.equals("playback") || state.equals("resumeable")) {
                rval[0] = DiscTrackerManager.getTrackerTime();
                rval[1] = (long)DiscTrackerManager.getTrackerPlayMark() + 1L;
                rval[2] = 0L;
            } else if (state.equals("initial") && this.disctracker_playlists.isEmpty()) {
                Debugging.dmsg("This is a Simplified Disc and will always show the resume thumbnail in the scene select.");
                rval[0] = DiscTrackerManager.getTrackerTime();
                rval[1] = (long)DiscTrackerManager.getTrackerPlayMark() + 1L;
                rval[2] = 0L;
            } else {
                rval[2] = -1L;
            }
        }
        return rval;
    }

    public void overrideTimelineData(long time, int chapter) {
        this.timelineOverrideTime = time;
        this.timelineOverrideChapter = chapter;
    }

    public boolean timelineTimerActive() {
        return this.timelineTimer != null;
    }

    public void destroyPlayer() {
        if (player != null) {
            this.stop();
            player.close();
            player.deallocate();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UnblockTask
    extends TimerTask {
        UnblockTask() {
        }

        public void run() {
            if (!VideoPlayer.this.alreadyUnblocked) {
                VideoPlayer.this.unblock();
            }
        }
    }

    class HideTimelineTask
    extends TimerTask {
        HideTimelineTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VideoPlayer.this.timelineShowing = false;
            if (VideoPlayer.this.timelineEnabled) {
                Object object = ((VideoPlayer)VideoPlayer.this).menuXlet.getLayoutManager().keyPressMonitor;
                synchronized (object) {
                    if (VideoPlayer.this.currPlaylist.getTimeline() != null && !VideoPlayer.this.currPlaylist.getTimeline().equals("")) {
                        VideoPlayer.this.menuXlet.getLayoutManager().getMenu(VideoPlayer.this.currPlaylist.getTimeline()).hide();
                    }
                }
            }
        }
    }

    class GenerateMediaPresentedEventTask
    extends TimerTask {
        GenerateMediaPresentedEventTask() {
        }

        public void run() {
            if (VideoPlayer.this.startEventOccurred) {
                VideoPlayer.this.startEventOccurred = false;
                VideoPlayer.this.mediaPresentedEventOccurred = false;
                VideoPlayer.this.handleStartEvent();
            }
        }
    }

    class EventRunnable
    implements Runnable {
        PlayerEvent evt;
        PlayerListener listener;

        EventRunnable(PlayerEvent evt, PlayerListener listener) {
            this.evt = evt;
            this.listener = listener;
        }

        public void run() {
            this.listener.playerEventReceived(this.evt);
        }
    }
}

