/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.media;

import com.zoo.media.Playitem;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.XMLParser;
import javax.tv.service.navigation.ServiceComponent;
import org.bluray.net.BDLocator;
import org.bluray.ti.CodingType;
import org.bluray.ti.PlayItem;
import org.bluray.ti.PlayList;
import org.bluray.ti.TitleComponent;
import org.davic.net.InvalidLocatorException;

public class Playlist {
    private int playlistID = -1;
    private String loc = null;
    private String id = null;
    private boolean loop = false;
    private boolean hasCommentary = false;
    private boolean resumable = false;
    private boolean resumableDiscTracker = false;
    private boolean languageManaged = false;
    private boolean playOnceBlockStart = false;
    private boolean playOnceBlockEnd = false;
    private boolean playOnceOnEntry = false;
    private boolean playOnceBlockPlayed = false;
    private boolean isSD = false;
    private boolean advancedAudioAndSubs = false;
    private boolean DVM = false;
    private boolean logo = false;
    private boolean LTDC = false;
    private boolean trailer = false;
    private boolean topMenu = false;
    private static Playlist DVMPlaylist = null;
    private static Playlist logoPlaylist = null;
    private static Playlist LTDCPlaylist = null;
    private static Playlist trailerPlaylist = null;
    private static Playlist topMenuPlaylist = null;
    private Playitem[] playitems = null;
    private String resumeToLastPlaylist = null;
    private String onStart;
    private String onEnd;
    private String onEndOverrideNextOnStart;
    private String onStartOverrideNextOnStart;
    private static String onStartOverride = null;
    private String onPopUpOn;
    private String onPopUpOff;
    private String nextPlaylist;
    private String timeline;
    private String onMenu;
    private long timeOutDuration = 0L;
    private int nextPlayMark;
    private int audioStream = 1;
    private int subtitleStream = 1;
    private String audioStreamOffset = null;
    private String subtitleStreamOffset = null;
    private String subtitleStreamOffsetForAudio = null;
    private String commentarySubtitleStreamOffset = null;
    private String commentarySubtitleStreamOffsetForAudio = null;
    private boolean subtitleStreamEnable = false;
    private static final String TRUE = "true";
    private int numberOfEnglishAudioStreams = 1;
    private boolean multiAngle = false;
    private int numberOfPlayItems;
    private int numberOfAudioStreams;
    private int numberOfSubtitleStreams;
    public int RNIBStreamID;
    private int episodeNumber = 0;
    private boolean lastEpisode = false;

    public Playlist() {
    }

    public Playlist(XMLParser n) {
        String[] subtitleToken;
        this.setID(n.Attribute.find("id"));
        this.setPlaylistID(Integer.parseInt(n.Attribute.find("playlistID")));
        this.setLoop(TRUE.equalsIgnoreCase(n.Attribute.find("loop")));
        this.setLastEpisode(TRUE.equalsIgnoreCase(n.Attribute.find("lastEpisode")));
        this.setResumable(TRUE.equalsIgnoreCase(n.Attribute.find("resumable")));
        this.setResumableDiscTracker(TRUE.equalsIgnoreCase(n.Attribute.find("resumableDiscTracker")));
        this.setLanguageManaged(TRUE.equalsIgnoreCase(n.Attribute.find("languageManaged")));
        this.setDVM(TRUE.equalsIgnoreCase(n.Attribute.find("DVM")));
        this.setTrailer(TRUE.equalsIgnoreCase(n.Attribute.find("trailer")));
        this.setTopMenu(TRUE.equalsIgnoreCase(n.Attribute.find("topMenu")));
        this.setPlayOnceStart(TRUE.equalsIgnoreCase(n.Attribute.find("playOnceStart")));
        this.setPlayOnceEnd(TRUE.equalsIgnoreCase(n.Attribute.find("playOnceEnd")));
        this.setPlayOnceOnEntry(TRUE.equalsIgnoreCase(n.Attribute.find("playOnceOnEntry")));
        this.setIsSD(TRUE.equalsIgnoreCase(n.Attribute.find("isSD")));
        this.setIsMultiAngle(TRUE.equalsIgnoreCase(n.Attribute.find("isMultiAngle")));
        this.setAdvancedAudioAndSubs(TRUE.equalsIgnoreCase(n.Attribute.find("advancedAudioAndSubs")));
        this.setOnStart(n.Attribute.find("onStart"));
        this.setOnEnd(n.Attribute.find("onEnd"));
        this.setOnEndOverrideNextOnStart(n.Attribute.find("onEndOverrideNextOnStart"));
        this.setOnStartOverrideNextOnStart(n.Attribute.find("onStartOverrideNextOnStart"));
        this.setOnPopUpOn(n.Attribute.find("onPopUpOn"));
        this.setOnPopUpOff(n.Attribute.find("onPopUpOff"));
        this.setTimeline(n.Attribute.find("timeline"));
        this.setOnMenu(n.Attribute.find("onMenu"));
        this.setTimeOutDuration(n.Attribute.find("timeOutDuration"));
        this.setAudioStreamOffset(n.Attribute.find("audioStreamOffset"));
        this.setSubtitleStreamOffset(n.Attribute.find("subtitleStreamOffset"));
        this.setSubtitleStreamOffsetForAudio(n.Attribute.find("subtitleStreamOffsetForAudio"));
        this.setCommentarySubtitleStreamOffset(n.Attribute.find("commentarySubtitleStreamOffset"));
        this.setCommentarySubtitleStreamOffsetForAudio(n.Attribute.find("commentarySubtitleStreamOffsetForAudio"));
        this.numberOfPlayItems = n.Attribute.find("numPlayItems") != null ? Integer.parseInt(n.Attribute.find("numPlayItems")) : -1;
        this.numberOfAudioStreams = n.Attribute.find("numAudioStreams") != null ? Integer.parseInt(n.Attribute.find("numAudioStreams")) : -1;
        this.numberOfSubtitleStreams = n.Attribute.find("numSubtitleStreams") != null ? Integer.parseInt(n.Attribute.find("numSubtitleStreams")) : -1;
        this.RNIBStreamID = n.Attribute.find("RNIBStreamID") != null ? Integer.parseInt(n.Attribute.find("RNIBStreamID")) : -1;
        int audioIdx = 1;
        String audio = n.Attribute.find("audio");
        if (audio != null) {
            audioIdx = Integer.parseInt(audio);
        }
        this.setDefaultAudio(audioIdx);
        int subtitleIdx = 1;
        boolean subtitleOn = false;
        String subtitle = n.Attribute.find("subtitle");
        if (subtitle != null && (subtitleToken = FileUtils.tokenizeString(subtitle, ",")).length == 2) {
            subtitleIdx = Integer.parseInt(subtitleToken[0]);
            subtitleOn = "on".equalsIgnoreCase(subtitleToken[1]);
        }
        this.setDefaultSubtitle(subtitleIdx, subtitleOn);
        this.nextPlaylist = this.scanNextPlaylist();
        this.nextPlayMark = this.scanNextPlayMark();
        int engAudioIdx = 1;
        String engAudio = n.Attribute.find("numberOfEngAudio");
        if (engAudio != null) {
            engAudioIdx = Integer.parseInt(engAudio);
        }
        this.setNumberEngAudio(engAudioIdx);
        int episodeNumberInt = 0;
        String episodeNumberStr = n.Attribute.find("episodeNumber");
        if (episodeNumberStr != null) {
            episodeNumberInt = Integer.parseInt(episodeNumberStr);
        }
        this.setEpisodeNumber(episodeNumberInt);
    }

    public void setLocator(String l) {
        this.loc = l;
    }

    public void setPlaylistID(int i) {
        this.playlistID = i;
        try {
            BDLocator bdlocator = new BDLocator(null, -1, i);
            this.loc = bdlocator.toString();
        }
        catch (InvalidLocatorException e) {
            this.loc = "bd://PLAYLIST:00000";
        }
    }

    private void setEpisodeNumber(int i) {
        this.episodeNumber = i;
    }

    public void setID(String s) {
        this.id = s;
    }

    private void setResumable(boolean resumeFlag) {
        this.resumable = resumeFlag;
    }

    private void setResumableDiscTracker(boolean resumeFlag) {
        if (resumeFlag) {
            this.resumable = resumeFlag;
        }
        this.resumableDiscTracker = resumeFlag;
    }

    private void setIsMultiAngle(boolean flag) {
        this.multiAngle = flag;
    }

    private void setLanguageManaged(boolean managedFlag) {
        this.languageManaged = managedFlag;
    }

    private void setDefaultAudio(int idx) {
        this.audioStream = idx;
    }

    private void setNumberEngAudio(int idx) {
        this.numberOfEnglishAudioStreams = idx;
    }

    public int getNumberEngAudio() {
        return this.numberOfEnglishAudioStreams;
    }

    public int getDefaultAudio() {
        return this.audioStream;
    }

    private void setDefaultSubtitle(int idx, boolean enable) {
        this.subtitleStream = idx;
        this.subtitleStreamEnable = enable;
    }

    public int getDefaultSubtitle() {
        return this.subtitleStream;
    }

    public boolean getDefaultSubtitleEnable() {
        return this.subtitleStreamEnable;
    }

    public boolean isAdvancedAudioAndSubs() {
        return this.advancedAudioAndSubs;
    }

    public void setAdvancedAudioAndSubs(boolean flag) {
        this.advancedAudioAndSubs = flag;
    }

    public boolean isLastEpisode() {
        return this.lastEpisode;
    }

    public void setLastEpisode(boolean flag) {
        this.lastEpisode = flag;
    }

    public String getAudioStreamOffset() {
        return this.audioStreamOffset;
    }

    private void setAudioStreamOffset(String offset) {
        if (offset != null && offset.equals("")) {
            offset = null;
        }
        this.audioStreamOffset = offset;
    }

    public String getSubtitleStreamOffset() {
        return this.subtitleStreamOffset;
    }

    public String getSubtitleStreamOffsetForAudio() {
        return this.subtitleStreamOffsetForAudio;
    }

    private void setSubtitleStreamOffset(String offset) {
        if (offset != null && offset.equals("")) {
            offset = null;
        }
        this.subtitleStreamOffset = offset;
    }

    private void setSubtitleStreamOffsetForAudio(String offset) {
        if (offset != null && offset.equals("")) {
            offset = null;
        }
        this.subtitleStreamOffsetForAudio = offset;
    }

    public String getCommentarySubtitleStreamOffset(int Stream2) {
        block4: {
            try {
                String[] cOffsets = FileUtils.tokenizeString(this.commentarySubtitleStreamOffset, "?");
                if (cOffsets.length > 0) {
                    for (int ii = 0; ii < cOffsets.length; ++ii) {
                        if (!cOffsets[ii].startsWith(String.valueOf(Stream2))) continue;
                        Debugging.dmsg("Stream number for commentary is --" + cOffsets[ii]);
                        String[] cOffset = FileUtils.tokenizeString(cOffsets[ii], ":");
                        Debugging.dmsg("Stream offset for commentary is --" + cOffset[1]);
                        return cOffset[1];
                    }
                    break block4;
                }
                Debugging.dmsg("Single offset for commentary returned 1 " + this.commentarySubtitleStreamOffset);
                return this.commentarySubtitleStreamOffset;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Debugging.dmsg("Single offset for commentary returned " + this.commentarySubtitleStreamOffset);
        return this.commentarySubtitleStreamOffset;
    }

    public String getCommentarySubtitleStreamOffsetForAudio(int Stream2) {
        block4: {
            try {
                String[] cOffsets = FileUtils.tokenizeString(this.commentarySubtitleStreamOffsetForAudio, "?");
                if (cOffsets.length > 1) {
                    for (int ii = 0; ii < cOffsets.length; ++ii) {
                        if (!cOffsets[ii].startsWith(String.valueOf(Stream2))) continue;
                        Debugging.dmsg("Stream number for commentary is --" + cOffsets[ii]);
                        String[] cOffset = FileUtils.tokenizeString(cOffsets[ii], ":");
                        Debugging.dmsg("Stream offset for commentary subtitle audio is --" + cOffset[1]);
                        return cOffset[1];
                    }
                    break block4;
                }
                Debugging.dmsg("Single offset for commentary subtitle audio returned");
                return this.commentarySubtitleStreamOffsetForAudio;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Debugging.dmsg("Single offset for commentary subtitle audio returned");
        return this.commentarySubtitleStreamOffsetForAudio;
    }

    private void setCommentarySubtitleStreamOffset(String offset) {
        if (offset != null && offset.equals("")) {
            offset = null;
        }
        this.commentarySubtitleStreamOffset = offset;
        if (offset != null) {
            this.hasCommentary = true;
        }
    }

    private void setCommentarySubtitleStreamOffsetForAudio(String offset) {
        if (offset != null && offset.equals("")) {
            offset = null;
        }
        this.commentarySubtitleStreamOffsetForAudio = offset;
        if (offset != null) {
            this.hasCommentary = true;
        }
    }

    private void setOnStart(String commands) {
        if (commands != null && commands.equals("")) {
            commands = null;
        }
        this.onStart = commands;
    }

    private void setOnEnd(String commands) {
        if (commands != null && commands.equals("")) {
            commands = null;
        }
        this.onEnd = commands;
    }

    private void setOnEndOverrideNextOnStart(String commands) {
        if (commands != null && commands.equals("")) {
            commands = null;
        }
        this.onEndOverrideNextOnStart = commands;
    }

    private void setOnStartOverrideNextOnStart(String commands) {
        if (commands != null && commands.equals("")) {
            commands = null;
        }
        this.onStartOverrideNextOnStart = commands;
    }

    private void setOnPopUpOn(String commands) {
        this.onPopUpOn = commands;
    }

    private void setOnPopUpOff(String commands) {
        this.onPopUpOff = commands;
    }

    private void setTimeline(String menu) {
        this.timeline = menu;
    }

    private void setOnMenu(String commands) {
        if (commands != null && commands.equals("")) {
            commands = null;
        }
        this.onMenu = commands;
    }

    private void setTimeOutDuration(String commands) {
        if (commands != null && commands.equals("")) {
            commands = null;
        }
        if (commands != null) {
            this.timeOutDuration = Long.parseLong(commands);
        }
    }

    public String getOnStart() {
        String ret = this.onStart;
        if (onStartOverride != null) {
            ret = onStartOverride;
        }
        onStartOverride = null;
        return ret;
    }

    public static void overrideOnStart(String override) {
        onStartOverride = override;
    }

    public String getOnEnd() {
        return this.onEnd;
    }

    public String getOnPopUpOn() {
        return this.onPopUpOn;
    }

    public String getOnPopUpOff() {
        return this.onPopUpOff;
    }

    public String getTimeline() {
        return this.timeline;
    }

    public String getOnMenu() {
        return this.onMenu;
    }

    public long getTimeOutDuration() {
        return this.timeOutDuration;
    }

    public String getOnEndOverrideNextOnStart() {
        return this.onEndOverrideNextOnStart;
    }

    public String getOnStartOverrideNextOnStart() {
        return this.onStartOverrideNextOnStart;
    }

    public String getresumeToLastPlaylist() {
        return this.resumeToLastPlaylist;
    }

    public void setresumeToLastPlaylist(String pid) {
        this.resumeToLastPlaylist = pid;
    }

    private void setDVM(boolean DVM) {
        this.DVM = DVM;
        if (DVM) {
            DVMPlaylist = this;
        }
    }

    private void setTrailer(boolean trailer) {
        this.trailer = trailer;
        if (trailer) {
            trailerPlaylist = this;
        }
    }

    private void setTopMenu(boolean topMenu) {
        this.topMenu = topMenu;
        if (topMenu) {
            topMenuPlaylist = this;
        }
    }

    private void setPlayOnceStart(boolean onceStart) {
        this.playOnceBlockStart = onceStart;
    }

    private void setPlayOnceEnd(boolean onceEnd) {
        this.playOnceBlockEnd = onceEnd;
    }

    private void setPlayOnceOnEntry(boolean onceEntered) {
        this.playOnceOnEntry = onceEntered;
    }

    private void setIsSD(boolean SD) {
        this.isSD = SD;
    }

    private String scanNextPlaylist() {
        if (this.onEnd == null) {
            return null;
        }
        String[] expressionTokens = FileUtils.tokenizeString(this.onEnd, ";");
        for (int i = 0; i < expressionTokens.length; ++i) {
            String action = expressionTokens[i];
            String[] tokens = FileUtils.tokenizeString(action, ",");
            if (tokens.length != 3 || !tokens[0].equals("play") && !tokens[0].equals("resume")) continue;
            return tokens[1];
        }
        return null;
    }

    private int scanNextPlayMark() {
        if (this.onEnd == null) {
            return -1;
        }
        String[] expressionTokens = FileUtils.tokenizeString(this.onEnd, ";");
        for (int i = 0; i < expressionTokens.length; ++i) {
            String action = expressionTokens[i];
            String[] tokens = FileUtils.tokenizeString(action, ",");
            if (tokens.length != 3 || !tokens[0].equals("play") && !tokens[0].equals("resume")) continue;
            return Integer.parseInt(tokens[2]);
        }
        return -1;
    }

    public String getNextPlaylist() {
        return this.nextPlaylist;
    }

    public int getNextPlayMark() {
        return this.nextPlayMark;
    }

    public boolean getPlayOnceStart() {
        return this.playOnceBlockStart;
    }

    public boolean getPlayOnceEnd() {
        return this.playOnceBlockEnd;
    }

    public boolean getPlayOnceOnEntry() {
        return this.playOnceOnEntry;
    }

    public boolean getIsSD() {
        return this.isSD;
    }

    public int getPlaylistID() {
        return this.playlistID;
    }

    public int getEpisodeNumber() {
        return this.episodeNumber;
    }

    public String getLocator() {
        return this.loc;
    }

    public String getID() {
        return this.id;
    }

    public boolean isResumable() {
        return this.resumable;
    }

    public boolean isResumableDiscTracker() {
        return this.resumableDiscTracker;
    }

    public boolean isMultiAngle() {
        return this.multiAngle;
    }

    public boolean isLanguageManaged() {
        return this.languageManaged;
    }

    public boolean isDVM() {
        return this.DVM;
    }

    public boolean hasCommentary() {
        return this.hasCommentary;
    }

    public static Playlist getDVMPlaylist() {
        return DVMPlaylist;
    }

    public static Playlist getTrailerPlaylist() {
        return trailerPlaylist;
    }

    public static Playlist getTopMenuPlaylist() {
        return topMenuPlaylist;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean doesLoop() {
        return this.loop;
    }

    public void setPlayOnceBlockPlayed(boolean state) {
        this.playOnceBlockPlayed = state;
    }

    public boolean getPlayOnceBlockPlayed() {
        return this.playOnceBlockPlayed;
    }

    public void addPlayitems(PlayList BDPlaylist) {
        if (this.numberOfPlayItems != -1 && this.numberOfAudioStreams != -1 && this.numberOfSubtitleStreams != -1) {
            this.playitems = new Playitem[this.numberOfPlayItems];
            for (int playitemIdx = 0; playitemIdx < this.numberOfPlayItems; ++playitemIdx) {
                this.playitems[playitemIdx] = new Playitem();
                this.playitems[playitemIdx].setAudioStreams(this.numberOfAudioStreams);
                this.playitems[playitemIdx].setSubtitleStreams(this.numberOfSubtitleStreams);
            }
            return;
        }
        PlayItem[] BDplayItems = BDPlaylist.getPlayItems();
        this.playitems = new Playitem[BDplayItems.length];
        for (int playitemIdx = 0; playitemIdx < this.playitems.length; ++playitemIdx) {
            PlayItem playItem = BDplayItems[playitemIdx];
            ServiceComponent[] components = playItem.getComponents();
            int audioStreams = 0;
            int subtitleStreams = 0;
            for (int componentIdx = 0; componentIdx < components.length; ++componentIdx) {
                TitleComponent testComponent = (TitleComponent)components[componentIdx];
                CodingType type = testComponent.getCodingType();
                if (type == CodingType.DOLBY_AC3_AUDIO) {
                    ++audioStreams;
                }
                if (type == CodingType.DOLBY_DIGITAL_PLUS_AUDIO) {
                    ++audioStreams;
                }
                if (type == CodingType.DOLBY_LOSSLESS_AUDIO) {
                    ++audioStreams;
                }
                if (type == CodingType.DTS_AUDIO) {
                    ++audioStreams;
                }
                if (type == CodingType.DTS_HD_AUDIO_EXCEPT_XLL) {
                    ++audioStreams;
                }
                if (type == CodingType.DTS_HD_AUDIO_LBR) {
                    ++audioStreams;
                }
                if (type == CodingType.DTS_HD_AUDIO_XLL) {
                    ++audioStreams;
                }
                if (type == CodingType.LPCM_AUDIO) {
                    ++audioStreams;
                }
                if (type == CodingType.DTS_HD_AUDIO) {
                    ++audioStreams;
                }
                if (type != CodingType.PRESENTATION_GRAPHICS) continue;
                ++subtitleStreams;
            }
            this.playitems[playitemIdx] = new Playitem();
            this.playitems[playitemIdx].setAudioStreams(audioStreams);
            this.playitems[playitemIdx].setSubtitleStreams(subtitleStreams);
        }
    }

    public int getPlayitemCount() {
        return this.playitems.length;
    }

    public Playitem getPlayitem(int idx) {
        return this.playitems[idx];
    }
}

