/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.event;

import com.zoo.event.TitleChangeEvent;
import com.zoo.event.TitleChangeListener;
import com.zoo.event.TitleStartedEvent;
import com.zoo.event.TitleStoppedEvent;
import com.zoo.util.Debugging;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.xlet.XletContext;
import org.bluray.net.BDLocator;
import org.bluray.system.RegisterAccess;
import org.bluray.ti.Title;
import org.bluray.ti.selection.TitleContext;

public class TitleChangeManager {
    protected static ArrayList listeners = new ArrayList();
    protected static Timer titleCheckerTimer = null;
    protected static TitleCheckerTask titleCheckerTask;
    protected static boolean knownTitleJump;
    protected static boolean tbxActive;
    protected static boolean titleReloading;
    protected static int titleNumber;
    protected static final Object titleChangeLock;

    public static TitleChangeManager getInstance() {
        if (titleCheckerTimer == null) {
            RegisterAccess.getInstance().setGPR(1997, 0);
            RegisterAccess.getInstance().setGPR(1998, 0);
            boolean bl = titleReloading = RegisterAccess.getInstance().getGPR(2000) == 1;
            if (titleReloading) {
                titleNumber = RegisterAccess.getInstance().getGPR(1999);
            } else {
                RegisterAccess.getInstance().setGPR(1999, 65535);
                titleNumber = 65535;
            }
            titleCheckerTimer = new Timer();
            titleCheckerTask = new TitleCheckerTask();
            titleCheckerTimer.schedule((TimerTask)titleCheckerTask, 1000L, 100L);
        }
        return new TitleChangeManager();
    }

    public void addTitleChangeListener(TitleChangeListener listener) {
        listeners.add(listener);
    }

    public void removeTitleChangeListener(TitleChangeListener listener) {
        listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireTitleChangeEvent(TitleChangeEvent evt) {
        Debugging.dmsg("fireTitleChangeEvent");
        if (!knownTitleJump) {
            for (int i = 0; i < listeners.size(); ++i) {
                Thread thread = new Thread(new EventRunnable(evt, (TitleChangeListener)listeners.get(i)));
                thread.start();
            }
        } else {
            Debugging.dmsg("known title jump ignored");
        }
        Object object = titleChangeLock;
        synchronized (object) {
            titleChangeLock.notifyAll();
        }
    }

    public static void changeTitleAsynchronous(XletContext xtc, int t) {
        ServiceContextFactory factory = ServiceContextFactory.getInstance();
        try {
            TitleContext tc = (TitleContext)factory.getServiceContext(xtc);
            SIManager manager = SIManager.createInstance();
            BDLocator loc = new BDLocator(null, t, -1);
            Title title = (Title)manager.getService((Locator)loc);
            if (title != null) {
                tc.start(title, true);
            }
        }
        finally {
            return;
        }
        {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeTitle(XletContext xtc, int title) {
        int remainingRetries;
        if (title == TitleChangeManager.getTitleNumber()) {
            return;
        }
        knownTitleJump = true;
        TitleChangeManager.changeTitleAsynchronous(xtc, title);
        for (remainingRetries = 15; TitleChangeManager.getTitleNumber() != title && remainingRetries > 0; --remainingRetries) {
            Object object = titleChangeLock;
            synchronized (object) {
                try {
                    titleChangeLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                continue;
            }
        }
        if (remainingRetries == 0) {
            Debugging.dmsg("changeTitle failed or interrupted, retrying...");
            TitleChangeManager.changeTitle(xtc, title);
        }
        knownTitleJump = false;
    }

    public static int getTitleNumber() {
        return titleNumber;
    }

    public static boolean getTitleReloading() {
        return titleReloading;
    }

    public static void setTitleReloading() {
        RegisterAccess.getInstance().setGPR(2000, 1);
    }

    static {
        knownTitleJump = false;
        tbxActive = false;
        titleChangeLock = new Object();
    }

    protected static class EventRunnable
    implements Runnable {
        TitleChangeEvent evt;
        TitleChangeListener listener;

        EventRunnable(TitleChangeEvent evt, TitleChangeListener listener) {
            this.evt = evt;
            this.listener = listener;
        }

        public void run() {
            this.listener.titleChangeEventReceived(this.evt);
        }
    }

    protected static class TitleCheckerTask
    extends TimerTask {
        protected TitleCheckerTask() {
        }

        public void run() {
            TitleChangeEvent evt;
            boolean newTbxActive = RegisterAccess.getInstance().getGPR(1998) == 1;
            int newTitleNumber = RegisterAccess.getInstance().getGPR(1999);
            if (!newTbxActive && tbxActive) {
                RegisterAccess.getInstance().setGPR(1997, 0);
                evt = new TitleStoppedEvent(new Object());
                evt.setTitle(titleNumber);
                TitleChangeManager.fireTitleChangeEvent(evt);
            }
            tbxActive = newTbxActive;
            if (titleNumber != newTitleNumber) {
                titleNumber = newTitleNumber;
                evt = new TitleStartedEvent(new Object());
                evt.setTitle(titleNumber);
                TitleChangeManager.fireTitleChangeEvent(evt);
            }
        }
    }
}

