/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.animation;

import com.zoo.animation.Animation;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Icon;

public class SlideAnimation
extends Animation {
    protected boolean finished = false;
    protected int startX;
    protected int endX;
    protected int startY;
    protected int endY;
    protected float currentX;
    protected float currentY;
    protected long animationTime;
    protected Icon target;

    public SlideAnimation(Icon target, int startX, int startY, int endX, int endY, long animationTime) {
        this.target = target;
        this.startX = startX;
        this.endX = endX;
        this.startY = startY;
        this.endY = endY;
        this.animationTime = animationTime;
        this.currentX = startX;
        this.currentY = startY;
    }

    public SlideAnimation(Button target, int startX, int startY, int endX, int endY, long animationTime) {
        this.target = target;
        this.startX = startX;
        this.endX = endX;
        this.startY = startY;
        this.endY = endY;
        this.animationTime = animationTime;
        this.currentX = startX;
        this.currentY = startY;
    }

    public void nextFrame(long timeDelta) {
        if (this.finished) {
            return;
        }
        this.currentX += ((float)this.endX - (float)this.startX) * (float)timeDelta / (float)this.animationTime;
        this.currentY += ((float)this.endY - (float)this.startY) * (float)timeDelta / (float)this.animationTime;
        if (this.startX > this.endX && this.currentX <= (float)this.endX || this.startX < this.endX && this.currentX >= (float)this.endX || this.startY > this.endY && this.currentY <= (float)this.endY || this.startY < this.endY && this.currentY >= (float)this.endY) {
            this.target.setPosition(this.endX, this.endY);
            this.finished = true;
        } else {
            this.target.setPosition((int)this.currentX, (int)this.currentY);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

