/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.animation;

import com.zoo.animation.Animation;
import com.zoo.ui.components.Button;
import com.zoo.ui.components.Icon;

public class FadeAnimation
extends Animation {
    protected boolean finished = false;
    protected float startAlpha;
    protected float endAlpha;
    protected float currentAlpha;
    protected long animationTime;
    protected Icon target;

    public FadeAnimation(Icon target, float startAlpha, float endAlpha, long animationTime) {
        this.target = target;
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
        this.animationTime = animationTime;
        this.currentAlpha = startAlpha;
    }

    public FadeAnimation(Button target, float startAlpha, float endAlpha, long animationTime) {
        this.target = target;
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
        this.animationTime = animationTime;
        this.currentAlpha = startAlpha;
    }

    public void nextFrame(long timeDelta) {
        if (this.finished) {
            return;
        }
        this.currentAlpha += (this.endAlpha - this.startAlpha) * (float)timeDelta / (float)this.animationTime;
        if (this.startAlpha > this.endAlpha && this.currentAlpha <= this.endAlpha || this.startAlpha < this.endAlpha && this.currentAlpha >= this.endAlpha) {
            this.target.setAlpha(this.endAlpha);
            this.finished = true;
        } else {
            this.target.setAlpha(this.currentAlpha);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

