/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.animation;

import com.zoo.test.MenuViewer;
import com.zoo.util.Debugging;
import com.zoo.util.SceneUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.havi.ui.HScene;

public class DrawingEngine
extends Component {
    private HScene scene = null;
    private BufferedImage buffer = null;
    private Rectangle dRect = null;
    private Rectangle savedRect = null;
    private static final Color debugBackgroundColor = new Color(0, 0, 255, 128);

    public DrawingEngine() {
        if (Debugging.getPlaybackEnv() == 1) {
            Container simulator = MenuViewer.simulator;
            simulator.setVisible(false);
            this.setSize(simulator.getSize());
            simulator.add(this);
            this.validate();
            simulator.setVisible(true);
            simulator.requestFocus();
        } else {
            this.scene = SceneUtils.createScene();
            this.scene.setVisible(false);
            this.setSize(this.scene.getSize());
            this.scene.add((Component)this);
            this.validate();
            this.scene.setVisible(true);
            this.scene.requestFocus();
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        this.buffer = gc.createCompatibleImage(1920, 1080);
        this.clearBuffer();
        this.paintFullScreen();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public void fillBuffer(int x, int y, int w, int h, Color c) {
        Graphics2D bg = (Graphics2D)this.getBuffer().getGraphics();
        bg.setComposite(AlphaComposite.SrcOver);
        bg.setColor(c);
        bg.fillRect(x, y, w, h);
        bg.dispose();
    }

    public void addToDrawRect(Rectangle r) {
        if (r != null) {
            if (this.dRect == null) {
                this.dRect = r;
            } else {
                this.dRect.add(r);
            }
            int sX = Math.max(0, this.dRect.x);
            int sY = Math.max(0, this.dRect.y);
            int sW = Math.max(0, Math.min(1920 - sX, this.dRect.width));
            int sH = Math.max(0, Math.min(1080 - sY, this.dRect.height));
            this.dRect.setBounds(sX, sY, sW, sH);
        }
    }

    public void clearSavedRect() {
        this.savedRect = null;
    }

    public void paintScreen() {
        if (Debugging.isOn() & Debugging.displayOnPlayer()) {
            this.addToDrawRect(new Rectangle(0, 0, 640, 540));
        }
        try {
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            if (g2 != null && this.getBuffer() != null) {
                if (this.savedRect == null) {
                    this.savedRect = this.dRect;
                } else if (this.dRect != null) {
                    if (this.dRect.contains(this.savedRect)) {
                        this.savedRect = this.dRect;
                    } else {
                        this.savedRect.add(this.dRect);
                    }
                }
                if (this.savedRect != null) {
                    g2.setClip(this.savedRect);
                    g2.setComposite(AlphaComposite.Src);
                    if (Debugging.isOn() & Debugging.displayOnPlayer()) {
                        this.drawDebug();
                        g2.drawImage((Image)this.getBuffer(), 0, 0, null);
                    } else {
                        g2.drawImage(this.getBuffer(), this.savedRect.x, this.savedRect.y, this.savedRect.x + this.savedRect.width, this.savedRect.y + this.savedRect.height, this.savedRect.x, this.savedRect.y, this.savedRect.x + this.savedRect.width, this.savedRect.y + this.savedRect.height, null);
                    }
                    Toolkit.getDefaultToolkit().sync();
                    if (this.dRect != null) {
                        Graphics2D bg = (Graphics2D)this.getBuffer().getGraphics();
                        bg.setClip(this.dRect);
                        bg.setComposite(AlphaComposite.Clear);
                        bg.fillRect(this.dRect.x, this.dRect.y, this.dRect.width, this.dRect.height);
                        Toolkit.getDefaultToolkit().sync();
                        bg.dispose();
                        this.savedRect = this.dRect;
                    }
                }
            }
            g2.dispose();
        }
        catch (Exception e) {
            Debugging.dmsg("DrawingEngine.paintScreen(): " + e);
        }
        this.dRect = null;
    }

    public void paintFullScreen(int x, int y, int w, int h) {
        if (Debugging.isOn() & Debugging.displayOnPlayer()) {
            this.drawDebug();
        }
        this.paintScreenRect(x, y, w, h);
    }

    public void paintFullScreen() {
        this.paintFullScreen(0, 0, 1920, 1080);
    }

    public void paintScreenRect(int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.drawImage(this.getBuffer(), x, y, x + w, y + h, x, y, x + w, y + h, null);
        Toolkit.getDefaultToolkit().sync();
        g2.dispose();
    }

    public void paintScreenRect(Rectangle r) {
        this.paintScreenRect(r.x, r.y, r.width, r.height);
    }

    public void blackoutBuffer(int x, int y, int w, int h) {
        Graphics2D bg = (Graphics2D)this.getBuffer().getGraphics();
        bg.setComposite(AlphaComposite.Src);
        bg.setColor(Color.black);
        bg.fillRect(x, y, w, h);
        bg.dispose();
    }

    public void blackoutBuffer() {
        this.blackoutBuffer(0, 0, 1920, 1080);
    }

    public void clearBuffer(int x, int y, int w, int h) {
        Graphics2D bg = (Graphics2D)this.getBuffer().getGraphics();
        bg.setComposite(AlphaComposite.Clear);
        bg.fillRect(x, y, w, h);
        bg.dispose();
    }

    public void clearBuffer(Rectangle r) {
        this.clearBuffer(r.x, r.y, r.width, r.height);
    }

    public void clearBuffer() {
        this.clearBuffer(0, 0, 1920, 1080);
    }

    public void clearScreen(int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(x, y, w, h);
        if (Debugging.isOn() & Debugging.displayOnPlayer()) {
            this.drawDebug();
            g2.drawImage((Image)this.buffer, 0, 0, null);
        }
        g2.dispose();
    }

    private void drawDebug() {
        ArrayList toWriteArr = Debugging.getDebugMessages();
        Graphics2D buffG = (Graphics2D)this.getBuffer().getGraphics();
        buffG.setColor(debugBackgroundColor);
        buffG.fillRect(0, 0, 640, 540);
        buffG.setColor(Color.white);
        buffG.setFont(Debugging.getFont());
        for (int i = 0; i < toWriteArr.size(); ++i) {
            buffG.drawString(toWriteArr.get(i).toString(), 50, i * 25 + 25);
        }
        buffG.dispose();
    }

    public void paint(Graphics disabled) {
    }

    public void update(Graphics disabled) {
    }

    public void destroy() {
        this.buffer.flush();
        this.scene.dispose();
    }
}

