/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.animation;

import com.zoo.MenuXlet;
import com.zoo.animation.Animation;
import com.zoo.animation.AnimationEndedEvent;
import com.zoo.animation.AnimationEvent;
import com.zoo.animation.AnimationListener;
import java.util.ArrayList;

public class AnimationManager {
    protected ArrayList listeners = new ArrayList();
    protected ArrayList animations = new ArrayList();
    protected boolean animationStarted = false;
    protected long lastFrameTime;
    protected MenuXlet menuXlet;
    private static final long minimumFrameDuration = 16L;

    public AnimationManager(MenuXlet menuXlet) {
        this.menuXlet = menuXlet;
    }

    public void startAnimation() {
        this.animationStarted = true;
        this.lastFrameTime = -1L;
    }

    public void runAnimationSynchronously() {
        this.startAnimation();
        while (this.animationStarted) {
            long startTime = System.currentTimeMillis();
            this.nextFrame();
            this.menuXlet.getLayoutManager().paintScreen();
            long frameDuration = (System.currentTimeMillis() - startTime) % 16L;
            try {
                Thread.sleep(16L - frameDuration);
            }
            catch (InterruptedException e) {}
        }
    }

    public void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    public void nextFrame() {
        if (!this.animationStarted) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long timeDelta = this.lastFrameTime == -1L ? 0L : currentTime - this.lastFrameTime;
        boolean allAnimationsDone = true;
        for (int i = 0; i < this.animations.size(); ++i) {
            Animation animation = (Animation)this.animations.get(i);
            animation.nextFrame(timeDelta);
            if (animation.isFinished()) continue;
            allAnimationsDone = false;
        }
        this.lastFrameTime = currentTime;
        if (allAnimationsDone) {
            this.animations.clear();
            AnimationEndedEvent evt = new AnimationEndedEvent(this);
            this.fireAnimationEvent(evt);
            this.animationStarted = false;
        }
    }

    public void addAnimationListener(AnimationListener listener) {
        this.listeners.add(listener);
    }

    public void removeAnimationListener(AnimationListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAnimationEvent(AnimationEvent evt) {
        AnimationManager animationManager = this;
        synchronized (animationManager) {
            this.notifyAll();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Thread thread = new Thread(new EventRunnable(evt, (AnimationListener)this.listeners.get(i)));
            thread.start();
        }
    }

    protected class EventRunnable
    implements Runnable {
        AnimationEvent evt;
        AnimationListener listener;

        EventRunnable(AnimationEvent evt, AnimationListener listener) {
            this.evt = evt;
            this.listener = listener;
        }

        public void run() {
            this.listener.animationEventReceived(this.evt);
        }
    }
}

