/*
 * Decompiled with CFR 0.152.
 */
package com.zoo;

import com.zoo.StartupLogic;
import com.zoo.StartupLogicFactory;
import com.zoo.animation.AnimationManager;
import com.zoo.animation.DrawingEngine;
import com.zoo.event.TitleChangeEvent;
import com.zoo.event.TitleChangeListener;
import com.zoo.event.TitleChangeManager;
import com.zoo.event.TitleStartedEvent;
import com.zoo.event.TitleStoppedEvent;
import com.zoo.media.Playlist;
import com.zoo.media.VideoPlayer;
import com.zoo.ui.ActionManager;
import com.zoo.ui.LayoutManager;
import com.zoo.ui.components.Preloader;
import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.DiscTrackerManager;
import com.zoo.util.FileUtils;
import com.zoo.util.LanguageManager;
import com.zoo.util.PersistentSettings;
import com.zoo.util.ResourceManager;
import com.zoo.util.SoundManager;
import java.awt.Component;
import javax.tv.service.selection.NormalContentEvent;
import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextException;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.service.selection.ServiceContextListener;
import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;
import javax.tv.xlet.XletStateChangeException;
import org.bluray.ti.DiscEjectedEvent;
import org.bluray.ti.DiscManager;
import org.bluray.ti.DiscStatusEvent;
import org.bluray.ti.DiscStatusListener;
import org.dvb.event.EventManager;
import org.dvb.event.UserEvent;
import org.dvb.event.UserEventListener;
import org.dvb.event.UserEventRepository;

public class MenuXlet
extends Component
implements Xlet,
Runnable,
ServiceContextListener,
UserEventListener,
DiscStatusListener,
TitleChangeListener {
    private static final int STARTUP_LOGIC_TYPE = 0;
    protected XletContext context;
    protected UserEventRepository fUserRepos;
    protected ActionManager actionManager;
    protected LayoutManager layoutManager;
    protected VideoPlayer videoPlayer;
    protected ResourceManager resourceManager;
    protected DrawingEngine drawingEngine;
    protected Preloader preloader;
    protected AnimationManager animationManager;
    public boolean frameworkInitialized = false;
    public boolean initializing = false;
    public boolean waitingForVideoPlayback = false;
    public boolean onStartEventOccurred = false;
    private boolean expectingTitleJump = false;
    public boolean skipTrailer = false;
    public boolean initialTopMenuEntry = true;
    public int curTitle = 65535;
    public boolean tbxActive = false;
    public boolean stillLoading = false;
    public boolean suspendDefaultTitleBehavior = false;
    public boolean hasTrailers = true;
    public boolean hasRNIB = false;
    public boolean REGION_CHECK = false;
    public int REGION_MASK = -1;
    public boolean US_SKU = false;
    public boolean AUS_HYBRID_SKU = false;
    public boolean RUS_HYBRID_SKU = false;
    public boolean DVM_HYBRID_SKU = false;
    public int PARENTAL_LEVEL = -1;
    public static final int DVM = 0;
    public static final int LOGO = 1;
    public static final int LOAD = 2;
    public static final int INITIAL = 3;
    public static final int PLAYBACK = 4;
    private int state = 0;
    public boolean moveOnAfterLoading = false;
    public long startTime;
    protected StartupLogic startuplogic;
    public final Object titleStartedLock = new Object();

    public void destroyXlet(boolean arg0) throws XletStateChangeException {
        try {
            this.startuplogic.destroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Debugging.dmsg("ESS - MenuXlet: destroyXlet() start");
            if (this.videoPlayer != null) {
                this.videoPlayer.updateResumeInfo();
                DiscTrackerManager.rejectFurtherInput = true;
            }
            if (this.layoutManager != null) {
                this.layoutManager.hideMenu();
                this.layoutManager.destroy();
            }
            if (this.videoPlayer != null) {
                DiscTrackerManager.saveDiscTrackerFile();
                this.videoPlayer.destroy();
            }
            if (this.actionManager != null) {
                this.actionManager.destroy();
            }
            EventManager.getInstance().removeUserEventListener((UserEventListener)this);
            DiscManager.getDiscManager().removeDiscStatusEventListener((DiscStatusListener)this);
            Debugging.dmsg("ESS - MenuXlet:destroyXlet() complete");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.notifyDestroyed();
    }

    public void initXlet(XletContext arg0) throws XletStateChangeException {
        Debugging.dmsg("ESS - MenuXlet: initXlet() start");
        this.context = arg0;
        this.curTitle = 65535;
        Debugging.dmsg("ESS - MenuXlet: initXlet() end");
    }

    public void pauseXlet() {
        Debugging.dmsg("MenuXlet.pauseXlet()");
    }

    public void startXlet() throws XletStateChangeException {
        Debugging.dmsg("ESS - MenuXlet: startXlet() start");
        Thread thread = new Thread(this);
        thread.setName("mainAppXlet");
        thread.start();
        Debugging.dmsg("ESS - MeuXlet: startXlet() end");
    }

    public ServiceContext getServiceContext() throws SecurityException, ServiceContextException {
        ServiceContextFactory scf = ServiceContextFactory.getInstance();
        return scf.getServiceContext(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveServiceContextEvent(ServiceContextEvent e) {
        if (e instanceof NormalContentEvent) {
            MenuXlet menuXlet = this;
            synchronized (menuXlet) {
                this.notifyAll();
            }
        }
    }

    public void run() {
        try {
            String[] config = FileUtils.tokenizeString(FileUtils.readFromFile(BDProperties.getVFSRoot() + "/BDMV/JAR/22222/config"), ";");
            for (int i = 0; i < config.length; ++i) {
                String[] setting = FileUtils.tokenizeString(config[i], ",");
                if (setting[0].equalsIgnoreCase("us_sku") && setting[1].equalsIgnoreCase("true")) {
                    this.US_SKU = true;
                }
                if (setting[0].equalsIgnoreCase("aus_hybrid_sku")) {
                    if (!setting[1].equalsIgnoreCase("true")) continue;
                    this.AUS_HYBRID_SKU = true;
                    continue;
                }
                if (setting[0].equalsIgnoreCase("rus_hybrid_sku")) {
                    if (!setting[1].equalsIgnoreCase("true")) continue;
                    this.RUS_HYBRID_SKU = true;
                    continue;
                }
                if (setting[0].equalsIgnoreCase("dvm_hybrid_sku")) {
                    if (!setting[1].equalsIgnoreCase("true")) continue;
                    this.DVM_HYBRID_SKU = true;
                    continue;
                }
                if (setting[0].equalsIgnoreCase("region_check")) {
                    if (!setting[1].equalsIgnoreCase("true")) continue;
                    this.REGION_CHECK = true;
                    continue;
                }
                if (setting[0].equalsIgnoreCase("trailers")) {
                    if (!setting[1].equalsIgnoreCase("false")) continue;
                    this.hasTrailers = false;
                    continue;
                }
                if (setting[0].equalsIgnoreCase("rnib")) {
                    if (!setting[1].equalsIgnoreCase("true")) continue;
                    this.hasRNIB = true;
                    continue;
                }
                if (setting[0].equalsIgnoreCase("parental_level")) {
                    this.PARENTAL_LEVEL = Integer.parseInt(setting[1]);
                    continue;
                }
                if (!setting[0].equalsIgnoreCase("region")) continue;
                int region = 0;
                for (int j = 1; j < setting.length; ++j) {
                    if (setting[j].equalsIgnoreCase("A")) {
                        ++region;
                        continue;
                    }
                    if (setting[j].equalsIgnoreCase("B")) {
                        region += 2;
                        continue;
                    }
                    if (!setting[j].equalsIgnoreCase("C")) continue;
                    region += 4;
                }
                if (region <= 0) continue;
                this.REGION_MASK = region;
            }
        }
        catch (Exception E) {
            Debugging.dmsg("No Config File");
        }
        this.startuplogic = StartupLogicFactory.getInstance(0, this);
        TitleChangeManager.getInstance().addTitleChangeListener(this.startuplogic);
        Thread thread = new Thread(this.startuplogic);
        thread.start();
    }

    public void doPreliminaryStartupLogic() {
        String org_id = (String)this.context.getXletProperty("dvb.org.id");
        String app_id = (String)this.context.getXletProperty("dvb.app.id");
        String disc_id = DiscManager.getDiscManager().getCurrentDisc().getId();
        PersistentSettings.Initialise(org_id, app_id);
        DiscTrackerManager.init(org_id, app_id, disc_id, this);
        this.fUserRepos = new UserEventRepository("rc_events");
        this.fUserRepos.addAllArrowKeys();
        this.fUserRepos.addAllColourKeys();
        this.fUserRepos.addAllNumericKeys();
        this.fUserRepos.addKey(10);
        this.fUserRepos.addKey(461);
        this.fUserRepos.addKey(442);
        EventManager.getInstance().addUserEventListener((UserEventListener)this, this.fUserRepos);
        DiscManager.getDiscManager().addDiscStatusEventListener((DiscStatusListener)this);
        this.drawingEngine = new DrawingEngine();
        this.resourceManager = new ResourceManager();
        this.layoutManager = new LayoutManager();
        this.layoutManager.init(this);
        this.animationManager = new AnimationManager(this);
        this.actionManager = new ActionManager();
        this.actionManager.init(this);
        LanguageManager.init(this);
        this.videoPlayer = new VideoPlayer();
        this.videoPlayer.init(this);
        SoundManager.initSounds();
        this.videoPlayer.addPlayerListener(this.startuplogic);
    }

    public void relinquishControl() {
        TitleChangeManager.getInstance().addTitleChangeListener(this);
    }

    public void setMenuLanguage(String language, int dialect) {
        if (this.startuplogic != null) {
            this.startuplogic.setMenuLanguage(language, dialect);
        }
    }

    public XletContext getContext() {
        return this.context;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public VideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public DrawingEngine getDrawingEngine() {
        return this.drawingEngine;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public void receiveDiscStatusEvent(DiscStatusEvent evt) {
        if (evt instanceof DiscEjectedEvent) {
            DiscTrackerManager.saveDiscTrackerFile();
            Debugging.dmsg("DiscEjectedEvent");
        }
    }

    public void notifyTitleStopped(int title_id) {
    }

    public void loadAssets() {
        ResourceManager.setFileRoot(BDProperties.getVFSRoot() + "/BDMV/JAR/00000/");
        this.layoutManager.load();
        this.videoPlayer.init(this);
        this.videoPlayer.readResumeInfo();
        LanguageManager.setDefaultMapping();
    }

    public void notifyTitleStarted(int title_id) {
        this.layoutManager.resumeRendering();
        if (title_id == 0) {
            if (this.videoPlayer.getCurrentPlaylist().getOnMenu() != null && !this.videoPlayer.getCurrentPlaylist().getOnMenu().equals("") && !this.suspendDefaultTitleBehavior) {
                Playlist.overrideOnStart(null);
                this.actionManager.handleActions(this.videoPlayer.getCurrentPlaylist().getOnMenu());
            }
        } else {
            DiscTrackerManager.rejectFurtherInput = false;
        }
    }

    public void releaseAssets() {
        try {
            this.layoutManager.destroy();
        }
        catch (Exception e) {
            Debugging.dmsg("failed to relaseAssets() - layoutManager: " + e);
        }
        try {
            this.actionManager.destroy();
        }
        catch (Exception e) {
            Debugging.dmsg("failed to relaseAssets() - actionManager:" + e);
        }
        try {
            this.videoPlayer.destroy();
        }
        catch (Exception e) {
            Debugging.dmsg("failed to relaseAssets() - videoPlayer: " + e);
        }
        try {
            SoundManager.destroySounds();
        }
        catch (Exception e) {
            Debugging.dmsg("failed to destroySounds() - SoundManager: " + e);
        }
    }

    public void userEventReceived(UserEvent evt) {
        if (this.startuplogic != null) {
            class EventRunnable
            implements Runnable {
                UserEvent evt;
                UserEventListener listener;

                EventRunnable(UserEvent evt, UserEventListener listener) {
                    this.evt = evt;
                    this.listener = listener;
                }

                public void run() {
                    this.listener.userEventReceived(this.evt);
                }
            }
            Thread thread = new Thread(new EventRunnable(evt, this.startuplogic));
            thread.start();
            Debugging.dmsg("start up logic != null");
        }
        Debugging.dmsg("start up logic == null");
        this.layoutManager.userEventReceived(evt);
    }

    public void titleChangeEventReceived(TitleChangeEvent evt) {
        Debugging.dmsg("titleChangeEventReceived = " + evt.toString());
        if (evt instanceof TitleStoppedEvent) {
            Debugging.dmsg("evt instanceof TitleStoppedEvent");
            if (this.videoPlayer != null) {
                this.videoPlayer.setLockoutTimeline(true);
                DiscTrackerManager.rejectFurtherInput = true;
                if (this.layoutManager != null) {
                    this.layoutManager.pauseRendering();
                    this.layoutManager.resetMenu();
                }
                this.videoPlayer.getPlayer().stop();
                Debugging.dmsg("                 lockoutTimeline = true");
            }
        } else if (evt instanceof TitleStartedEvent) {
            this.notifyTitleStarted(evt.getTitle());
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }
}

