# Blu-print authoring Instruction
This is a standard blu-print project following standard jmat/kudu naming conventions should be good. As for forced streams, paramount will always have embedded streams except for japanese dub subs. When we have dub subs you need to name the dub stream jpn_DUB_. If for some reason the streams are separate rather than embedded, use _TXT_ in the stream names.
Other things to modify that are unique to paramount BD from all other templates are both located in the first play script.
1. Has BD live flag, should be set to true or false depending on sku. normally only domestic releasing discs will have bd-live
	1. If there is bd-live you need to change the setup files (path found in the first play script)
	2. Modify the V-ISAN
	3. run the bd-live verifier on the image and generate a bd-live report. (W:\BD\Tools\Oasis\Oasis.exe)
2. If there is region lockout this must be modified in the global macros tab of the hdmv editor, 
	just comment out the default all regions, and uncomment the correct region configuration.

# JMAT authoring Instructions
1. Project Languages:
	1. Add all the available LU’s
2. Add groups:
	1. Adds the thumbnails. Drag and drop the images in click sort 
	2. Add the _n numbers (for bd search *_n.png for uhd search *_n_)
	3. Add the _s numbers (for bd search *_s.png for uhd search *_s_)
	4. Add the _a numbers (for bd search *_a.png for uhd search *_a_)

3. Add fonts:
    1. import scanbarfont hit new font.
    2. Select the scanbar single png
	    1. Import the font strip info file, if the file does not exist create a new txt and insert the characters located in the font usually the following -0123456789:
	    2. When importing the scanbar font the best way to get a good kerning is going to the preview and typing in a timecode usually 00:00:00 will be fine and kerning 2 looks ok but this is more of a personal judgment
    3. Import bookmarkfont hit new font.
	    1. Select the bookmark single png
	    2. Import the font strip info file, if the file does not exist create a new txt and insert the characters located in the font usually the following -0123456789:
	    3. When importing the bookmark font the best way to get a good kerning is going to the preview and typing in a possible bookmark usually 00\n00:00:00 will be fine and Global Shift 5 looks ok but this is more of a personal judgment, also make sure to add a line spacing of about 5 as well.


##### From this point clear all the coordinates.
##### When building menus you must always load specific menus at a time since the wizard will not be able to properly build menus if you are loading the same image in duplicate menus, following the below steps should lead to correct menu layouts.

1. Open Load Coordinates – Clear all coordinates and close the menu
2. Load onQ File 
3. Hit setup project
4. Delete any containers that are not being used:
	a. BDLive Messages Menu if its a sku with no bd-live
	b. Any Extras Menus that are not used, if no commentary exists delete the ExtrasMenu_Commentary, 
		if no extras exist just delete all ExtrasMenu_ and the extras Menu containers.
	c. Delete the Gallery menu if there are no galleries
	d. If there is no SUS/ILSM Page delete the Selector Menu
5. Load Coordinates, make sure that each lu only loads that lu’s coordinates. Load all the following at once (sometimes the easiest way to load these is to go to the root folder of all the menu LU’s and search *.csv and select the ones you want to load):
	1. scanbar – this is generic so just loading in the main LU will be fine
	2. Start up Screen – this is generic so just loading in the main LU will be fine
	3. main
	4. bookmarks
6. Go to the Start up screen folder. If there isnt a 1920x1080 png located in the folder open the 3840x2160 tiff and save a png version that is 1920x1080. This will be used by jmat for previewing.
7. Uncheck the scenes and settings menu in the default menus, then click Generate Default menus
8. Click on the ILSM Menu in the wizard and drag all the languages that are on the SUS page. If there are languages that have multiple regions ALWAYS use the version that contains the region code. For example, for portuguese never use the portuguese only option, either use Portuguese BP or Portuguese PP. The reason is due to the warning cards that will play will be based on the region you select. Not selecting a region specific button will not play any warnings.
9. In the main LU go to the messages menu and move the timcode box to fit within the bookmarks image. Afterwards right click on the multi-layer and “fit to children -> only this object” DO NOT FIT TO ALL CHILDREN. Then click on the bookmarkAdded Object and do the same thing.
10. In the main LU go to the timeline menu and make sure that the current/duration timecodes are centered horizontally and vertically within its box. The easiest way to achieve this is make sure that the text objets fit is set to clip not dynamic and line up the bounds of the box with the bounds of the text box. Afterwards run fit to “fit to children -> only this object” on the parent object of the text.
11. Delete all current coordinates, then Load Coordinates make sure that each lu only loads that lu’s coordinates. Load all the following: 	
	1. scenes
	2. Thumbs
	3. settings (if there is commentary then you will need to change the starting row to only import after the commentary section. We will load the commentary subs afterwards. For now just load the audio and sub panels.
12. Uncheck all other options in the defaults menus and select the scenes and settings menus. Click on Generate default menus.
13. If there are no commentary subs you can delete the commentary subtitle container from the menu.
14. if there is no atmos info and the container exists then the atmos info container can be deleted.
15. if the first tier and pop up menus do not have the a background then you can delete the main_bg and pop_bg containers, the same with the special features button if there are no special features you can delete those buttons. Then run fit to children on both the containers.

### Audio/ Stream Mapping
Once you are complete with setting up the default menus. Lets move onto the audio/sub targets button.
1. Click on that button to open up the audio/sub wizard
2. select the setup menu
3. Select the audio or sub list.
4. drag all the streams over to their respective buttons
5. if its the sub page name the last button ‘none’ as that will turn subs off.
6. hit apply
7. repeat steps 3 – 6 for the opposite menu

### Extras menus 
1. Open the extras menu wizard by clicking on the extras menu button
2. create all the necessary sub tiers you need. By default the template has : 
	1. commentary extras page
	2. deleted scenes extras page
3. Open the Load Coordinates window and clear all previous coordinates.


# KUDU Authoring Instructions
1. Open the project settings and modify any flags that need to be changed. Most of the flags should be very straight forward. If there are any questions about what the flags do please email me (gerardo.parker@pixelogicmedia.com) and I will add it to this section.
2. Test out all the menus, remember that multi column menus should always go to the nearest button if they do not go to the nearest button you can override the buttons direction by overriding a function at the project level and manually setting the buttons direction.

```java
	public void OverrideNavigation()
	{
		if(TemplateConfiguration.currentMenuLanguage.endsWith("eng"))
		{
			navBuilder.OverrideNavigation("eng_Audio01", "eng_ADES_", Notifications.RIGHT_ARROW_PRESSED);			
		}
	}	
```
3. If any menus that use NavBuilder are single column for example Extras menus go into the menu class and in the onLoad function add the following line of code: navBuilder.SetMultiColumn(false);
Example:

```java
	public void extrasmenu_DeletedScenes_onLoad(Object sender, Object param)
	{
		/***************
		 * 
		 * This basically removes the custom nav and just puts it all in one list
		 * 
		 *********/
		navBuilder.SetMultiColumn(false);
		// TODO Auto-generated method stub
		onLoad(sender,param);
	}	
```




